import abc
from _typeshed import Incomplete
from typing import Any
from typing_extensions import TypeAlias

from qrcode.image.styles.moduledrawers.base import QRModuleDrawer
from qrcode.main import QRCode

DrawerAliases: TypeAlias = dict[str, tuple[type[QRModuleDrawer], dict[str, Any]]]

class BaseImage(metaclass=abc.ABCMeta):
    kind: str | None
    allowed_kinds: tuple[str] | None
    needs_context: bool
    needs_processing: bool
    needs_drawrect: bool
    border: Incomplete
    width: Incomplete
    box_size: Incomplete
    pixel_size: Incomplete
    modules: Incomplete
    def __init__(self, border, width, box_size, *args, **kwargs) -> None: ...
    @abc.abstractmethod
    def drawrect(self, row, col): ...
    def drawrect_context(self, row: int, col: int, qr: QRCode[Incomplete]): ...
    def process(self) -> None: ...
    @abc.abstractmethod
    def save(self, stream, kind: Incomplete | None = None): ...
    def pixel_box(self, row, col): ...
    @abc.abstractmethod
    def new_image(self, **kwargs) -> Any: ...
    def init_new_image(self) -> None: ...
    def get_image(self, **kwargs): ...
    def check_kind(self, kind, transform: Incomplete | None = None): ...
    def is_eye(self, row: int, col: int): ...

class BaseImageWithDrawer(BaseImage, metaclass=abc.ABCMeta):
    default_drawer_class: type[QRModuleDrawer]
    drawer_aliases: DrawerAliases
    def get_default_module_drawer(self) -> QRModuleDrawer: ...
    def get_default_eye_drawer(self) -> QRModuleDrawer: ...
    needs_context: bool
    module_drawer: QRModuleDrawer
    eye_drawer: QRModuleDrawer
    def __init__(
        self, *args, module_drawer: QRModuleDrawer | str | None = None, eye_drawer: QRModuleDrawer | str | None = None, **kwargs
    ) -> None: ...
    def get_drawer(self, drawer: QRModuleDrawer | str | None) -> QRModuleDrawer | None: ...
    def init_new_image(self): ...
    def drawrect_context(self, row: int, col: int, qr: QRCode[Incomplete]): ...
