/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.border;

import java.util.ArrayList;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.stylehandler.ListOfPairReadHandler;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class BackgroundPositionReadHandler
extends ListOfPairReadHandler {
    public static final CSSNumericValue CENTER = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 50.0);
    public static final CSSNumericValue TOP = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 0.0);
    public static final CSSNumericValue LEFT = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 0.0);
    public static final CSSNumericValue BOTTOM = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 100.0);
    public static final CSSNumericValue RIGHT = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 100.0);

    @Override
    protected CSSValue parseFirstPosition(LexicalUnit lexicalUnit) {
        if (lexicalUnit == null) {
            return null;
        }
        if (lexicalUnit.getLexicalUnitType() == 35) {
            if ("left".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return LEFT;
            }
            if ("center".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return CENTER;
            }
            if ("right".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return RIGHT;
            }
            if ("top".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return TOP;
            }
            if ("bottom".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return BOTTOM;
            }
            return null;
        }
        if (lexicalUnit.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, lexicalUnit.getFloatValue());
        }
        if (CSSValueFactory.isLengthValue(lexicalUnit)) {
            return CSSValueFactory.createLengthValue(lexicalUnit);
        }
        return null;
    }

    @Override
    protected void addToResultList(ArrayList arrayList, CSSValue cSSValue, CSSValue cSSValue2) {
        if (cSSValue == TOP || cSSValue == BOTTOM) {
            super.addToResultList(arrayList, cSSValue2, cSSValue);
        } else if (cSSValue2 == LEFT || cSSValue2 == RIGHT) {
            super.addToResultList(arrayList, cSSValue2, cSSValue);
        } else {
            super.addToResultList(arrayList, cSSValue, cSSValue2);
        }
    }

    @Override
    protected CSSValue parseSecondPosition(LexicalUnit lexicalUnit, CSSValue cSSValue) {
        if (lexicalUnit == null) {
            return CENTER;
        }
        if (lexicalUnit.getLexicalUnitType() == 35) {
            if ("left".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return LEFT;
            }
            if ("center".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return CENTER;
            }
            if ("right".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return RIGHT;
            }
            if ("top".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return TOP;
            }
            if ("bottom".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return BOTTOM;
            }
            return null;
        }
        if (lexicalUnit.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, lexicalUnit.getFloatValue());
        }
        if (CSSValueFactory.isLengthValue(lexicalUnit)) {
            return CSSValueFactory.createLengthValue(lexicalUnit);
        }
        return CENTER;
    }
}

