/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.internal.console;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.discovery.DiscoveryServiceRegistry;
import org.openhab.core.io.console.Console;
import org.openhab.core.io.console.extensions.AbstractConsoleCommandExtension;
import org.openhab.core.io.console.extensions.ConsoleCommandExtension;
import org.openhab.core.thing.ThingTypeUID;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ConsoleCommandExtension.class})
@NonNullByDefault
public class DiscoveryConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private static final String SUBCMD_START = "start";
    private static final String SUBCMD_BACKGROUND_DISCOVERY_ENABLE = "enableBackgroundDiscovery";
    private static final String SUBCMD_BACKGROUND_DISCOVERY_DISABLE = "disableBackgroundDiscovery";
    private final Logger logger = LoggerFactory.getLogger(DiscoveryConsoleCommandExtension.class);
    private final DiscoveryServiceRegistry discoveryServiceRegistry;
    private final ConfigurationAdmin configurationAdmin;

    @Activate
    public DiscoveryConsoleCommandExtension(@Reference DiscoveryServiceRegistry discoveryServiceRegistry, @Reference ConfigurationAdmin configurationAdmin) {
        super("discovery", "Control the discovery mechanism.");
        this.discoveryServiceRegistry = discoveryServiceRegistry;
        this.configurationAdmin = configurationAdmin;
    }

    public void execute(String[] args, Console console) {
        block23: {
            block21: {
                String subCommand;
                if (args.length <= 0) break block21;
                switch (subCommand = args[0]) {
                    case "start": {
                        if (args.length > 1) {
                            String arg1 = args[1];
                            if (arg1.contains(":")) {
                                ThingTypeUID thingTypeUID = new ThingTypeUID(arg1);
                                this.runDiscoveryForThingType(console, thingTypeUID, args.length > 2 ? args[2] : null);
                            } else {
                                this.runDiscoveryForBinding(console, arg1, args.length > 2 ? args[2] : null);
                            }
                        } else {
                            console.println("Specify thing type id or binding id to discover: discovery start <thingTypeUID|bindingID> (e.g. \"hue:bridge\" or \"hue\")");
                        }
                        return;
                    }
                    case "enableBackgroundDiscovery": {
                        if (args.length > 1) {
                            String discoveryServiceName = args[1];
                            this.configureBackgroundDiscovery(console, discoveryServiceName, true);
                        } else {
                            console.println("Specify discovery service PID to configure background discovery: discovery enableBackgroundDiscovery <PID> (e.g. \"hue.discovery\")");
                        }
                        return;
                    }
                    case "disableBackgroundDiscovery": {
                        if (args.length > 1) {
                            String discoveryServiceName = args[1];
                            this.configureBackgroundDiscovery(console, discoveryServiceName, false);
                        } else {
                            console.println("Specify discovery service PID to configure background discovery: discovery disableBackgroundDiscovery <PID> (e.g. \"hue.discovery\")");
                        }
                        return;
                    }
                }
                break block23;
            }
            console.println(this.getUsages().get(0));
        }
    }

    private void configureBackgroundDiscovery(Console console, String discoveryServicePID, boolean enabled) {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration(discoveryServicePID);
            Hashtable<String, Boolean> properties = configuration.getProperties();
            if (properties == null) {
                properties = new Hashtable<String, Boolean>();
            }
            ((Dictionary)properties).put("background", enabled);
            configuration.update(properties);
            console.println("Background discovery for discovery service '" + discoveryServicePID + "' was set to " + enabled + ".");
        }
        catch (IOException ex) {
            String errorText = "Error occurred while trying to configure background discovery with PID '" + discoveryServicePID + "': " + ex.getMessage();
            this.logger.error(errorText, (Throwable)ex);
            console.println(errorText);
        }
    }

    private void runDiscoveryForThingType(Console console, ThingTypeUID thingTypeUID, @Nullable String input) {
        this.discoveryServiceRegistry.startScan(thingTypeUID, input, null);
    }

    private void runDiscoveryForBinding(Console console, String bindingId, @Nullable String input) {
        this.discoveryServiceRegistry.startScan(bindingId, input, null);
    }

    public List<String> getUsages() {
        return List.of(this.buildCommandUsage("start <thingTypeUID|bindingID> [<code>]", "runs a discovery on a given thing type or binding"), this.buildCommandUsage("enableBackgroundDiscovery <PID>", "enables background discovery for the discovery service with the given PID"), this.buildCommandUsage("disableBackgroundDiscovery <PID>", "disables background discovery for the discovery service with the given PID"));
    }
}

