/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.websocket.audio.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioException;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.AudioSource;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.audio.PipedAudioStream;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.io.websocket.audio.internal.PCMWebSocketAudioUtil;
import org.openhab.core.io.websocket.audio.internal.PCMWebSocketConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class PCMWebSocketAudioSource
implements AudioSource {
    private static final int SUPPORTED_BIT_DEPTH = 16;
    private static final int SUPPORTED_SAMPLE_RATE = 16000;
    private static final int SUPPORTED_CHANNELS = 1;
    public static AudioFormat supportedFormat = new AudioFormat("WAVE", "PCM_SIGNED", Boolean.valueOf(false), Integer.valueOf(16), null, Long.valueOf(16000L), Integer.valueOf(1));
    private final Logger logger = LoggerFactory.getLogger(PCMWebSocketAudioSource.class);
    private final String sourceId;
    private final String sourceLabel;
    private final PCMWebSocketConnection websocket;
    private @Nullable PipedOutputStream sourceAudioPipedOutput;
    private @Nullable PipedInputStream sourceAudioPipedInput;
    private @Nullable InputStream sourceAudioStream;
    private final PipedAudioStream.Group streamGroup = PipedAudioStream.newGroup((AudioFormat)supportedFormat);
    private @Nullable Future<?> sourceWriteTask;
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"pcm-audio-source");
    private byte @Nullable [] streamId;

    public PCMWebSocketAudioSource(String id, String label, PCMWebSocketConnection websocket) {
        this.sourceId = id;
        this.sourceLabel = label;
        this.websocket = websocket;
    }

    public String getId() {
        return this.sourceId;
    }

    public String getLabel(@Nullable Locale locale) {
        return this.sourceLabel;
    }

    public Set<AudioFormat> getSupportedFormats() {
        return Set.of(supportedFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioStream getInputStream(AudioFormat audioFormat) throws AudioException {
        try {
            PipedAudioStream stream = this.streamGroup.getAudioStreamInGroup();
            PipedAudioStream.Group group = this.streamGroup;
            synchronized (group) {
                if (this.streamGroup.size() == 1) {
                    this.logger.debug("Send start listening {}", (Object)this.getId());
                    this.streamId = null;
                    this.websocket.setListening(true);
                }
            }
            stream.onClose(this::onStreamClose);
            return stream;
        }
        catch (IOException e) {
            throw new AudioException((Throwable)e);
        }
    }

    public void close() throws Exception {
        this.streamGroup.close();
    }

    public void writeToStreams(byte[] id, int sampleRate, int bitDepth, int channels, byte[] payload) {
        boolean needsConvert;
        if (this.streamGroup.isEmpty()) {
            this.logger.debug("Source already disposed, ignoring data");
            return;
        }
        if (this.streamId == null) {
            this.streamId = id;
        } else if (!Arrays.equals(this.streamId, id)) {
            this.logger.warn("Only one concurrent data line is supported, ignoring data from source stream {}", (Object)id);
            return;
        }
        boolean bl = needsConvert = sampleRate != 16000 || bitDepth != 16 || channels != 1;
        if (!needsConvert) {
            this.streamGroup.write(payload);
            return;
        }
        if (this.sourceAudioPipedOutput == null || this.sourceAudioStream == null) {
            try {
                this.sourceAudioPipedOutput = new PipedOutputStream();
                PipedInputStream sourceAudioPipedInput = this.sourceAudioPipedInput = new PipedInputStream(this.sourceAudioPipedOutput, sampleRate * (bitDepth / 8) * channels * 2);
                this.logger.debug("Enabling converting pcm audio for the audio source stream: sample rate {}, bit depth {}, channels {} => sample rate {}, bit depth {}, channels {}", new Object[]{sampleRate, bitDepth, channels, 16000, 16, 1});
                this.sourceAudioStream = PCMWebSocketAudioUtil.getPCMStreamNormalized(sourceAudioPipedInput, sampleRate, bitDepth, channels, 16000, 16, 1);
                this.sourceWriteTask = this.scheduler.submit(() -> {
                    int bytesPer250ms = 8000;
                    while (true) {
                        byte[] convertedPayload;
                        try {
                            convertedPayload = this.sourceAudioStream.readNBytes(bytesPer250ms);
                            Thread.sleep(0L);
                        }
                        catch (InterruptedIOException | InterruptedException e) {
                            continue;
                        }
                        catch (IOException e) {
                            if (e.getMessage().contains("Pipe closed")) {
                                return;
                            }
                            this.logger.error("Error reading converted audio data", (Throwable)e);
                            continue;
                        }
                        this.streamGroup.write(convertedPayload);
                    }
                });
            }
            catch (IOException e) {
                this.logger.error("Unable to setup audio source stream", (Throwable)e);
                return;
            }
        }
        try {
            this.sourceAudioPipedOutput.write(payload);
        }
        catch (IOException e) {
            this.logger.error("Error converting source audio format", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStreamClose() {
        this.logger.debug("Unregister source audio stream for '{}'", (Object)this.getId());
        PipedAudioStream.Group group = this.streamGroup;
        synchronized (group) {
            if (this.streamGroup.isEmpty()) {
                this.logger.debug("Send stop listening {}", (Object)this.getId());
                this.websocket.setListening(false);
                if (this.sourceWriteTask != null) {
                    this.sourceWriteTask.cancel(true);
                    this.sourceWriteTask = null;
                }
                if (this.sourceAudioStream != null) {
                    try {
                        this.sourceAudioStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.sourceAudioStream = null;
                }
                if (this.sourceAudioPipedOutput != null) {
                    try {
                        this.sourceAudioPipedOutput.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.sourceAudioPipedOutput = null;
                }
                if (this.sourceAudioPipedInput != null) {
                    try {
                        this.sourceAudioPipedInput.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.sourceAudioPipedInput = null;
                }
                this.streamId = null;
            }
        }
    }
}

