/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.requirement;

import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibUtil;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/python/inspections/requirement/InstalledButNotDeclaredChecker;", "", "ignoredPackages", "", "", "pythonPackageManager", "Lcom/jetbrains/python/packaging/management/PythonPackageManager;", "<init>", "(Ljava/util/Collection;Lcom/jetbrains/python/packaging/management/PythonPackageManager;)V", "getIgnoredPackages", "()Ljava/util/Collection;", "getPythonPackageManager", "()Lcom/jetbrains/python/packaging/management/PythonPackageManager;", "getUndeclaredPackageName", "importedPyModule", "isIgnoredOrStandardPackage", "", "packageName", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nInstalledButNotDeclaredChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstalledButNotDeclaredChecker.kt\ncom/jetbrains/python/inspections/requirement/InstalledButNotDeclaredChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n1761#2,3:34\n*S KotlinDebug\n*F\n+ 1 InstalledButNotDeclaredChecker.kt\ncom/jetbrains/python/inspections/requirement/InstalledButNotDeclaredChecker\n*L\n21#1:34,3\n*E\n"})
public final class InstalledButNotDeclaredChecker {
    @NotNull
    private final Collection<String> ignoredPackages;
    @NotNull
    private final PythonPackageManager pythonPackageManager;

    public InstalledButNotDeclaredChecker(@NotNull Collection<String> ignoredPackages, @NotNull PythonPackageManager pythonPackageManager) {
        Intrinsics.checkNotNullParameter(ignoredPackages, (String)"ignoredPackages");
        Intrinsics.checkNotNullParameter((Object)pythonPackageManager, (String)"pythonPackageManager");
        this.ignoredPackages = ignoredPackages;
        this.pythonPackageManager = pythonPackageManager;
    }

    @NotNull
    public final Collection<String> getIgnoredPackages() {
        return this.ignoredPackages;
    }

    @NotNull
    public final PythonPackageManager getPythonPackageManager() {
        return this.pythonPackageManager;
    }

    @Nullable
    public final String getUndeclaredPackageName(@NotNull String importedPyModule) {
        boolean bl;
        String packageName;
        block7: {
            Intrinsics.checkNotNullParameter((Object)importedPyModule, (String)"importedPyModule");
            packageName = PyPsiPackageUtil.moduleToPackageName$default((PyPsiPackageUtil)PyPsiPackageUtil.INSTANCE, (String)importedPyModule, null, (int)2, null);
            if (this.isIgnoredOrStandardPackage(importedPyModule)) {
                return null;
            }
            if (!PyPIPackageUtil.INSTANCE.isInPyPI(packageName)) {
                return null;
            }
            Object object = this.pythonPackageManager.getDependencyManager();
            if (object == null || (object = object.getDependencies()) == null) {
                object = CollectionsKt.emptyList();
            }
            Object requirements = object;
            Iterable $this$any$iv = (Iterable)requirements;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PyRequirement it = (PyRequirement)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)packageName)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        return packageName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIgnoredOrStandardPackage(String packageName) {
        if (this.ignoredPackages.contains(packageName)) return true;
        if (Intrinsics.areEqual((Object)packageName, (Object)"setuptools")) return true;
        Set set = PyStdlibUtil.getPackages();
        if (set == null) return false;
        if (!set.contains(packageName)) return false;
        return true;
    }
}

