/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import git4idea.conflicts.GitConflictsUtil;
import git4idea.repo.GitConflict;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\u0007H\u0014J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a8\u0006\u0016"}, d2={"Lgit4idea/conflicts/ConflictChangesBrowserNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lgit4idea/repo/GitConflict;", "conflict", "<init>", "(Lgit4idea/repo/GitConflict;)V", "isFile", "", "isDirectory", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "expanded", "hasFocus", "getTextPresentation", "", "toString", "compareUserObjects", "", "o2", "intellij.vcs.git"})
final class ConflictChangesBrowserNode
extends ChangesBrowserNode<GitConflict> {
    public ConflictChangesBrowserNode(@NotNull GitConflict conflict) {
        Intrinsics.checkNotNullParameter((Object)conflict, (String)"conflict");
        super((Object)conflict);
    }

    protected boolean isFile() {
        return true;
    }

    protected boolean isDirectory() {
        return false;
    }

    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        GitConflict conflict = (GitConflict)this.getUserObject();
        FilePath filePath = conflict.getFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        FilePath filePath2 = filePath;
        renderer.appendFileName(filePath2.getVirtualFile(), filePath2.getName(), FileStatus.MERGED_WITH_CONFLICTS.getColor());
        if (renderer.isShowFlatten()) {
            this.appendParentPath(renderer, filePath2.getParentPath());
        }
        if (!renderer.isShowFlatten() && this.getFileCount() != 1 || this.getDirectoryCount() != 0) {
            this.appendCount((ColoredTreeCellRenderer)renderer);
        }
        Intrinsics.checkNotNull((Object)conflict);
        String conflictType = GitConflictsUtil.INSTANCE.getConflictType$intellij_vcs_git(conflict);
        renderer.append(FontUtil.spaceAndThinSpace() + conflictType, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        renderer.setIcon(filePath2, filePath2.isDirectory() || !this.isLeaf());
    }

    @NotNull
    public String getTextPresentation() {
        String string = ((GitConflict)this.getUserObject()).getFilePath().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public String toString() {
        String string = FileUtil.toSystemDependentName((String)((GitConflict)this.getUserObject()).getFilePath().getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        return string;
    }

    public int compareUserObjects(@NotNull GitConflict o2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        return ChangesBrowserNode.compareFilePaths((FilePath)((GitConflict)this.getUserObject()).getFilePath(), (FilePath)o2.getFilePath());
    }
}

