/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac.parsers;

import com.intellij.ide.startup.importSettings.models.KeyBinding;
import com.intellij.ide.startup.importSettings.models.PatchedKeymap;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.vsmac.mappings.KeyBindingsMappings;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac.parsers.KeyBindingsParserKt;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.SmartList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/parsers/KeyBindingsParser;", "", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "<init>", "(Lcom/intellij/ide/startup/importSettings/models/Settings;)V", "customShortcuts", "", "Lcom/intellij/ide/startup/importSettings/models/KeyBinding;", "process", "", "file", "Ljava/nio/file/Path;", "processKeyBindings", "root", "Lorg/jdom/Element;", "processCurrentScheme", "scheme", "addCustomShortcut", "foreignCommandId", "", "foreignShortcuts", "parseShortcuts", "", "Lcom/intellij/openapi/actionSystem/KeyboardShortcut;", "str", "getKeyStroke", "Ljavax/swing/KeyStroke;", "s", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nKeyBindingsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyBindingsParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/parsers/KeyBindingsParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n295#2,2:110\n1869#2,2:112\n1869#2,2:114\n1869#2,2:117\n1#3:116\n*S KotlinDebug\n*F\n+ 1 KeyBindingsParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/parsers/KeyBindingsParser\n*L\n39#1:110,2\n53#1:112,2\n84#1:114,2\n102#1:117,2\n*E\n"})
public final class KeyBindingsParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Settings settings;
    @NotNull
    private final List<KeyBinding> customShortcuts;
    @NotNull
    private static final String CURRENT = "current";
    @NotNull
    private static final String COMMAND = "command";
    @NotNull
    private static final String SHORTCUT = "shortcut";

    public KeyBindingsParser(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        this.customShortcuts = new ArrayList();
    }

    public final void process(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            KeyBindingsParserKt.access$getLogger$p().info("Processing a file: " + file);
            Element element = JDOMUtil.load((Path)file);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
            Element root = element;
            this.processKeyBindings(root);
        }
        catch (Throwable t) {
            KeyBindingsParserKt.access$getLogger$p().warn(t);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void processKeyBindings(Element root) {
        block5: {
            v0 = root.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getChildren(...)");
            $this$firstOrNull$iv = v0;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                block7: {
                    block6: {
                        scheme = (Element)element$iv;
                        $i$a$-firstOrNull-KeyBindingsParser$processKeyBindings$currentScheme$1 = false;
                        v1 = scheme;
                        if (v1 != null && (v1 = v1.getAttributes()) != null) break block6;
                        v2 = false;
                        break block7;
                    }
                    schemeAttributes = v1;
                    if (schemeAttributes.size() != 1) ** GOTO lbl-1000
                    v3 = (Attribute)schemeAttributes.get(0);
                    if (Intrinsics.areEqual((Object)(v3 != null ? v3.getValue() : null), (Object)"current")) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                }
                if (!v2) continue;
                v4 = element$iv;
                break block5;
            }
            v4 = null;
        }
        v5 = v4;
        if (v5 == null) {
            return;
        }
        currentScheme = v5;
        this.processCurrentScheme(currentScheme);
        km = this.settings.getKeymap();
        if (((Collection)this.customShortcuts).isEmpty() == false && km != null) {
            this.settings.setKeymap(new PatchedKeymap(km.getTransferableId(), km, this.customShortcuts, CollectionsKt.emptyList()));
        }
    }

    private final void processCurrentScheme(Element scheme) {
        List list = scheme.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element binding = (Element)element$iv;
            boolean bl = false;
            try {
                Object object;
                Object attributes;
                Object object2 = binding;
                if (object2 == null) continue;
                if ((object2 = object2.getAttributes()) == null || (attributes = object2).size() != 2) continue;
                Object object3 = (Attribute)attributes.get(0);
                boolean bl2 = object3 != null && (object3 = object3.getName()) != null ? ((String)object3).equals(COMMAND) : false;
                if (!bl2) continue;
                Object object4 = (Attribute)attributes.get(1);
                boolean bl3 = object4 != null && (object4 = object4.getName()) != null ? ((String)object4).equals(SHORTCUT) : false;
                if (!bl3 || (object = (Attribute)attributes.get(0)) == null || (object = object.getValue()) == null) continue;
                Object commandId = object;
                Object object5 = (Attribute)attributes.get(1);
                if (object5 == null || (object5 = object5.getValue()) == null) continue;
                Object shortcuts = object5;
                this.addCustomShortcut((String)commandId, (String)shortcuts);
            }
            catch (Throwable t) {
                KeyBindingsParserKt.access$getLogger$p().warn(t);
            }
        }
    }

    private final void addCustomShortcut(String foreignCommandId, String foreignShortcuts) {
        String string = KeyBindingsMappings.INSTANCE.commandIdMap(foreignCommandId);
        if (string == null) {
            return;
        }
        String commandId = string;
        List<KeyboardShortcut> list = this.parseShortcuts(foreignShortcuts);
        if (list == null) {
            return;
        }
        List<KeyboardShortcut> shortcuts = list;
        if (!Intrinsics.areEqual(KeyBindingsMappings.INSTANCE.getDefaultVSMacKeymap().get(commandId), shortcuts)) {
            this.customShortcuts.add(new KeyBinding(commandId, shortcuts, null, 4, null));
        }
    }

    private final List<KeyboardShortcut> parseShortcuts(String str) {
        Object object;
        SmartList shortcuts = new SmartList();
        Object object2 = new char[]{' '};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)str, (char[])object2, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeyStroke firstKeyStroke;
            String shortcut = (String)element$iv;
            boolean bl = false;
            char[] cArray = new char[]{'|'};
            List strokes = StringsKt.split$default((CharSequence)shortcut, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (this.getKeyStroke((String)CollectionsKt.getOrNull((List)strokes, (int)0)) == null) {
                return null;
            }
            KeyStroke secondKeyStroke = this.getKeyStroke((String)CollectionsKt.getOrNull((List)strokes, (int)1));
            ((Collection)shortcuts).add(new KeyboardShortcut(firstKeyStroke, secondKeyStroke));
        }
        object2 = (Collection)shortcuts;
        if (object2.isEmpty()) {
            boolean bl = false;
            object = null;
        } else {
            object = object2;
        }
        return (List)object;
    }

    private final KeyStroke getKeyStroke(String s) {
        CharSequence charSequence = s;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        char[] cArray = new char[]{'+'};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)s, (String)"++", (String)"+Plus", (boolean)false, (int)4, null), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String normalizedShortcut = KeyBindingsMappings.INSTANCE.shortcutMap(it);
            sb.append(normalizedShortcut + " ");
        }
        return KeyStroke.getKeyStroke(((Object)StringsKt.dropLast((CharSequence)sb, (int)1)).toString());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/parsers/KeyBindingsParser$Companion;", "", "<init>", "()V", "CURRENT", "", "COMMAND", "SHORTCUT", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

