/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client;

import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.client.ScoreCaching;
import ghidra.features.bsim.query.description.ExecutableRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class FileScoreCaching
implements ScoreCaching {
    private File storageFile;
    private TreeMap<String, Float> cacheMap;
    private double simThreshold;
    private double sigThreshold;

    public FileScoreCaching(String fileName) {
        this.storageFile = new File(fileName);
        this.cacheMap = null;
        this.simThreshold = -1.0;
        this.sigThreshold = -1.0;
    }

    private void loadCache() throws IOException {
        if (this.cacheMap != null) {
            return;
        }
        if (!this.storageFile.exists()) {
            return;
        }
        this.cacheMap = new TreeMap();
        BufferedReader reader = new BufferedReader(new FileReader(this.storageFile));
        String floatString = reader.readLine();
        if (floatString == null) {
            reader.close();
            throw new IOException("Score file missing threshold lines");
        }
        this.simThreshold = Float.parseFloat(floatString);
        floatString = reader.readLine();
        if (floatString == null) {
            reader.close();
            throw new IOException("Score file missing threshold lines");
        }
        this.sigThreshold = Float.parseFloat(floatString);
        floatString = reader.readLine();
        while (floatString != null) {
            String[] split = floatString.split(" ");
            if (split.length != 2 || split[0].length() != 32) {
                reader.close();
                throw new IOException("Bad line in score file");
            }
            float val = Float.parseFloat(split[1]);
            this.cacheMap.put(split[0], Float.valueOf(val));
            floatString = reader.readLine();
        }
        reader.close();
    }

    @Override
    public float getSelfScore(String md5) throws LSHException {
        Float val;
        try {
            this.loadCache();
        }
        catch (IOException e) {
            throw new LSHException("Could not recover cached scores: " + e.getMessage());
        }
        if (this.cacheMap != null && (val = this.cacheMap.get(md5)) != null) {
            return val.floatValue();
        }
        throw new LSHException("Self-score not recorded for " + md5);
    }

    @Override
    public void commitSelfScore(String md5, float score) throws LSHException {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.storageFile, true));
            if (this.cacheMap == null) {
                writer.write(Double.toString(this.simThreshold));
                writer.newLine();
                writer.write(Double.toString(this.sigThreshold));
                writer.newLine();
                this.cacheMap = new TreeMap();
            }
            this.cacheMap.put(md5, Float.valueOf(score));
            writer.write(md5);
            writer.append(' ');
            writer.write(Float.toString(score));
            writer.newLine();
            writer.close();
        }
        catch (IOException ex) {
            throw new LSHException("Could not commit self-score: " + ex.getMessage());
        }
    }

    @Override
    public double getSimThreshold() throws LSHException {
        try {
            this.loadCache();
        }
        catch (IOException e) {
            throw new LSHException("Problems loading score cache: " + e.getMessage());
        }
        return this.simThreshold;
    }

    @Override
    public double getSigThreshold() throws LSHException {
        try {
            this.loadCache();
        }
        catch (IOException e) {
            throw new LSHException("Problems loading score cache: " + e.getMessage());
        }
        return this.sigThreshold;
    }

    @Override
    public void prefetchScores(Set<ExecutableRecord> exeSet, List<ExecutableRecord> missing) throws LSHException {
        block6: {
            try {
                this.loadCache();
            }
            catch (IOException e) {
                throw new LSHException("Could not prefetch scores: " + e.getMessage());
            }
            if (missing == null) break block6;
            if (this.cacheMap == null) {
                for (ExecutableRecord exeRec : exeSet) {
                    missing.add(exeRec);
                }
            } else {
                for (ExecutableRecord exeRec : exeSet) {
                    if (this.cacheMap.containsKey(exeRec.getMd5())) continue;
                    missing.add(exeRec);
                }
            }
        }
    }

    @Override
    public void resetStorage(double simThresh, double sigThresh) throws LSHException {
        if (this.storageFile.exists()) {
            this.storageFile.delete();
        }
        this.cacheMap = null;
        this.simThreshold = simThresh;
        this.sigThreshold = sigThresh;
    }
}

