/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.sleigh.grammar.LineArrayListWriter;
import ghidra.sleigh.grammar.Location;
import ghidra.sleigh.grammar.ParsingEnvironment;
import ghidra.sleigh.grammar.SleighLexer;
import ghidra.sleigh.grammar.SleighParser;
import ghidra.sleigh.grammar.SleighParser_SemanticParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RuleReturnScope;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.UnbufferedTokenStream;
import org.antlr.runtime.UnwantedTokenException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public final class SleighUtils
extends Enum<SleighUtils> {
    public static final String CONDITION_ALWAYS = "1:1";
    public static final String UNCONDITIONAL_BREAK = "emu_swi();\nemu_exec_decoded();\n";
    private static final /* synthetic */ SleighUtils[] $VALUES;

    public static SleighUtils[] values() {
        return (SleighUtils[])$VALUES.clone();
    }

    public static SleighUtils valueOf(String name) {
        return Enum.valueOf(SleighUtils.class, name);
    }

    public static <T extends RuleReturnScope> T parseSleigh(ParseFunction<T> nt, String text, String follow) {
        RuleReturnScope t;
        LineArrayListWriter writer = new LineArrayListWriter();
        ParsingEnvironment env = new ParsingEnvironment(writer);
        BufferedReader r = new BufferedReader(new StringReader(text));
        try {
            String line;
            while ((line = r.readLine()) != null) {
                writer.write(line);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        String inputText = writer.toString().stripTrailing();
        ANTLRStringStream input = new ANTLRStringStream(inputText + follow);
        env.getLocator().registerLocation(0, new Location("sleigh", 0));
        SleighLexer lex = new SleighLexer((CharStream)input);
        lex.setEnv(env);
        UnbufferedTokenStream tokens = new UnbufferedTokenStream((TokenSource)lex);
        final ArrayList<SleighParseErrorEntry> errors = new ArrayList<SleighParseErrorEntry>();
        SleighParser parser = new SleighParser((TokenStream)tokens){
            {
                super(arg0);
                this.gSemanticParser = new SleighParser_SemanticParser(this.input, this.state, this){

                    public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
                        this.collectError(tokenNames, e);
                    }

                    public void emitErrorMessage(String msg) {
                        throw new AssertionError();
                    }
                };
            }

            private void collectError(String[] tokenNames, RecognitionException e) {
                String hdr = this.getErrorHeader(e);
                String msg = this.getErrorMessage(e, tokenNames);
                CommonToken ct = (CommonToken)e.token;
                errors.add(new SleighParseErrorEntry(hdr, msg, ct.getStartIndex(), ct.getStopIndex()));
            }

            public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
                this.collectError(tokenNames, e);
            }

            public void emitErrorMessage(String msg) {
                throw new AssertionError();
            }
        };
        parser.setEnv(env);
        parser.setLexer(lex);
        lex.pushMode(2);
        try {
            t = (RuleReturnScope)nt.apply(parser);
        }
        catch (RecognitionException e) {
            parser.reportError(e);
            return null;
        }
        lex.popMode();
        CommonToken lastTok = (CommonToken)tokens.elementAt(0);
        if (follow.isEmpty()) {
            if (!tokens.isEOF((Token)lastTok)) {
                parser.reportError((RecognitionException)new UnwantedTokenException(-1, (IntStream)tokens));
            }
        } else if (inputText.length() != lastTok.getStartIndex()) {
            parser.reportError((RecognitionException)new UnwantedTokenException(-1, (IntStream)tokens));
        }
        if (!errors.isEmpty()) {
            throw new SleighParseError(errors);
        }
        return (T)t;
    }

    public static Tree parseSleighSemantic(String sleigh) {
        return SleighUtils.parseSleigh(SleighParser::semantic, sleigh, "").getTree();
    }

    public static Tree parseSleighExpression(String expression) {
        return SleighUtils.parseSleigh(SleighParser::expr, expression, ";").getTree();
    }

    private static String getIdentifier(Tree tree) {
        if (tree.getType() != 40) {
            throw new MismatchException();
        }
        return tree.getText();
    }

    private static boolean isIdentifier(Tree tree, String id) {
        return id.equals(SleighUtils.getIdentifier(tree));
    }

    private static void matchIdentifier(Tree tree, String id) {
        if (!SleighUtils.isIdentifier(tree, id)) {
            throw new MismatchException();
        }
    }

    public static List<Tree> getChildren(Tree tree) {
        int count = tree.getChildCount();
        List<Tree> children = Arrays.asList(new Tree[count]);
        for (int i = 0; i < count; ++i) {
            children.set(i, tree.getChild(i));
        }
        return children;
    }

    public static void matchTree(Tree tree, int type, Consumer<List<Tree>> onChildren) {
        if (tree.getType() != type) {
            throw new MismatchException();
        }
        onChildren.accept(SleighUtils.getChildren(tree));
    }

    public static void requireCount(int count, List<?> list) {
        if (count != list.size()) {
            throw new MismatchException();
        }
    }

    @SafeVarargs
    public static void match(Tree tree, int type, Consumer<Tree> ... onChild) {
        SleighUtils.matchTree(tree, type, children -> {
            SleighUtils.requireCount(onChild.length, children);
            for (int i = 0; i < onChild.length; ++i) {
                onChild[i].accept((Tree)children.get(i));
            }
        });
    }

    public static void matchDereference(Tree tree, Consumer<Tree> onSpace, Consumer<Tree> onSize, Consumer<Tree> onOffset) {
        switch (tree.getChildCount()) {
            case 3: {
                SleighUtils.match(tree, 111, onSpace, onSize, onOffset);
                return;
            }
            case 2: {
                Tree child0 = tree.getChild(0);
                switch (child0.getType()) {
                    case 139: {
                        SleighUtils.match(tree, 111, onSpace, onOffset);
                        return;
                    }
                    case 91: 
                    case 109: 
                    case 138: {
                        SleighUtils.match(tree, 111, onSize, onOffset);
                        return;
                    }
                }
                SleighUtils.matchTree(tree, 111, children -> {
                    throw new AssertionError((Object)("OP_DEREFERENCE with 2 children where child[0] is " + SleighParser.tokenNames[child0.getType()]));
                });
                return;
            }
            case 1: {
                SleighUtils.match(tree, 111, onOffset);
                return;
            }
        }
        SleighUtils.match(tree, 111, new Consumer[0]);
        throw new AssertionError((Object)("OP_DEREFERENCE with " + tree.getChildCount() + " children"));
    }

    public static boolean isUnconditionalBreakpoint(Tree tree) {
        try {
            SleighUtils.match(tree, 177, wantApplyEmuSwi -> SleighUtils.match(wantApplyEmuSwi, 87, wantId -> SleighUtils.match(wantId, 139, id -> SleighUtils.matchIdentifier(id, "emu_swi"))), wantApplyEmuExecDecoded -> SleighUtils.match(wantApplyEmuExecDecoded, 87, wantId -> SleighUtils.match(wantId, 139, id -> SleighUtils.matchIdentifier(id, "emu_exec_decoded"))));
            return true;
        }
        catch (MismatchException e) {
            return false;
        }
    }

    public static String recoverConditionFromBreakpoint(Tree tree) {
        try {
            var l = new Object(){
                Tree cond;
                String labelId;
            };
            SleighUtils.match(tree, 177, wantIf -> SleighUtils.match(wantIf, 141, cond -> {
                l.cond = cond;
            }, wantGotoLabel -> SleighUtils.match(wantGotoLabel, 134, wantJumpDest -> SleighUtils.match(wantJumpDest, 146, wantLabel -> SleighUtils.match(wantLabel, 149, wantId -> SleighUtils.match(wantId, 139, id -> {
                l.labelId = SleighUtils.getIdentifier(id);
            }))))), wantApplyEmuSwi -> SleighUtils.match(wantApplyEmuSwi, 87, wantId -> SleighUtils.match(wantId, 139, id -> SleighUtils.matchIdentifier(id, "emu_swi"))), wantLabel -> SleighUtils.match(wantLabel, 149, wantId -> SleighUtils.match(wantId, 139, id -> SleighUtils.matchIdentifier(id, l.labelId))), wantApplyEmuExecDecoded -> SleighUtils.match(wantApplyEmuExecDecoded, 87, wantId -> SleighUtils.match(wantId, 139, id -> SleighUtils.matchIdentifier(id, "emu_exec_decoded"))));
            return SleighUtils.generateSleighExpression(SleighUtils.notTree(l.cond));
        }
        catch (MismatchException e) {
            return null;
        }
    }

    public static String recoverConditionFromBreakpoint(String sleigh) {
        try {
            Tree tree = SleighUtils.parseSleighSemantic(sleigh);
            if (SleighUtils.isUnconditionalBreakpoint(tree)) {
                return CONDITION_ALWAYS;
            }
            return SleighUtils.recoverConditionFromBreakpoint(tree);
        }
        catch (SleighParseError e) {
            return null;
        }
    }

    public static AddressOf recoverAddressOf(final String defaultSpace, Tree tree) {
        var l = new Object(){
            String space;
            Tree offset;
            {
                this.space = defaultSpace;
            }
        };
        SleighUtils.matchDereference(tree, wantSpaceId -> SleighUtils.match(wantSpaceId, 139, id -> {
            l.space = SleighUtils.getIdentifier(id);
        }), wantSize -> {}, wantOffset -> {
            l.offset = wantOffset;
        });
        return new AddressOf(l.space, SleighUtils.removeParenthesisTree(Objects.requireNonNull(l.offset)));
    }

    public static AddressOf recoverAddressOf(String defaultSpace, String expression) {
        try {
            Tree tree = SleighUtils.parseSleighExpression(expression);
            return SleighUtils.recoverAddressOf(defaultSpace, tree);
        }
        catch (MismatchException | SleighParseError e) {
            return null;
        }
    }

    public static Tree makeTree(int type, String text, List<Tree> children) {
        CommonTree tree = new CommonTree((Token)new CommonToken(type, text));
        tree.addChildren(children);
        return tree;
    }

    private static void catChildrenWithSep(Tree tree, String sep, int chopFront, int chopBack, StringBuilder sb) {
        int count = tree.getChildCount() - chopFront - chopBack;
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                sb.append(sep);
            }
            SleighUtils.generateSleighExpression(tree.getChild(i + chopFront), sb);
        }
    }

    private static void generateSleighExpression(Tree tree, StringBuilder sb) {
        block0 : switch (tree.getType()) {
            case 10: 
            case 18: 
            case 39: 
            case 40: {
                sb.append(tree.getText());
                break;
            }
            case 91: 
            case 109: 
            case 138: 
            case 139: {
                SleighUtils.generateSleighExpression(tree.getChild(0), sb);
                break;
            }
            case 162: {
                sb.append("!");
                SleighUtils.generateSleighExpression(tree.getChild(0), sb);
                break;
            }
            case 143: {
                sb.append("~");
                SleighUtils.generateSleighExpression(tree.getChild(0), sb);
                break;
            }
            case 158: {
                sb.append("-");
                SleighUtils.generateSleighExpression(tree.getChild(0), sb);
                break;
            }
            case 131: {
                sb.append("f-");
                SleighUtils.generateSleighExpression(tree.getChild(0), sb);
                break;
            }
            case 83: {
                SleighUtils.catChildrenWithSep(tree, " + ", 0, 0, sb);
                break;
            }
            case 192: {
                SleighUtils.catChildrenWithSep(tree, " - ", 0, 0, sb);
                break;
            }
            case 156: {
                SleighUtils.catChildrenWithSep(tree, " * ", 0, 0, sb);
                break;
            }
            case 113: {
                SleighUtils.catChildrenWithSep(tree, " / ", 0, 0, sb);
                break;
            }
            case 172: {
                SleighUtils.catChildrenWithSep(tree, " % ", 0, 0, sb);
                break;
            }
            case 175: {
                SleighUtils.catChildrenWithSep(tree, " s/ ", 0, 0, sb);
                break;
            }
            case 188: {
                SleighUtils.catChildrenWithSep(tree, " s% ", 0, 0, sb);
                break;
            }
            case 120: {
                SleighUtils.catChildrenWithSep(tree, " f+ ", 0, 0, sb);
                break;
            }
            case 133: {
                SleighUtils.catChildrenWithSep(tree, " f- ", 0, 0, sb);
                break;
            }
            case 130: {
                SleighUtils.catChildrenWithSep(tree, " f* ", 0, 0, sb);
                break;
            }
            case 121: {
                SleighUtils.catChildrenWithSep(tree, " f/ ", 0, 0, sb);
                break;
            }
            case 150: {
                SleighUtils.catChildrenWithSep(tree, " << ", 0, 0, sb);
                break;
            }
            case 174: {
                SleighUtils.catChildrenWithSep(tree, " >> ", 0, 0, sb);
                break;
            }
            case 189: {
                SleighUtils.catChildrenWithSep(tree, " s>> ", 0, 0, sb);
                break;
            }
            case 86: {
                SleighUtils.catChildrenWithSep(tree, " & ", 0, 0, sb);
                break;
            }
            case 167: {
                SleighUtils.catChildrenWithSep(tree, " | ", 0, 0, sb);
                break;
            }
            case 207: {
                SleighUtils.catChildrenWithSep(tree, " ^ ", 0, 0, sb);
                break;
            }
            case 96: {
                SleighUtils.catChildrenWithSep(tree, " && ", 0, 0, sb);
                break;
            }
            case 97: {
                SleighUtils.catChildrenWithSep(tree, " || ", 0, 0, sb);
                break;
            }
            case 98: {
                SleighUtils.catChildrenWithSep(tree, " ^^ ", 0, 0, sb);
                break;
            }
            case 118: {
                SleighUtils.catChildrenWithSep(tree, " == ", 0, 0, sb);
                break;
            }
            case 163: {
                SleighUtils.catChildrenWithSep(tree, " != ", 0, 0, sb);
                break;
            }
            case 122: {
                SleighUtils.catChildrenWithSep(tree, " f== ", 0, 0, sb);
                break;
            }
            case 132: {
                SleighUtils.catChildrenWithSep(tree, " f!= ", 0, 0, sb);
                break;
            }
            case 151: {
                SleighUtils.catChildrenWithSep(tree, " < ", 0, 0, sb);
                break;
            }
            case 152: {
                SleighUtils.catChildrenWithSep(tree, " <= ", 0, 0, sb);
                break;
            }
            case 136: {
                SleighUtils.catChildrenWithSep(tree, " >= ", 0, 0, sb);
                break;
            }
            case 135: {
                SleighUtils.catChildrenWithSep(tree, " > ", 0, 0, sb);
                break;
            }
            case 184: {
                SleighUtils.catChildrenWithSep(tree, " s< ", 0, 0, sb);
                break;
            }
            case 185: {
                SleighUtils.catChildrenWithSep(tree, " s<= ", 0, 0, sb);
                break;
            }
            case 180: {
                SleighUtils.catChildrenWithSep(tree, " s>= ", 0, 0, sb);
                break;
            }
            case 179: {
                SleighUtils.catChildrenWithSep(tree, " s> ", 0, 0, sb);
                break;
            }
            case 128: {
                SleighUtils.catChildrenWithSep(tree, " f< ", 0, 0, sb);
                break;
            }
            case 129: {
                SleighUtils.catChildrenWithSep(tree, " f<= ", 0, 0, sb);
                break;
            }
            case 124: {
                SleighUtils.catChildrenWithSep(tree, " f>= ", 0, 0, sb);
                break;
            }
            case 123: {
                SleighUtils.catChildrenWithSep(tree, " f> ", 0, 0, sb);
                break;
            }
            case 111: {
                if (tree.getChildCount() == 3) {
                    sb.append("*[");
                    SleighUtils.generateSleighExpression(tree.getChild(0), sb);
                    sb.append("]:");
                    SleighUtils.generateSleighExpression(tree.getChild(1), sb);
                    sb.append(" ");
                    SleighUtils.generateSleighExpression(tree.getChild(2), sb);
                    break;
                }
                if (tree.getChildCount() == 2) {
                    Tree child0 = tree.getChild(0);
                    switch (child0.getType()) {
                        case 139: {
                            sb.append("*[");
                            SleighUtils.generateSleighExpression(child0, sb);
                            sb.append("] ");
                            SleighUtils.generateSleighExpression(tree.getChild(1), sb);
                            break block0;
                        }
                        case 91: 
                        case 109: 
                        case 138: {
                            sb.append("*:");
                            SleighUtils.generateSleighExpression(child0, sb);
                            sb.append(" ");
                            SleighUtils.generateSleighExpression(tree.getChild(1), sb);
                            break block0;
                        }
                    }
                    throw new AssertionError((Object)("OP_DEREFERENCE with 2 children where child[0] is " + SleighParser.tokenNames[child0.getType()]));
                }
                if (tree.getChildCount() == 1) {
                    sb.append("*");
                    SleighUtils.generateSleighExpression(tree.getChild(0), sb);
                    break;
                }
                throw new AssertionError((Object)("OP_DEREFERENCE with " + tree.getChildCount() + " children"));
            }
            case 84: {
                if (tree.getChildCount() == 2) {
                    sb.append("&");
                    SleighUtils.generateSleighExpression(tree.getChild(0), sb);
                    sb.append(" ");
                    SleighUtils.generateSleighExpression(tree.getChild(1), sb);
                    break;
                }
                if (tree.getChildCount() == 1) {
                    sb.append("&");
                    SleighUtils.generateSleighExpression(tree.getChild(0), sb);
                    break;
                }
                throw new AssertionError((Object)("OP_ADDRESS_OF with " + tree.getChildCount() + " children"));
            }
            case 183: {
                sb.append(":");
                SleighUtils.generateSleighExpression(tree.getChild(0), sb);
                break;
            }
            case 87: {
                SleighUtils.generateSleighExpression(tree.getChild(0), sb);
                sb.append("(");
                SleighUtils.catChildrenWithSep(tree, ", ", 1, 0, sb);
                sb.append(")");
                break;
            }
            case 197: {
                SleighUtils.generateSleighExpression(tree.getChild(0), sb);
                sb.append(":");
                SleighUtils.generateSleighExpression(tree.getChild(1), sb);
                break;
            }
            case 92: {
                SleighUtils.generateSleighExpression(tree.getChild(0), sb);
                sb.append("[");
                SleighUtils.generateSleighExpression(tree.getChild(1), sb);
                sb.append(",");
                SleighUtils.generateSleighExpression(tree.getChild(2), sb);
                sb.append("]");
                break;
            }
            case 93: {
                SleighUtils.generateSleighExpression(tree.getChild(0), sb);
                sb.append(":");
                SleighUtils.generateSleighExpression(tree.getChild(1), sb);
                break;
            }
            case 88: {
                SleighUtils.catChildrenWithSep(tree, ", ", 0, 0, sb);
                break;
            }
            case 168: {
                sb.append("(");
                SleighUtils.generateSleighExpression(tree.getChild(0), sb);
                sb.append(")");
                break;
            }
            default: {
                throw new AssertionError((Object)("type = " + SleighParser.tokenNames[tree.getType()]));
            }
        }
    }

    public static String generateSleighExpression(Tree tree) {
        StringBuilder sb = new StringBuilder();
        SleighUtils.generateSleighExpression(tree, sb);
        return sb.toString();
    }

    public static Tree removeParenthesisTree(Tree tree) {
        if (tree.getType() == 168) {
            return SleighUtils.removeParenthesisTree(tree.getChild(0));
        }
        return tree;
    }

    public static Tree notTree(Tree boolExpr) {
        boolExpr = SleighUtils.removeParenthesisTree(boolExpr);
        switch (boolExpr.getType()) {
            case 118: {
                return SleighUtils.makeTree(163, "!=", SleighUtils.getChildren(boolExpr));
            }
            case 163: {
                return SleighUtils.makeTree(118, "==", SleighUtils.getChildren(boolExpr));
            }
            case 122: {
                return SleighUtils.makeTree(132, "f!=", SleighUtils.getChildren(boolExpr));
            }
            case 132: {
                return SleighUtils.makeTree(122, "f==", SleighUtils.getChildren(boolExpr));
            }
            case 151: {
                return SleighUtils.makeTree(136, ">=", SleighUtils.getChildren(boolExpr));
            }
            case 152: {
                return SleighUtils.makeTree(135, ">", SleighUtils.getChildren(boolExpr));
            }
            case 136: {
                return SleighUtils.makeTree(151, "<", SleighUtils.getChildren(boolExpr));
            }
            case 135: {
                return SleighUtils.makeTree(152, "<=", SleighUtils.getChildren(boolExpr));
            }
            case 184: {
                return SleighUtils.makeTree(180, "s>=", SleighUtils.getChildren(boolExpr));
            }
            case 185: {
                return SleighUtils.makeTree(179, "s>", SleighUtils.getChildren(boolExpr));
            }
            case 180: {
                return SleighUtils.makeTree(184, "s<", SleighUtils.getChildren(boolExpr));
            }
            case 179: {
                return SleighUtils.makeTree(185, "s<=", SleighUtils.getChildren(boolExpr));
            }
            case 128: {
                return SleighUtils.makeTree(124, "f>=", SleighUtils.getChildren(boolExpr));
            }
            case 129: {
                return SleighUtils.makeTree(123, "f>", SleighUtils.getChildren(boolExpr));
            }
            case 124: {
                return SleighUtils.makeTree(128, "f<", SleighUtils.getChildren(boolExpr));
            }
            case 123: {
                return SleighUtils.makeTree(129, "f<=", SleighUtils.getChildren(boolExpr));
            }
            case 162: {
                return SleighUtils.removeParenthesisTree(boolExpr.getChild(0));
            }
        }
        return SleighUtils.makeTree(162, "!", List.of(SleighUtils.makeTree(168, "(...)", List.of(boolExpr))));
    }

    public static String sleighForConditionalBreak(String condition) {
        if (CONDITION_ALWAYS.equals(condition)) {
            return UNCONDITIONAL_BREAK;
        }
        Tree tree = SleighUtils.parseSleighExpression(condition);
        String negCond = SleighUtils.generateSleighExpression(SleighUtils.notTree(tree));
        return String.format("if %s goto <L1>;\n  emu_swi();\n<L1>\nemu_exec_decoded();\n", negCond);
    }

    private static /* synthetic */ SleighUtils[] $values() {
        return new SleighUtils[0];
    }

    static {
        $VALUES = SleighUtils.$values();
    }

    public static interface ParseFunction<T> {
        public T apply(SleighParser var1) throws RecognitionException;
    }

    public static class SleighParseError
    extends RuntimeException {
        private final List<SleighParseErrorEntry> errors;

        public SleighParseError(Collection<SleighParseErrorEntry> errors) {
            super(errors.stream().map(e -> e.fullMessage()).collect(Collectors.joining("\n")));
            this.errors = List.copyOf(errors);
        }

        public List<SleighParseErrorEntry> getErrors() {
            return this.errors;
        }
    }

    public static class MismatchException
    extends RuntimeException {
    }

    public record AddressOf(String space, Tree offset) {
    }

    public record SleighParseErrorEntry(String header, String message, int start, int stop) {
        public String fullMessage() {
            return this.header + " " + this.message;
        }
    }
}

