/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.xml;

import java.nio.charset.Charset;
import org.catacombae.dmgextractor.io.SynchronizedRandomAccessStream;
import org.catacombae.xml.Attribute2;
import org.catacombae.xml.XMLElement;
import org.catacombae.xml.XMLNode;
import org.catacombae.xml.XMLText;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NodeBuilder
extends DefaultHandler {
    private XMLNode artificialRoot;
    private XMLNode currentNode;

    public NodeBuilder() {
        this.currentNode = this.artificialRoot = new XMLNode(null, null, null, null, null);
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        Attribute2[] attributes = new Attribute2[attrs.getLength()];
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i] = new Attribute2(attrs.getLocalName(i), attrs.getQName(i), attrs.getType(i), attrs.getURI(i), attrs.getValue(i));
        }
        this.startElementInternal(namespaceURI, sName, qName, attributes);
    }

    void startElementInternal(String namespaceURI, String sName, String qName, Attribute2[] attributes) throws SAXException {
        XMLNode newNode = new XMLNode(namespaceURI, sName, qName, attributes, this.currentNode);
        this.currentNode.addChild(newNode);
        this.currentNode = newNode;
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        this.currentNode = this.currentNode.parent;
    }

    public void characters(SynchronizedRandomAccessStream file, Charset encoding, int startLine, int startColumn, int endLine, int endColumn) {
        this.currentNode.addChild(new XMLText(file, encoding, startLine, startColumn, endLine, endColumn));
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len).trim();
        if (s.length() != 0) {
            this.currentNode.addChild(new XMLText(s));
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public XMLNode[] getRoots() throws RuntimeException {
        if (this.artificialRoot != this.currentNode) {
            throw new RuntimeException("Tree was not closed!");
        }
        int numberOfNodes = 0;
        for (XMLElement xe : this.artificialRoot.getChildren()) {
            if (!(xe instanceof XMLNode)) continue;
            ++numberOfNodes;
        }
        XMLNode[] result = new XMLNode[numberOfNodes];
        int i = 0;
        for (XMLElement xe : this.artificialRoot.getChildren()) {
            if (!(xe instanceof XMLNode)) continue;
            result[i++] = (XMLNode)xe;
        }
        return result;
    }
}

