/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.wizard.project;

import docking.wizard.WizardModel;
import docking.wizard.WizardStep;
import ghidra.framework.client.RepositoryServerAdapter;
import ghidra.framework.main.wizard.project.ProjectWizardData;
import ghidra.framework.main.wizard.project.ServerInfoPanel;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.model.ServerInfo;
import ghidra.util.HelpLocation;
import javax.swing.JComponent;

public class ServerStep
extends WizardStep<ProjectWizardData> {
    private ServerInfoPanel panel;
    private ProjectManager projectManager;

    protected ServerStep(WizardModel<ProjectWizardData> model, ProjectManager projectManager) {
        super(model, "Specify Server Information", new HelpLocation("FrontEndPlugin", "SetupServerInfo"));
        this.projectManager = projectManager;
        this.panel = new ServerInfoPanel(() -> this.notifyStatusChanged());
    }

    public void initialize(ProjectWizardData data) {
        ServerInfo info;
        if (this.panel.getServerName().isBlank() && (info = this.getInitialServerInfo(data)) != null) {
            this.panel.setServerInfo(info);
        }
    }

    private ServerInfo getInitialServerInfo(ProjectWizardData data) {
        if (data.getServerInfo() != null) {
            return data.getServerInfo();
        }
        return this.projectManager.getMostRecentServerInfo();
    }

    public boolean isValid() {
        if (!this.panel.isValidInformation()) {
            this.setStatusMessage(this.panel.getStatusMessge());
            return false;
        }
        return true;
    }

    public void populateData(ProjectWizardData data) {
        String serverName = this.panel.getServerName();
        int portNumber = this.panel.getPortNumber();
        data.setServerInfo(new ServerInfo(serverName, portNumber));
    }

    public boolean canFinish(ProjectWizardData data) {
        return data.getServer() != null;
    }

    public boolean apply(ProjectWizardData data) {
        int port;
        ServerInfo serverInfo = data.getServerInfo();
        String serverName = serverInfo.getServerName();
        RepositoryServerAdapter server = this.projectManager.getRepositoryServerAdapter(serverName, port = serverInfo.getPortNumber(), true);
        if (!server.isConnected()) {
            this.setStatusMessage("Could not connect to server " + serverName + ", port " + port);
            return false;
        }
        data.setServer(server);
        return true;
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public boolean isApplicable(ProjectWizardData data) {
        return data.isSharedProject();
    }
}

