/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l = 83830268683855L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1096924830 + (char)-2640, -1097055900 - -((char)-969), (int)l));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1096924830 + (char)-2639, -1096924830 + -((char)-807), (int)l));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l;
            block2: {
                l = 7706145844641L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.b();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(974505450 - 1608, -974505450 - -11722, (int)l) + string + WindowsNamedPipeAgentIpc.b(974505450 - 1607, -974505450 - -1670, (int)l) + thread3 + WindowsNamedPipeAgentIpc.b(974505450 - 1606, 974505450 - 8944, (int)l) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l;
        block14: {
            block15: {
                int[] nArray;
                l = 17931177603085L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    nArray = SshAgentIpcService.b();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-310898040 - -((char)-12415), -310898040 - -((char)-25274), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-310898040 - -((char)-12414), 310898040 - 29024, (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-310898040 - -((char)-12413), -310898040 - -((char)-10461), (int)l));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (nArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-310898040 - -((char)-12420), 310898040 - (char)-11427, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-310898040 - -((char)-12419), -310898040 - -((char)-17578), (int)l) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-310898040 - -((char)-12418), -310898040 - -((char)-26592), (int)l));
            logger.info(WindowsNamedPipeAgentIpc.b(-310898040 - -((char)-12420), 310898040 - (char)-11427, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-310898040 - -((char)-12417), -310898040 - -((char)-8565), (int)l));
            if (ActionTimestamp.b() == null) {
                SshAgentIpcService.b(new int[2]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l = 128526584426364L;
                    nArray = SshAgentIpcService.b();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int[] nArray;
        long l;
        block27: {
            block28: {
                l = 41024597999448L;
                int[] nArray2 = SshAgentIpcService.b();
                this.assertConnectionThread();
                nArray = nArray2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13805), 929679510 - (char)-10690, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13801), 929548440 + (char)-13130, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13804), -929548440 + -((char)-16631), (int)l) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13801), 929548440 + (char)-13130, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13807), -929679510 - -((char)-9537), (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13805), 929679510 - (char)-10690, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13801), 929548440 + (char)-13130, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13806), 929548440 + (char)-18263, (int)l));
                    object2 = Kernel32.INSTANCE;
                    if (nArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13805), 929679510 - (char)-10690, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13801), 929548440 + (char)-13130, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13793), 929548440 + (char)-10728, (int)l));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13801), 929548440 + (char)-13130, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13792), 929548440 + (char)-17255, (int)l) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (nArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13801), 929548440 + (char)-13130, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13807), -929679510 - -((char)-9537), (int)l) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13805), 929679510 - (char)-10690, (int)l));
        logger.info(WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13801), 929548440 + (char)-13130, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-929548440 + -((char)-13795), 929679510 - (char)-11950, (int)l));
        long l2 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l2);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l = 129685307977338L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1229567670 - -19835, 1229567670 - (char)-26438, (int)l));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l = 135040793058222L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1568645760 - -1424, 1568645760 + 4512, (int)l));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00d5\n%\u00ee\u000e\u0086=&K\u0001\r\u00e2\u00b7\u00d2o\u00d0\u00a5\u00f0+\u0014\"s\u00db\u00c7\u00caa\u00d8_u(\u000f\u00135\u0015\u00fe\u00a3zX\u00d7\u0082";
                        var4_3 = "\u00d5\n%\u00ee\u000e\u0086=&K\u0001\r\u00e2\u00b7\u00d2o\u00d0\u00a5\u00f0+\u0014\"s\u00db\u00c7\u00caa\u00d8_u(\u000f\u00135\u0015\u00fe\u00a3zX\u00d7\u0082".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 20;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 13;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 116;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 124;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 55;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 68;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 59;
                                        break;
                                    }
                                    default: {
                                        v11 = 52;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x78BF) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 201;
                            case 1 -> 48;
                            case 2 -> 182;
                            case 3 -> 154;
                            case 4 -> 24;
                            case 5 -> 184;
                            case 6 -> 54;
                            case 7 -> 171;
                            case 8 -> 42;
                            case 9 -> 243;
                            case 10 -> 46;
                            case 11 -> 31;
                            case 12 -> 156;
                            case 13 -> 139;
                            case 14 -> 97;
                            case 15 -> 118;
                            case 16 -> 52;
                            case 17 -> 186;
                            case 18 -> 235;
                            case 19 -> 36;
                            case 20 -> 63;
                            case 21 -> 212;
                            case 22 -> 61;
                            case 23 -> 19;
                            case 24 -> 115;
                            case 25 -> 226;
                            case 26 -> 138;
                            case 27 -> 32;
                            case 28 -> 133;
                            case 29 -> 124;
                            case 30 -> 219;
                            case 31 -> 96;
                            case 32 -> 53;
                            case 33 -> 150;
                            case 34 -> 94;
                            case 35 -> 244;
                            case 36 -> 88;
                            case 37 -> 252;
                            case 38 -> 148;
                            case 39 -> 125;
                            case 40 -> 220;
                            case 41 -> 109;
                            case 42 -> 209;
                            case 43 -> 67;
                            case 44 -> 70;
                            case 45 -> 4;
                            case 46 -> 165;
                            case 47 -> 0;
                            case 48 -> 117;
                            case 49 -> 95;
                            case 50 -> 137;
                            case 51 -> 41;
                            case 52 -> 191;
                            case 53 -> 170;
                            case 54 -> 15;
                            case 55 -> 204;
                            case 56 -> 248;
                            case 57 -> 69;
                            case 58 -> 222;
                            case 59 -> 57;
                            case 60 -> 199;
                            case 61 -> 99;
                            case 62 -> 23;
                            case 63 -> 190;
                            case 64 -> 187;
                            case 65 -> 92;
                            case 66 -> 193;
                            case 67 -> 100;
                            case 68 -> 155;
                            case 69 -> 18;
                            case 70 -> 164;
                            case 71 -> 189;
                            case 72 -> 82;
                            case 73 -> 214;
                            case 74 -> 123;
                            case 75 -> 161;
                            case 76 -> 35;
                            case 77 -> 85;
                            case 78 -> 242;
                            case 79 -> 39;
                            case 80 -> 158;
                            case 81 -> 253;
                            case 82 -> 229;
                            case 83 -> 107;
                            case 84 -> 76;
                            case 85 -> 49;
                            case 86 -> 215;
                            case 87 -> 129;
                            case 88 -> 55;
                            case 89 -> 1;
                            case 90 -> 13;
                            case 91 -> 146;
                            case 92 -> 234;
                            case 93 -> 255;
                            case 94 -> 224;
                            case 95 -> 141;
                            case 96 -> 240;
                            case 97 -> 86;
                            case 98 -> 43;
                            case 99 -> 26;
                            case 100 -> 12;
                            case 101 -> 251;
                            case 102 -> 172;
                            case 103 -> 33;
                            case 104 -> 2;
                            case 105 -> 121;
                            case 106 -> 6;
                            case 107 -> 132;
                            case 108 -> 30;
                            case 109 -> 136;
                            case 110 -> 216;
                            case 111 -> 145;
                            case 112 -> 128;
                            case 113 -> 20;
                            case 114 -> 188;
                            case 115 -> 254;
                            case 116 -> 84;
                            case 117 -> 11;
                            case 118 -> 177;
                            case 119 -> 93;
                            case 120 -> 196;
                            case 121 -> 208;
                            case 122 -> 83;
                            case 123 -> 211;
                            case 124 -> 232;
                            case 125 -> 91;
                            case 126 -> 169;
                            case 127 -> 119;
                            case 128 -> 203;
                            case 129 -> 149;
                            case 130 -> 104;
                            case 131 -> 245;
                            case 132 -> 81;
                            case 133 -> 90;
                            case 134 -> 151;
                            case 135 -> 153;
                            case 136 -> 27;
                            case 137 -> 130;
                            case 138 -> 185;
                            case 139 -> 126;
                            case 140 -> 218;
                            case 141 -> 79;
                            case 142 -> 180;
                            case 143 -> 65;
                            case 144 -> 134;
                            case 145 -> 110;
                            case 146 -> 60;
                            case 147 -> 247;
                            case 148 -> 17;
                            case 149 -> 166;
                            case 150 -> 111;
                            case 151 -> 183;
                            case 152 -> 16;
                            case 153 -> 45;
                            case 154 -> 206;
                            case 155 -> 168;
                            case 156 -> 197;
                            case 157 -> 44;
                            case 158 -> 241;
                            case 159 -> 116;
                            case 160 -> 112;
                            case 161 -> 140;
                            case 162 -> 221;
                            case 163 -> 106;
                            case 164 -> 223;
                            case 165 -> 5;
                            case 166 -> 237;
                            case 167 -> 250;
                            case 168 -> 101;
                            case 169 -> 198;
                            case 170 -> 173;
                            case 171 -> 147;
                            case 172 -> 7;
                            case 173 -> 217;
                            case 174 -> 159;
                            case 175 -> 75;
                            case 176 -> 40;
                            case 177 -> 143;
                            case 178 -> 74;
                            case 179 -> 144;
                            case 180 -> 108;
                            case 181 -> 239;
                            case 182 -> 37;
                            case 183 -> 14;
                            case 184 -> 58;
                            case 185 -> 207;
                            case 186 -> 22;
                            case 187 -> 230;
                            case 188 -> 200;
                            case 189 -> 9;
                            case 190 -> 50;
                            case 191 -> 210;
                            case 192 -> 102;
                            case 193 -> 160;
                            case 194 -> 113;
                            case 195 -> 8;
                            case 196 -> 78;
                            case 197 -> 68;
                            case 198 -> 64;
                            case 199 -> 51;
                            case 200 -> 21;
                            case 201 -> 249;
                            case 202 -> 71;
                            case 203 -> 213;
                            case 204 -> 228;
                            case 205 -> 238;
                            case 206 -> 225;
                            case 207 -> 10;
                            case 208 -> 25;
                            case 209 -> 175;
                            case 210 -> 120;
                            case 211 -> 29;
                            case 212 -> 233;
                            case 213 -> 176;
                            case 214 -> 142;
                            case 215 -> 89;
                            case 216 -> 167;
                            case 217 -> 157;
                            case 218 -> 152;
                            case 219 -> 103;
                            case 220 -> 192;
                            case 221 -> 127;
                            case 222 -> 66;
                            case 223 -> 246;
                            case 224 -> 202;
                            case 225 -> 38;
                            case 226 -> 28;
                            case 227 -> 3;
                            case 228 -> 195;
                            case 229 -> 135;
                            case 230 -> 163;
                            case 231 -> 174;
                            case 232 -> 227;
                            case 233 -> 231;
                            case 234 -> 34;
                            case 235 -> 114;
                            case 236 -> 87;
                            case 237 -> 236;
                            case 238 -> 72;
                            case 239 -> 56;
                            case 240 -> 80;
                            case 241 -> 59;
                            case 242 -> 179;
                            case 243 -> 73;
                            case 244 -> 205;
                            case 245 -> 77;
                            case 246 -> 47;
                            case 247 -> 98;
                            case 248 -> 131;
                            case 249 -> 194;
                            case 250 -> 122;
                            case 251 -> 105;
                            case 252 -> 162;
                            case 253 -> 178;
                            case 254 -> 181;
                            default -> 62;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (nArray == null) {
                ActionTimestamp.b("optbhc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l2;
            block2: {
                block3: {
                    l2 = 87581570812337L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.b();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1402317930 - -18470, 1402317930 - (char)-22599, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1402317930 - -18466, 1402317930 - 18627, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1402317930 - -18445, 1402317930 - 17107, (int)l2) + uLONG);
                    l = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1402317930 - -18470, 1402317930 - (char)-22599, (int)l2));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1402317930 - -18466, 1402317930 - 18627, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1402317930 - -18446, -1402317930 - -13776, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
            l = -1L;
        }
        long l3 = l;
        return l3;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l = 95506580087977L;
                        int[] nArray2 = SshAgentIpcService.b();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-607640520 + -11643, -607640520 + -((char)-29630), (int)l));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-607640520 + -11642, 607640520 + 30478, (int)l);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l;
        block25: {
            block26: {
                l = 98243042519137L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    nArray = SshAgentIpcService.b();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-39452070 - -((char)-2030), 39452070 - (char)-26555, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(-39452070 - -((char)-2034), 39452070 - (char)-1233, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-39452070 - -((char)-2019), 39452070 - (char)-31503, (int)l));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-39452070 - -((char)-2034), 39452070 - (char)-1233, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-39452070 - -((char)-2028), -39452070 - -((char)-32074), (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-39452070 - -((char)-2030), 39452070 - (char)-26555, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-39452070 - -((char)-2034), 39452070 - (char)-1233, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-39452070 - -((char)-2018), 39452070 - (char)-11214, (int)l));
                    object = Kernel32.INSTANCE;
                    if (nArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-39452070 - -((char)-2030), 39452070 - (char)-26555, (int)l));
                logger.warn(WindowsNamedPipeAgentIpc.b(-39452070 - -((char)-2034), 39452070 - (char)-1233, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-39452070 - -((char)-2017), -39452070 - -((char)-20134), (int)l) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-39452070 - -((char)-2030), 39452070 - (char)-26555, (int)l));
        logger.info(WindowsNamedPipeAgentIpc.b(-39452070 - -((char)-2034), 39452070 - (char)-1233, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-39452070 - -((char)-2016), -39452070 - -((char)-21680), (int)l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l;
            block15: {
                int[] nArray;
                block16: {
                    l = 56633007608303L;
                    Object object = this.lock;
                    nArray = SshAgentIpcService.b();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-431089230 + -((char)-10800), 431089230 + (char)-2399, (int)l));
                                logger.info(WindowsNamedPipeAgentIpc.b(-431089230 + -((char)-10804), 431089230 + (char)-10837, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-431089230 + -((char)-10819), 431220300 - (char)-3919, (int)l) + this.state + WindowsNamedPipeAgentIpc.b(-431089230 + -((char)-10816), -431089230 + -((char)-11693), (int)l));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-431089230 + -((char)-10800), 431089230 + (char)-2399, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(-431089230 + -((char)-10804), 431089230 + (char)-10837, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-431089230 + -((char)-10817), 431089230 + (char)-6721, (int)l));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (nArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-431089230 + -((char)-10800), 431089230 + (char)-2399, (int)l));
                        logger.info(WindowsNamedPipeAgentIpc.b(-431089230 + -((char)-10804), 431089230 + (char)-10837, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-431089230 + -((char)-10814), 431220300 - (char)-1879, (int)l) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-431089230 + -((char)-10800), 431089230 + (char)-2399, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-431089230 + -((char)-10804), 431089230 + (char)-10837, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-431089230 + -((char)-10815), -431089230 + -((char)-21082), (int)l));
                    if (nArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-431089230 + -((char)-10800), 431089230 + (char)-2399, (int)l));
                logger.warn(WindowsNamedPipeAgentIpc.b(-431089230 + -((char)-10804), 431089230 + (char)-10837, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-431089230 + -((char)-10780), 431089230 + (char)-7336, (int)l) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-431089230 + -((char)-10781), -431089230 + -((char)-6828), (int)l));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u0094\u00f4\u00e9\u00db4BXD\u0014c\u00f8/\u00bd\u0012\u00063\u00d6\u00bbZ\u001cA\u00d9Q\u0088\u00c8\u0091\u00ad)\u00a4\u0006AaSi\tU\u0018\u00a61\u00f7\u00b4\u008b\u00e2\u0002\u008aU\u00ac\u00ce\u00ef\u00e5{]\u000f\u0082<e\u000b\u00e1\"\u00fb\u00c5\t\u00fd\u0095\u0002\u0091^\u00d9\u00a0\u00a5=\u0005\u0017\u009a\u0099\u0016J\b\u008b:\ns\u001aq\u009b\u00c0\u0014\u0091\u0085\t\u0089\u00bb\u00883\u0090\u00d5OzW_0\u00e3\t\u00eeF?\u009b\u0005V\u00a3\u00b11O\u001e\u00855\u00de\u0087?@6\u00a4v}\u00e1RL\u00ec\u00ca\u0099\u0091\u007f\u00d5\u0097[\u009e\u00a0\u009f(\\\u000b(\u0006\u00e3\u0010\u00e4#\u0016\u0080q\u0092\t\u0007\u00ec\u00bb?w\u0091\u001d\u00de8\t\u00e0ow\u00df\u00a379\u00e7\u00e0\u0010\u00ad\u0080?\u00f4T\u001c\u00ad\u00d6x\u0081\u00ad0\u00c3\u00f5\u0094%?4\u001e\u00e0\u00e2\u00f5\u00e5\u00ea|\u009c\u00b7\u00f9\u00f0\u00f0N`\u00f4\u0001\u00b7\u00baK8W\u00b7\u00c0\u00da_X\u00fc[/\u0099\u00d7\u00b64n\u00cf\u0006g\u00d7\u00e8\u00e4F\u007f\u00d4\u00fb\u00dd\u0094\u00fd\u00c0\r\u0006\u00fa\u00ce\u0007\u00f5@M\u00c9\u008c!8\u009d0\b\u00ea\u00dc&\u00af\u009f\u00ea+\u00b3\f\u00b1>]\u00e8\u00ed`\u008b\u00e5\u0095\u00afB\u00f1F\u009cM\u00f8\u0086Y\u00ad\u001d\\G\u0094\u0012R\u001b\u0012\u0002Y\u00b1e\u00ac\u00be\u00e8\u00bb\u00aeo\u00cf\u0081\t,\u00ce\u001c\u0011\u008d\u009b\u00c9\tQ0\u00f9\u00ba\u00ff\u00da\u00b13\u00d1\u00ac\u00f8*$\u00f0\u00cef(-\u00cb\u009f\u00c2\u009f\u00ed@\u0019\u0092\u00f39\u00bdVf7j]\u009c\u001f\u00eb0\u0013'\u0086T\u0001&\u0090-=X\u00d7\u00b0\u00b2\u00a3\u00e5\u00d0&\u00a8\u00ee\u00f9\u00c1\u00d8ed\u00b5\u00e3\u00cckS\u000b\u00be \u00bc+\u00d1\u0018\f\u00eaeBV\u0015\b\u00f8j3\fs[\u00fa\u00b1\u00a0\u0004\"NS\u009c\u0089\u00db\u0001<\u00eb\u009b)F\u00bb\u00a6V0z\u00d7\u00e3J\u0095fO\u00b8X\u00c1\u00bb\u00d4[\u00db~\u00a1[\u00ee\u0094\u00ef\u00a43\u00833\u0093.B\u0082\u0095LW\u0086$\u00e7\u00ed\u00d2\u0007\u00ddC\u00dfS;\u0087-\u0007\u00afV\u00f5\u009d\u0099\u00b1o(\u00da\u00efy\u00fd{eH'\u00c9\u00da<\u0090\u00d0\"\u008ew:o\u00a8\u00bb\u00ae\u00dd`\u008f\u00ae{\u00ad\u0003\u00d7\u00e3iU\u0091\u001c\u00b0\u00cb\u00a3\u00ca\u00d0\u00c3\u000f\u008b\u008d\u001d\u0098\u001f\u00a5a\u00fc\u0099,\u0097\u001f\u0005\u0087\u00aa\"!\rJ\u0080\u00ad\u00a0d\u00b8<\u00fe\u00a8\"b\u00f9\u00feA\u00d8-\u00d0\u00f2*\u00ca?\u00f6F\u00bc\u00cb^\b\u001a\u00ebt\u0014\u00a0\u000e\u00ad\u009d\u00d9\u009a\u0087\u00e5r\u00f4\u00fb-\u00db?\u0080\u0089\u001b\u00fe$\u00b4\u00a8\u00d1\u0016-\u00d6G\u00ee\u00c1F\u0093\u0090\u00e6zs\u00e0\u0018\u00d7\bZ\bB\u00ebG+\n'\u00bdK\u009c:t\u0083\u00b09@\u0018\u00c3\u00a6\u0013\u00f5$\u0001\u00b2j\u00aa\u00b0\u00be\u0012\u00c5I\u00d0`\u00c2\u00a2\u00f9\u00e6L7\u00db\u00bc)/\u0095\u008b\u0093\u0095\u00c2c\u00f4\u00dcw\u00b4\u0013\u00e6\u00da\u0095\u0090 K\u009a\u00b9\u00b3\u00b3\u00e5\u0085\u00fb\u0014,y\u0083\u0090\u0083\u00b3\u0012u\u008b\u00df\u00a0\u0011#KJ\t\u00cc\u001c\u00f2\u00af\u0019\u00f68\u0084}";
                var4_3 = "\u0094\u00f4\u00e9\u00db4BXD\u0014c\u00f8/\u00bd\u0012\u00063\u00d6\u00bbZ\u001cA\u00d9Q\u0088\u00c8\u0091\u00ad)\u00a4\u0006AaSi\tU\u0018\u00a61\u00f7\u00b4\u008b\u00e2\u0002\u008aU\u00ac\u00ce\u00ef\u00e5{]\u000f\u0082<e\u000b\u00e1\"\u00fb\u00c5\t\u00fd\u0095\u0002\u0091^\u00d9\u00a0\u00a5=\u0005\u0017\u009a\u0099\u0016J\b\u008b:\ns\u001aq\u009b\u00c0\u0014\u0091\u0085\t\u0089\u00bb\u00883\u0090\u00d5OzW_0\u00e3\t\u00eeF?\u009b\u0005V\u00a3\u00b11O\u001e\u00855\u00de\u0087?@6\u00a4v}\u00e1RL\u00ec\u00ca\u0099\u0091\u007f\u00d5\u0097[\u009e\u00a0\u009f(\\\u000b(\u0006\u00e3\u0010\u00e4#\u0016\u0080q\u0092\t\u0007\u00ec\u00bb?w\u0091\u001d\u00de8\t\u00e0ow\u00df\u00a379\u00e7\u00e0\u0010\u00ad\u0080?\u00f4T\u001c\u00ad\u00d6x\u0081\u00ad0\u00c3\u00f5\u0094%?4\u001e\u00e0\u00e2\u00f5\u00e5\u00ea|\u009c\u00b7\u00f9\u00f0\u00f0N`\u00f4\u0001\u00b7\u00baK8W\u00b7\u00c0\u00da_X\u00fc[/\u0099\u00d7\u00b64n\u00cf\u0006g\u00d7\u00e8\u00e4F\u007f\u00d4\u00fb\u00dd\u0094\u00fd\u00c0\r\u0006\u00fa\u00ce\u0007\u00f5@M\u00c9\u008c!8\u009d0\b\u00ea\u00dc&\u00af\u009f\u00ea+\u00b3\f\u00b1>]\u00e8\u00ed`\u008b\u00e5\u0095\u00afB\u00f1F\u009cM\u00f8\u0086Y\u00ad\u001d\\G\u0094\u0012R\u001b\u0012\u0002Y\u00b1e\u00ac\u00be\u00e8\u00bb\u00aeo\u00cf\u0081\t,\u00ce\u001c\u0011\u008d\u009b\u00c9\tQ0\u00f9\u00ba\u00ff\u00da\u00b13\u00d1\u00ac\u00f8*$\u00f0\u00cef(-\u00cb\u009f\u00c2\u009f\u00ed@\u0019\u0092\u00f39\u00bdVf7j]\u009c\u001f\u00eb0\u0013'\u0086T\u0001&\u0090-=X\u00d7\u00b0\u00b2\u00a3\u00e5\u00d0&\u00a8\u00ee\u00f9\u00c1\u00d8ed\u00b5\u00e3\u00cckS\u000b\u00be \u00bc+\u00d1\u0018\f\u00eaeBV\u0015\b\u00f8j3\fs[\u00fa\u00b1\u00a0\u0004\"NS\u009c\u0089\u00db\u0001<\u00eb\u009b)F\u00bb\u00a6V0z\u00d7\u00e3J\u0095fO\u00b8X\u00c1\u00bb\u00d4[\u00db~\u00a1[\u00ee\u0094\u00ef\u00a43\u00833\u0093.B\u0082\u0095LW\u0086$\u00e7\u00ed\u00d2\u0007\u00ddC\u00dfS;\u0087-\u0007\u00afV\u00f5\u009d\u0099\u00b1o(\u00da\u00efy\u00fd{eH'\u00c9\u00da<\u0090\u00d0\"\u008ew:o\u00a8\u00bb\u00ae\u00dd`\u008f\u00ae{\u00ad\u0003\u00d7\u00e3iU\u0091\u001c\u00b0\u00cb\u00a3\u00ca\u00d0\u00c3\u000f\u008b\u008d\u001d\u0098\u001f\u00a5a\u00fc\u0099,\u0097\u001f\u0005\u0087\u00aa\"!\rJ\u0080\u00ad\u00a0d\u00b8<\u00fe\u00a8\"b\u00f9\u00feA\u00d8-\u00d0\u00f2*\u00ca?\u00f6F\u00bc\u00cb^\b\u001a\u00ebt\u0014\u00a0\u000e\u00ad\u009d\u00d9\u009a\u0087\u00e5r\u00f4\u00fb-\u00db?\u0080\u0089\u001b\u00fe$\u00b4\u00a8\u00d1\u0016-\u00d6G\u00ee\u00c1F\u0093\u0090\u00e6zs\u00e0\u0018\u00d7\bZ\bB\u00ebG+\n'\u00bdK\u009c:t\u0083\u00b09@\u0018\u00c3\u00a6\u0013\u00f5$\u0001\u00b2j\u00aa\u00b0\u00be\u0012\u00c5I\u00d0`\u00c2\u00a2\u00f9\u00e6L7\u00db\u00bc)/\u0095\u008b\u0093\u0095\u00c2c\u00f4\u00dcw\u00b4\u0013\u00e6\u00da\u0095\u0090 K\u009a\u00b9\u00b3\u00b3\u00e5\u0085\u00fb\u0014,y\u0083\u0090\u0083\u00b3\u0012u\u008b\u00df\u00a0\u0011#KJ\t\u00cc\u001c\u00f2\u00af\u0019\u00f68\u0084}".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 124;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "&\u00ddScw%\u00c6\u00f1\u0091.\u00e4\u00c1\u0015y\u0012\u001d)\u000f\u0012L\u000e\u00cbX\u00ad\u001e\u00f4\u00f8\u00d9p\u0014\u00fd>\u0005\u009c\u00ae\u00db]\u0094\u008f\u00ebc\u008e\u00cfQ\u00b31\u000fk\u0003\u0085";
                    var4_3 = "&\u00ddScw%\u00c6\u00f1\u0091.\u00e4\u00c1\u0015y\u0012\u001d)\u000f\u0012L\u000e\u00cbX\u00ad\u001e\u00f4\u00f8\u00d9p\u0014\u00fd>\u0005\u009c\u00ae\u00db]\u0094\u008f\u00ebc\u008e\u00cfQ\u00b31\u000fk\u0003\u0085".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 66;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 95;
                            break;
                        }
                        case 1: {
                            v15 = 47;
                            break;
                        }
                        case 2: {
                            v15 = 109;
                            break;
                        }
                        case 3: {
                            v15 = 114;
                            break;
                        }
                        case 4: {
                            v15 = 121;
                            break;
                        }
                        case 5: {
                            v15 = 44;
                            break;
                        }
                        default: {
                            v15 = 44;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x5201) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 40;
                case 1 -> 201;
                case 2 -> 157;
                case 3 -> 76;
                case 4 -> 136;
                case 5 -> 228;
                case 6 -> 206;
                case 7 -> 226;
                case 8 -> 194;
                case 9 -> 227;
                case 10 -> 0;
                case 11 -> 207;
                case 12 -> 22;
                case 13 -> 35;
                case 14 -> 36;
                case 15 -> 33;
                case 16 -> 53;
                case 17 -> 232;
                case 18 -> 125;
                case 19 -> 242;
                case 20 -> 192;
                case 21 -> 163;
                case 22 -> 168;
                case 23 -> 218;
                case 24 -> 52;
                case 25 -> 188;
                case 26 -> 112;
                case 27 -> 213;
                case 28 -> 71;
                case 29 -> 231;
                case 30 -> 146;
                case 31 -> 156;
                case 32 -> 88;
                case 33 -> 199;
                case 34 -> 46;
                case 35 -> 155;
                case 36 -> 75;
                case 37 -> 9;
                case 38 -> 202;
                case 39 -> 176;
                case 40 -> 44;
                case 41 -> 12;
                case 42 -> 148;
                case 43 -> 21;
                case 44 -> 246;
                case 45 -> 135;
                case 46 -> 134;
                case 47 -> 139;
                case 48 -> 79;
                case 49 -> 54;
                case 50 -> 138;
                case 51 -> 185;
                case 52 -> 127;
                case 53 -> 208;
                case 54 -> 27;
                case 55 -> 58;
                case 56 -> 204;
                case 57 -> 219;
                case 58 -> 41;
                case 59 -> 72;
                case 60 -> 217;
                case 61 -> 170;
                case 62 -> 243;
                case 63 -> 180;
                case 64 -> 189;
                case 65 -> 164;
                case 66 -> 30;
                case 67 -> 241;
                case 68 -> 51;
                case 69 -> 80;
                case 70 -> 18;
                case 71 -> 48;
                case 72 -> 31;
                case 73 -> 42;
                case 74 -> 171;
                case 75 -> 210;
                case 76 -> 150;
                case 77 -> 108;
                case 78 -> 235;
                case 79 -> 191;
                case 80 -> 133;
                case 81 -> 140;
                case 82 -> 216;
                case 83 -> 81;
                case 84 -> 224;
                case 85 -> 50;
                case 86 -> 29;
                case 87 -> 197;
                case 88 -> 43;
                case 89 -> 111;
                case 90 -> 59;
                case 91 -> 83;
                case 92 -> 151;
                case 93 -> 182;
                case 94 -> 73;
                case 95 -> 173;
                case 96 -> 93;
                case 97 -> 15;
                case 98 -> 47;
                case 99 -> 115;
                case 100 -> 89;
                case 101 -> 120;
                case 102 -> 177;
                case 103 -> 172;
                case 104 -> 90;
                case 105 -> 144;
                case 106 -> 215;
                case 107 -> 16;
                case 108 -> 74;
                case 109 -> 244;
                case 110 -> 186;
                case 111 -> 205;
                case 112 -> 122;
                case 113 -> 221;
                case 114 -> 97;
                case 115 -> 87;
                case 116 -> 175;
                case 117 -> 17;
                case 118 -> 240;
                case 119 -> 28;
                case 120 -> 6;
                case 121 -> 102;
                case 122 -> 20;
                case 123 -> 82;
                case 124 -> 116;
                case 125 -> 109;
                case 126 -> 248;
                case 127 -> 86;
                case 128 -> 183;
                case 129 -> 230;
                case 130 -> 7;
                case 131 -> 162;
                case 132 -> 254;
                case 133 -> 152;
                case 134 -> 222;
                case 135 -> 56;
                case 136 -> 78;
                case 137 -> 62;
                case 138 -> 250;
                case 139 -> 65;
                case 140 -> 128;
                case 141 -> 101;
                case 142 -> 23;
                case 143 -> 84;
                case 144 -> 167;
                case 145 -> 69;
                case 146 -> 113;
                case 147 -> 249;
                case 148 -> 95;
                case 149 -> 238;
                case 150 -> 229;
                case 151 -> 24;
                case 152 -> 1;
                case 153 -> 25;
                case 154 -> 223;
                case 155 -> 252;
                case 156 -> 11;
                case 157 -> 117;
                case 158 -> 245;
                case 159 -> 32;
                case 160 -> 154;
                case 161 -> 2;
                case 162 -> 66;
                case 163 -> 38;
                case 164 -> 26;
                case 165 -> 158;
                case 166 -> 55;
                case 167 -> 220;
                case 168 -> 131;
                case 169 -> 233;
                case 170 -> 236;
                case 171 -> 212;
                case 172 -> 193;
                case 173 -> 61;
                case 174 -> 57;
                case 175 -> 94;
                case 176 -> 190;
                case 177 -> 237;
                case 178 -> 181;
                case 179 -> 91;
                case 180 -> 137;
                case 181 -> 39;
                case 182 -> 49;
                case 183 -> 13;
                case 184 -> 195;
                case 185 -> 178;
                case 186 -> 203;
                case 187 -> 165;
                case 188 -> 107;
                case 189 -> 145;
                case 190 -> 45;
                case 191 -> 99;
                case 192 -> 85;
                case 193 -> 214;
                case 194 -> 174;
                case 195 -> 37;
                case 196 -> 200;
                case 197 -> 239;
                case 198 -> 10;
                case 199 -> 5;
                case 200 -> 119;
                case 201 -> 126;
                case 202 -> 110;
                case 203 -> 70;
                case 204 -> 4;
                case 205 -> 166;
                case 206 -> 143;
                case 207 -> 3;
                case 208 -> 130;
                case 209 -> 153;
                case 210 -> 253;
                case 211 -> 77;
                case 212 -> 123;
                case 213 -> 255;
                case 214 -> 96;
                case 215 -> 159;
                case 216 -> 100;
                case 217 -> 169;
                case 218 -> 103;
                case 219 -> 60;
                case 220 -> 106;
                case 221 -> 141;
                case 222 -> 105;
                case 223 -> 149;
                case 224 -> 8;
                case 225 -> 184;
                case 226 -> 247;
                case 227 -> 129;
                case 228 -> 234;
                case 229 -> 160;
                case 230 -> 196;
                case 231 -> 34;
                case 232 -> 179;
                case 233 -> 142;
                case 234 -> 132;
                case 235 -> 114;
                case 236 -> 98;
                case 237 -> 161;
                case 238 -> 121;
                case 239 -> 14;
                case 240 -> 198;
                case 241 -> 124;
                case 242 -> 68;
                case 243 -> 187;
                case 244 -> 104;
                case 245 -> 147;
                case 246 -> 67;
                case 247 -> 19;
                case 248 -> 63;
                case 249 -> 251;
                case 250 -> 225;
                case 251 -> 211;
                case 252 -> 92;
                case 253 -> 64;
                case 254 -> 209;
                default -> 118;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l = 17907905066364L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(2108523090 + (char)-4830, -2108523090 + -((char)-30648), (int)l));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l = 73609046950580L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.b();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1897500390 - -((char)-22621), 1897500390 - (char)-22381, (int)l));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1897500390 - -((char)-22620), -1897500390 - -((char)-7074), (int)l) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1897500390 - -((char)-22619), 1897500390 - (char)-22057, (int)l));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00b6\u00bd\u000b{\u0090\u0012\u00e3 \u00106\u008b\u00ea\u001c\u0016E\u00ca\u0093\u00ba\u008f|\t\u00bd\u00fd5\n";
                    var4_3 = "\u00b6\u00bd\u000b{\u0090\u0012\u00e3 \u00106\u008b\u00ea\u001c\u0016E\u00ca\u0093\u00ba\u008f|\t\u00bd\u00fd5\n".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 69;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "{/\u00a38\u00e45\u00f0\u0086\u00c5a\u00fa\u00c2^\u00d9Nla\u00a4\u00f8\u00b3\u0089X\u0095sV\u0017\u0087&\u00d3\r\u00af\u00a0\u00bc\u0017(]\u0091F\u00a2\u00ef\u00d6\u008a\u00ebR\u00b6\u00cc-\u00d3\u00ae\u00b1#\u0002\u0094\u00c1J\u0003{\u00a9\u00bc";
                        var4_3 = "{/\u00a38\u00e45\u00f0\u0086\u00c5a\u00fa\u00c2^\u00d9Nla\u00a4\u00f8\u00b3\u0089X\u0095sV\u0017\u0087&\u00d3\r\u00af\u00a0\u00bc\u0017(]\u0091F\u00a2\u00ef\u00d6\u008a\u00ebR\u00b6\u00cc-\u00d3\u00ae\u00b1#\u0002\u0094\u00c1J\u0003{\u00a9\u00bc".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 31;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 33;
                                break;
                            }
                            case 1: {
                                v15 = 25;
                                break;
                            }
                            case 2: {
                                v15 = 26;
                                break;
                            }
                            case 3: {
                                v15 = 35;
                                break;
                            }
                            case 4: {
                                v15 = 113;
                                break;
                            }
                            case 5: {
                                v15 = 92;
                                break;
                            }
                            default: {
                                v15 = 28;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF9A08) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 236;
                    case 1 -> 238;
                    case 2 -> 102;
                    case 3 -> 184;
                    case 4 -> 139;
                    case 5 -> 186;
                    case 6 -> 237;
                    case 7 -> 182;
                    case 8 -> 160;
                    case 9 -> 91;
                    case 10 -> 44;
                    case 11 -> 166;
                    case 12 -> 170;
                    case 13 -> 60;
                    case 14 -> 175;
                    case 15 -> 104;
                    case 16 -> 68;
                    case 17 -> 141;
                    case 18 -> 14;
                    case 19 -> 129;
                    case 20 -> 108;
                    case 21 -> 86;
                    case 22 -> 84;
                    case 23 -> 134;
                    case 24 -> 23;
                    case 25 -> 255;
                    case 26 -> 93;
                    case 27 -> 88;
                    case 28 -> 73;
                    case 29 -> 127;
                    case 30 -> 55;
                    case 31 -> 167;
                    case 32 -> 118;
                    case 33 -> 194;
                    case 34 -> 227;
                    case 35 -> 114;
                    case 36 -> 169;
                    case 37 -> 109;
                    case 38 -> 53;
                    case 39 -> 241;
                    case 40 -> 12;
                    case 41 -> 77;
                    case 42 -> 123;
                    case 43 -> 18;
                    case 44 -> 248;
                    case 45 -> 13;
                    case 46 -> 213;
                    case 47 -> 163;
                    case 48 -> 197;
                    case 49 -> 222;
                    case 50 -> 35;
                    case 51 -> 124;
                    case 52 -> 56;
                    case 53 -> 30;
                    case 54 -> 7;
                    case 55 -> 83;
                    case 56 -> 31;
                    case 57 -> 78;
                    case 58 -> 240;
                    case 59 -> 156;
                    case 60 -> 209;
                    case 61 -> 158;
                    case 62 -> 142;
                    case 63 -> 235;
                    case 64 -> 6;
                    case 65 -> 52;
                    case 66 -> 20;
                    case 67 -> 164;
                    case 68 -> 11;
                    case 69 -> 151;
                    case 70 -> 152;
                    case 71 -> 4;
                    case 72 -> 61;
                    case 73 -> 144;
                    case 74 -> 190;
                    case 75 -> 92;
                    case 76 -> 2;
                    case 77 -> 250;
                    case 78 -> 147;
                    case 79 -> 193;
                    case 80 -> 140;
                    case 81 -> 8;
                    case 82 -> 178;
                    case 83 -> 47;
                    case 84 -> 155;
                    case 85 -> 207;
                    case 86 -> 105;
                    case 87 -> 153;
                    case 88 -> 46;
                    case 89 -> 99;
                    case 90 -> 214;
                    case 91 -> 130;
                    case 92 -> 89;
                    case 93 -> 51;
                    case 94 -> 36;
                    case 95 -> 116;
                    case 96 -> 1;
                    case 97 -> 245;
                    case 98 -> 103;
                    case 99 -> 43;
                    case 100 -> 216;
                    case 101 -> 107;
                    case 102 -> 146;
                    case 103 -> 157;
                    case 104 -> 181;
                    case 105 -> 205;
                    case 106 -> 3;
                    case 107 -> 5;
                    case 108 -> 63;
                    case 109 -> 101;
                    case 110 -> 168;
                    case 111 -> 16;
                    case 112 -> 150;
                    case 113 -> 192;
                    case 114 -> 247;
                    case 115 -> 29;
                    case 116 -> 28;
                    case 117 -> 172;
                    case 118 -> 45;
                    case 119 -> 177;
                    case 120 -> 135;
                    case 121 -> 80;
                    case 122 -> 232;
                    case 123 -> 165;
                    case 124 -> 33;
                    case 125 -> 19;
                    case 126 -> 37;
                    case 127 -> 48;
                    case 128 -> 218;
                    case 129 -> 223;
                    case 130 -> 143;
                    case 131 -> 70;
                    case 132 -> 244;
                    case 133 -> 115;
                    case 134 -> 226;
                    case 135 -> 128;
                    case 136 -> 233;
                    case 137 -> 74;
                    case 138 -> 76;
                    case 139 -> 67;
                    case 140 -> 171;
                    case 141 -> 201;
                    case 142 -> 27;
                    case 143 -> 113;
                    case 144 -> 90;
                    case 145 -> 72;
                    case 146 -> 234;
                    case 147 -> 49;
                    case 148 -> 180;
                    case 149 -> 126;
                    case 150 -> 9;
                    case 151 -> 173;
                    case 152 -> 98;
                    case 153 -> 224;
                    case 154 -> 231;
                    case 155 -> 219;
                    case 156 -> 75;
                    case 157 -> 188;
                    case 158 -> 34;
                    case 159 -> 161;
                    case 160 -> 200;
                    case 161 -> 65;
                    case 162 -> 122;
                    case 163 -> 159;
                    case 164 -> 32;
                    case 165 -> 94;
                    case 166 -> 206;
                    case 167 -> 217;
                    case 168 -> 211;
                    case 169 -> 57;
                    case 170 -> 38;
                    case 171 -> 117;
                    case 172 -> 106;
                    case 173 -> 17;
                    case 174 -> 79;
                    case 175 -> 191;
                    case 176 -> 81;
                    case 177 -> 189;
                    case 178 -> 95;
                    case 179 -> 25;
                    case 180 -> 249;
                    case 181 -> 239;
                    case 182 -> 220;
                    case 183 -> 148;
                    case 184 -> 138;
                    case 185 -> 174;
                    case 186 -> 110;
                    case 187 -> 195;
                    case 188 -> 154;
                    case 189 -> 24;
                    case 190 -> 121;
                    case 191 -> 196;
                    case 192 -> 132;
                    case 193 -> 41;
                    case 194 -> 229;
                    case 195 -> 198;
                    case 196 -> 210;
                    case 197 -> 176;
                    case 198 -> 225;
                    case 199 -> 40;
                    case 200 -> 82;
                    case 201 -> 137;
                    case 202 -> 215;
                    case 203 -> 208;
                    case 204 -> 64;
                    case 205 -> 179;
                    case 206 -> 199;
                    case 207 -> 97;
                    case 208 -> 39;
                    case 209 -> 136;
                    case 210 -> 120;
                    case 211 -> 69;
                    case 212 -> 133;
                    case 213 -> 149;
                    case 214 -> 187;
                    case 215 -> 50;
                    case 216 -> 251;
                    case 217 -> 228;
                    case 218 -> 10;
                    case 219 -> 62;
                    case 220 -> 252;
                    case 221 -> 87;
                    case 222 -> 230;
                    case 223 -> 22;
                    case 224 -> 100;
                    case 225 -> 185;
                    case 226 -> 26;
                    case 227 -> 21;
                    case 228 -> 212;
                    case 229 -> 253;
                    case 230 -> 71;
                    case 231 -> 221;
                    case 232 -> 162;
                    case 233 -> 145;
                    case 234 -> 112;
                    case 235 -> 42;
                    case 236 -> 203;
                    case 237 -> 59;
                    case 238 -> 85;
                    case 239 -> 242;
                    case 240 -> 66;
                    case 241 -> 131;
                    case 242 -> 243;
                    case 243 -> 246;
                    case 244 -> 15;
                    case 245 -> 58;
                    case 246 -> 119;
                    case 247 -> 202;
                    case 248 -> 204;
                    case 249 -> 254;
                    case 250 -> 96;
                    case 251 -> 125;
                    case 252 -> 0;
                    case 253 -> 54;
                    case 254 -> 111;
                    default -> 183;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 7751928915984L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "jo%m\u00165\u000b3\tme6g[w\u0016/#";
                    var5_4 = "jo%m\u00165\u000b3\tme6g[w\u0016/#".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 53;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 52;
                                    break;
                                }
                                case 1: {
                                    v11 = 63;
                                    break;
                                }
                                case 2: {
                                    v11 = 98;
                                    break;
                                }
                                case 3: {
                                    v11 = 54;
                                    break;
                                }
                                case 4: {
                                    v11 = 70;
                                    break;
                                }
                                case 5: {
                                    v11 = 108;
                                    break;
                                }
                                default: {
                                    v11 = 13;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 36518621797427L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "kn?\u0012Y:{\u0004mp3\b\nao8\bU8cKn1\tao8\bU8cGd\rfi%\u0005_5yGc\"\u000f^<";
                    var5_4 = "kn?\u0012Y:{\u0004mp3\b\nao8\bU8cKn1\tao8\bU8cGd\rfi%\u0005_5yGc\"\u000f^<".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 100;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "85`L\u0000l)\u000685`L\ff";
                        var5_4 = "85`L\u0000l)\u000685`L\ff".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 61;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 70;
                                break;
                            }
                            case 1: {
                                v15 = 100;
                                break;
                            }
                            case 2: {
                                v15 = 50;
                                break;
                            }
                            case 3: {
                                v15 = 2;
                                break;
                            }
                            case 4: {
                                v15 = 84;
                                break;
                            }
                            case 5: {
                                v15 = 63;
                                break;
                            }
                            default: {
                                v15 = 115;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l = 94489906583219L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(626121390 - 30027, -626121390 - -26932, (int)l));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l = 135439758990748L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "D\u0082E\u0010\u00e0\u0003T\u0087\u00f3\u0005\u00aa/\u00bea|\r\u00ca}\u0084a\u00ce\u00dd\u0085\u00ac\u00fb\u00da\u00ff\u00c4\u0089\u0010m\u008b\u00b7T\u0097\u00ee\u0085\u00f725%t4-\u0015q\u0005\u0093\u00c8\u0099\u009d\u009835\u00f1\\\u00cd?\u0099\u00a0\r\u00eb\u0097\u0095\t\u00e4\u00d3#\u00b1\u00d7\fRK\u00ce\u00ab\u00ec\u0013\u00da\u00c7H\u00c3\b\u0003\u008d\u0089\u00db\u0003w|U\u00e9\u0088\u008a\u00c4/\u0082l\u00f0\u0092\u00bbJHB\u00bb";
                    var4_3 = "D\u0082E\u0010\u00e0\u0003T\u0087\u00f3\u0005\u00aa/\u00bea|\r\u00ca}\u0084a\u00ce\u00dd\u0085\u00ac\u00fb\u00da\u00ff\u00c4\u0089\u0010m\u008b\u00b7T\u0097\u00ee\u0085\u00f725%t4-\u0015q\u0005\u0093\u00c8\u0099\u009d\u009835\u00f1\\\u00cd?\u0099\u00a0\r\u00eb\u0097\u0095\t\u00e4\u00d3#\u00b1\u00d7\fRK\u00ce\u00ab\u00ec\u0013\u00da\u00c7H\u00c3\b\u0003\u008d\u0089\u00db\u0003w|U\u00e9\u0088\u008a\u00c4/\u0082l\u00f0\u0092\u00bbJHB\u00bb".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 22;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "1\u008b\u00db\u00b3\u00fd\u00f5/s\u0080B\u0094}\u00e5\u00eb\u00c8NL\u00a87\u001f\u00eeO\u0096\u0017q\u000e\u0091\u00e9\u00beD\u001do\u00e9\u00bc1'\u00fd\u00ef\u00fe\u0005\u00fc#6\u00b5\u00dc\u00aaN\u00d1\u00a8\u00a7.n\"\u00a3\u001b\u008bUu\u00ce\u009c\u00ca\u00c1\u007f\u00b1(\u001c\u00dd>&\u00c0p\u00ca\u00eb6\u00c0[\u001f\u00c3#PJ\u00a6\u00ef\u00f5\u000f\u00ad\u00d0\u0004\u0080>#z(";
                        var4_3 = "1\u008b\u00db\u00b3\u00fd\u00f5/s\u0080B\u0094}\u00e5\u00eb\u00c8NL\u00a87\u001f\u00eeO\u0096\u0017q\u000e\u0091\u00e9\u00beD\u001do\u00e9\u00bc1'\u00fd\u00ef\u00fe\u0005\u00fc#6\u00b5\u00dc\u00aaN\u00d1\u00a8\u00a7.n\"\u00a3\u001b\u008bUu\u00ce\u009c\u00ca\u00c1\u007f\u00b1(\u001c\u00dd>&\u00c0p\u00ca\u00eb6\u00c0[\u001f\u00c3#PJ\u00a6\u00ef\u00f5\u000f\u00ad\u00d0\u0004\u0080>#z(".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 17;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 3;
                                break;
                            }
                            case 1: {
                                v15 = 96;
                                break;
                            }
                            case 2: {
                                v15 = 81;
                                break;
                            }
                            case 3: {
                                v15 = 125;
                                break;
                            }
                            case 4: {
                                v15 = 11;
                                break;
                            }
                            case 5: {
                                v15 = 12;
                                break;
                            }
                            default: {
                                v15 = 21;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x73D0) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 163;
                    case 1 -> 150;
                    case 2 -> 131;
                    case 3 -> 108;
                    case 4 -> 41;
                    case 5 -> 44;
                    case 6 -> 221;
                    case 7 -> 211;
                    case 8 -> 242;
                    case 9 -> 112;
                    case 10 -> 240;
                    case 11 -> 231;
                    case 12 -> 102;
                    case 13 -> 246;
                    case 14 -> 241;
                    case 15 -> 23;
                    case 16 -> 86;
                    case 17 -> 30;
                    case 18 -> 54;
                    case 19 -> 236;
                    case 20 -> 201;
                    case 21 -> 56;
                    case 22 -> 230;
                    case 23 -> 14;
                    case 24 -> 129;
                    case 25 -> 7;
                    case 26 -> 119;
                    case 27 -> 20;
                    case 28 -> 83;
                    case 29 -> 153;
                    case 30 -> 137;
                    case 31 -> 149;
                    case 32 -> 196;
                    case 33 -> 1;
                    case 34 -> 200;
                    case 35 -> 147;
                    case 36 -> 138;
                    case 37 -> 101;
                    case 38 -> 71;
                    case 39 -> 216;
                    case 40 -> 35;
                    case 41 -> 151;
                    case 42 -> 202;
                    case 43 -> 25;
                    case 44 -> 192;
                    case 45 -> 245;
                    case 46 -> 146;
                    case 47 -> 118;
                    case 48 -> 110;
                    case 49 -> 4;
                    case 50 -> 233;
                    case 51 -> 85;
                    case 52 -> 36;
                    case 53 -> 61;
                    case 54 -> 248;
                    case 55 -> 69;
                    case 56 -> 97;
                    case 57 -> 167;
                    case 58 -> 251;
                    case 59 -> 214;
                    case 60 -> 60;
                    case 61 -> 130;
                    case 62 -> 105;
                    case 63 -> 2;
                    case 64 -> 179;
                    case 65 -> 148;
                    case 66 -> 218;
                    case 67 -> 145;
                    case 68 -> 93;
                    case 69 -> 9;
                    case 70 -> 187;
                    case 71 -> 210;
                    case 72 -> 217;
                    case 73 -> 39;
                    case 74 -> 104;
                    case 75 -> 13;
                    case 76 -> 82;
                    case 77 -> 234;
                    case 78 -> 134;
                    case 79 -> 64;
                    case 80 -> 19;
                    case 81 -> 5;
                    case 82 -> 78;
                    case 83 -> 126;
                    case 84 -> 76;
                    case 85 -> 223;
                    case 86 -> 122;
                    case 87 -> 75;
                    case 88 -> 160;
                    case 89 -> 132;
                    case 90 -> 89;
                    case 91 -> 208;
                    case 92 -> 128;
                    case 93 -> 67;
                    case 94 -> 72;
                    case 95 -> 80;
                    case 96 -> 28;
                    case 97 -> 65;
                    case 98 -> 191;
                    case 99 -> 88;
                    case 100 -> 10;
                    case 101 -> 3;
                    case 102 -> 107;
                    case 103 -> 250;
                    case 104 -> 173;
                    case 105 -> 169;
                    case 106 -> 24;
                    case 107 -> 152;
                    case 108 -> 57;
                    case 109 -> 100;
                    case 110 -> 166;
                    case 111 -> 194;
                    case 112 -> 79;
                    case 113 -> 84;
                    case 114 -> 189;
                    case 115 -> 91;
                    case 116 -> 190;
                    case 117 -> 244;
                    case 118 -> 6;
                    case 119 -> 184;
                    case 120 -> 228;
                    case 121 -> 197;
                    case 122 -> 249;
                    case 123 -> 120;
                    case 124 -> 63;
                    case 125 -> 49;
                    case 126 -> 253;
                    case 127 -> 55;
                    case 128 -> 135;
                    case 129 -> 45;
                    case 130 -> 199;
                    case 131 -> 59;
                    case 132 -> 213;
                    case 133 -> 224;
                    case 134 -> 98;
                    case 135 -> 0;
                    case 136 -> 22;
                    case 137 -> 255;
                    case 138 -> 87;
                    case 139 -> 18;
                    case 140 -> 29;
                    case 141 -> 225;
                    case 142 -> 77;
                    case 143 -> 168;
                    case 144 -> 207;
                    case 145 -> 155;
                    case 146 -> 170;
                    case 147 -> 31;
                    case 148 -> 32;
                    case 149 -> 215;
                    case 150 -> 161;
                    case 151 -> 136;
                    case 152 -> 235;
                    case 153 -> 90;
                    case 154 -> 237;
                    case 155 -> 252;
                    case 156 -> 203;
                    case 157 -> 181;
                    case 158 -> 209;
                    case 159 -> 123;
                    case 160 -> 53;
                    case 161 -> 103;
                    case 162 -> 33;
                    case 163 -> 127;
                    case 164 -> 175;
                    case 165 -> 144;
                    case 166 -> 40;
                    case 167 -> 159;
                    case 168 -> 124;
                    case 169 -> 182;
                    case 170 -> 92;
                    case 171 -> 111;
                    case 172 -> 109;
                    case 173 -> 239;
                    case 174 -> 17;
                    case 175 -> 21;
                    case 176 -> 52;
                    case 177 -> 238;
                    case 178 -> 121;
                    case 179 -> 37;
                    case 180 -> 27;
                    case 181 -> 125;
                    case 182 -> 96;
                    case 183 -> 162;
                    case 184 -> 50;
                    case 185 -> 117;
                    case 186 -> 154;
                    case 187 -> 229;
                    case 188 -> 198;
                    case 189 -> 11;
                    case 190 -> 171;
                    case 191 -> 165;
                    case 192 -> 183;
                    case 193 -> 180;
                    case 194 -> 204;
                    case 195 -> 99;
                    case 196 -> 66;
                    case 197 -> 177;
                    case 198 -> 114;
                    case 199 -> 47;
                    case 200 -> 157;
                    case 201 -> 247;
                    case 202 -> 51;
                    case 203 -> 156;
                    case 204 -> 68;
                    case 205 -> 8;
                    case 206 -> 206;
                    case 207 -> 139;
                    case 208 -> 186;
                    case 209 -> 43;
                    case 210 -> 133;
                    case 211 -> 94;
                    case 212 -> 46;
                    case 213 -> 219;
                    case 214 -> 115;
                    case 215 -> 116;
                    case 216 -> 15;
                    case 217 -> 38;
                    case 218 -> 185;
                    case 219 -> 58;
                    case 220 -> 143;
                    case 221 -> 176;
                    case 222 -> 212;
                    case 223 -> 34;
                    case 224 -> 205;
                    case 225 -> 12;
                    case 226 -> 174;
                    case 227 -> 95;
                    case 228 -> 172;
                    case 229 -> 226;
                    case 230 -> 158;
                    case 231 -> 62;
                    case 232 -> 222;
                    case 233 -> 195;
                    case 234 -> 106;
                    case 235 -> 220;
                    case 236 -> 140;
                    case 237 -> 142;
                    case 238 -> 188;
                    case 239 -> 42;
                    case 240 -> 48;
                    case 241 -> 232;
                    case 242 -> 193;
                    case 243 -> 81;
                    case 244 -> 113;
                    case 245 -> 16;
                    case 246 -> 178;
                    case 247 -> 74;
                    case 248 -> 73;
                    case 249 -> 141;
                    case 250 -> 227;
                    case 251 -> 26;
                    case 252 -> 164;
                    case 253 -> 243;
                    case 254 -> 70;
                    default -> 254;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l = 121756629811923L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1398123690 - (char)-14626, -1397992620 + -((char)-8500), (int)l));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l = 101826822615872L;
                    int[] nArray = SshAgentIpcService.b();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1737988200 - -11462, -1737988200 - -((char)-30755), (int)l));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l = 127728868093L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "%4\u0082 \u007f\u0003$\u00fc\u00f4";
                var4_3 = "%4\u0082 \u007f\u0003$\u00fc\u00f4".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 45;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 47;
                                break;
                            }
                            case 1: {
                                v11 = 95;
                                break;
                            }
                            case 2: {
                                v11 = 99;
                                break;
                            }
                            case 3: {
                                v11 = 32;
                                break;
                            }
                            case 4: {
                                v11 = 118;
                                break;
                            }
                            case 5: {
                                v11 = 70;
                                break;
                            }
                            default: {
                                v11 = 120;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFA71F) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 139;
                    case 1 -> 141;
                    case 2 -> 211;
                    case 3 -> 130;
                    case 4 -> 160;
                    case 5 -> 164;
                    case 6 -> 121;
                    case 7 -> 181;
                    case 8 -> 122;
                    case 9 -> 3;
                    case 10 -> 30;
                    case 11 -> 132;
                    case 12 -> 10;
                    case 13 -> 228;
                    case 14 -> 198;
                    case 15 -> 45;
                    case 16 -> 237;
                    case 17 -> 127;
                    case 18 -> 65;
                    case 19 -> 37;
                    case 20 -> 1;
                    case 21 -> 177;
                    case 22 -> 46;
                    case 23 -> 114;
                    case 24 -> 222;
                    case 25 -> 5;
                    case 26 -> 115;
                    case 27 -> 147;
                    case 28 -> 109;
                    case 29 -> 96;
                    case 30 -> 250;
                    case 31 -> 158;
                    case 32 -> 129;
                    case 33 -> 247;
                    case 34 -> 4;
                    case 35 -> 202;
                    case 36 -> 169;
                    case 37 -> 248;
                    case 38 -> 224;
                    case 39 -> 21;
                    case 40 -> 99;
                    case 41 -> 146;
                    case 42 -> 35;
                    case 43 -> 6;
                    case 44 -> 152;
                    case 45 -> 54;
                    case 46 -> 41;
                    case 47 -> 253;
                    case 48 -> 71;
                    case 49 -> 142;
                    case 50 -> 195;
                    case 51 -> 39;
                    case 52 -> 235;
                    case 53 -> 113;
                    case 54 -> 108;
                    case 55 -> 206;
                    case 56 -> 199;
                    case 57 -> 231;
                    case 58 -> 28;
                    case 59 -> 87;
                    case 60 -> 48;
                    case 61 -> 201;
                    case 62 -> 245;
                    case 63 -> 69;
                    case 64 -> 2;
                    case 65 -> 94;
                    case 66 -> 86;
                    case 67 -> 128;
                    case 68 -> 12;
                    case 69 -> 93;
                    case 70 -> 241;
                    case 71 -> 53;
                    case 72 -> 107;
                    case 73 -> 82;
                    case 74 -> 22;
                    case 75 -> 221;
                    case 76 -> 78;
                    case 77 -> 145;
                    case 78 -> 34;
                    case 79 -> 90;
                    case 80 -> 200;
                    case 81 -> 187;
                    case 82 -> 182;
                    case 83 -> 26;
                    case 84 -> 112;
                    case 85 -> 47;
                    case 86 -> 101;
                    case 87 -> 50;
                    case 88 -> 163;
                    case 89 -> 148;
                    case 90 -> 249;
                    case 91 -> 140;
                    case 92 -> 185;
                    case 93 -> 157;
                    case 94 -> 61;
                    case 95 -> 197;
                    case 96 -> 83;
                    case 97 -> 151;
                    case 98 -> 66;
                    case 99 -> 14;
                    case 100 -> 0;
                    case 101 -> 55;
                    case 102 -> 135;
                    case 103 -> 165;
                    case 104 -> 97;
                    case 105 -> 70;
                    case 106 -> 203;
                    case 107 -> 170;
                    case 108 -> 220;
                    case 109 -> 27;
                    case 110 -> 205;
                    case 111 -> 240;
                    case 112 -> 246;
                    case 113 -> 80;
                    case 114 -> 123;
                    case 115 -> 208;
                    case 116 -> 214;
                    case 117 -> 44;
                    case 118 -> 143;
                    case 119 -> 32;
                    case 120 -> 144;
                    case 121 -> 75;
                    case 122 -> 81;
                    case 123 -> 134;
                    case 124 -> 210;
                    case 125 -> 223;
                    case 126 -> 150;
                    case 127 -> 194;
                    case 128 -> 136;
                    case 129 -> 232;
                    case 130 -> 173;
                    case 131 -> 85;
                    case 132 -> 89;
                    case 133 -> 213;
                    case 134 -> 124;
                    case 135 -> 188;
                    case 136 -> 192;
                    case 137 -> 110;
                    case 138 -> 91;
                    case 139 -> 166;
                    case 140 -> 159;
                    case 141 -> 255;
                    case 142 -> 63;
                    case 143 -> 103;
                    case 144 -> 60;
                    case 145 -> 74;
                    case 146 -> 88;
                    case 147 -> 171;
                    case 148 -> 196;
                    case 149 -> 17;
                    case 150 -> 191;
                    case 151 -> 189;
                    case 152 -> 25;
                    case 153 -> 153;
                    case 154 -> 31;
                    case 155 -> 226;
                    case 156 -> 234;
                    case 157 -> 105;
                    case 158 -> 118;
                    case 159 -> 243;
                    case 160 -> 167;
                    case 161 -> 239;
                    case 162 -> 176;
                    case 163 -> 155;
                    case 164 -> 68;
                    case 165 -> 104;
                    case 166 -> 131;
                    case 167 -> 20;
                    case 168 -> 161;
                    case 169 -> 238;
                    case 170 -> 15;
                    case 171 -> 242;
                    case 172 -> 59;
                    case 173 -> 179;
                    case 174 -> 137;
                    case 175 -> 225;
                    case 176 -> 8;
                    case 177 -> 76;
                    case 178 -> 36;
                    case 179 -> 219;
                    case 180 -> 92;
                    case 181 -> 117;
                    case 182 -> 233;
                    case 183 -> 57;
                    case 184 -> 251;
                    case 185 -> 174;
                    case 186 -> 23;
                    case 187 -> 172;
                    case 188 -> 77;
                    case 189 -> 84;
                    case 190 -> 125;
                    case 191 -> 186;
                    case 192 -> 111;
                    case 193 -> 100;
                    case 194 -> 51;
                    case 195 -> 102;
                    case 196 -> 193;
                    case 197 -> 42;
                    case 198 -> 212;
                    case 199 -> 154;
                    case 200 -> 190;
                    case 201 -> 62;
                    case 202 -> 119;
                    case 203 -> 138;
                    case 204 -> 13;
                    case 205 -> 207;
                    case 206 -> 29;
                    case 207 -> 18;
                    case 208 -> 244;
                    case 209 -> 168;
                    case 210 -> 218;
                    case 211 -> 162;
                    case 212 -> 209;
                    case 213 -> 67;
                    case 214 -> 40;
                    case 215 -> 156;
                    case 216 -> 120;
                    case 217 -> 38;
                    case 218 -> 133;
                    case 219 -> 79;
                    case 220 -> 73;
                    case 221 -> 56;
                    case 222 -> 58;
                    case 223 -> 106;
                    case 224 -> 254;
                    case 225 -> 229;
                    case 226 -> 227;
                    case 227 -> 16;
                    case 228 -> 7;
                    case 229 -> 43;
                    case 230 -> 184;
                    case 231 -> 52;
                    case 232 -> 175;
                    case 233 -> 149;
                    case 234 -> 217;
                    case 235 -> 180;
                    case 236 -> 236;
                    case 237 -> 33;
                    case 238 -> 19;
                    case 239 -> 216;
                    case 240 -> 116;
                    case 241 -> 126;
                    case 242 -> 64;
                    case 243 -> 49;
                    case 244 -> 230;
                    case 245 -> 252;
                    case 246 -> 183;
                    case 247 -> 24;
                    case 248 -> 215;
                    case 249 -> 178;
                    case 250 -> 95;
                    case 251 -> 204;
                    case 252 -> 9;
                    case 253 -> 72;
                    case 254 -> 11;
                    default -> 98;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

