/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.variables;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.editor.completion.JupyterRuntimeProcessListener;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.py.editor.completion.JupyterRuntimeEnvService;
import com.intellij.jupyter.py.psi.JupyterPyDialect;
import com.intellij.jupyter.py.variables.JupyterVarsFrameAccessor;
import com.intellij.jupyter.py.variables.PythonVariablesUtil;
import com.intellij.jupyter.py.variables.inline.JupyterInlineCallback;
import com.intellij.jupyter.py.variables.inline.JupyterInlineService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.impl.frame.XStandaloneVariablesView;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0011J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0011J\u001c\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001d2\u0006\u0010\u001a\u001a\u00020\u0011J\u0010\u0010 \u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u0011J\u0018\u0010!\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u001eJ\u0016\u0010#\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0012J\u000e\u0010%\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0011J\u000e\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0011J\u000e\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/jupyter/py/variables/JupyterVariablesService;", "Lcom/intellij/jupyter/core/jupyter/editor/completion/JupyterRuntimeProcessListener;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "runtimeEnvService", "Lcom/intellij/jupyter/py/editor/completion/JupyterRuntimeEnvService;", "getRuntimeEnvService", "()Lcom/intellij/jupyter/py/editor/completion/JupyterRuntimeEnvService;", "inlineService", "Lcom/intellij/jupyter/py/variables/inline/JupyterInlineService;", "getInlineService", "()Lcom/intellij/jupyter/py/variables/inline/JupyterInlineService;", "variablesViews", "", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "Lcom/intellij/xdebugger/impl/frame/XStandaloneVariablesView;", "notebookSessionEnvironmentUpdated", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "values", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "createAndCallInlineCallback", "notebookFile", "clearInlineValues", "getStackFrameAndAccessor", "Lkotlin/Pair;", "Lcom/jetbrains/python/debugger/PyStackFrame;", "Lcom/intellij/jupyter/py/variables/JupyterVarsFrameAccessor;", "getVariablesList", "createVariablesView", "stackFrame", "updateVariablesView", "variablesView", "refreshEnv", "onExecutionFinished", "notebookVirtualFile", "onSessionCreated", "session", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "onSessionDeleted", "updateInlineValues", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterVariablesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterVariablesService.kt\ncom/intellij/jupyter/py/variables/JupyterVariablesService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n30#2,2:117\n382#3,3:119\n385#3,4:123\n1#4:122\n*S KotlinDebug\n*F\n+ 1 JupyterVariablesService.kt\ncom/intellij/jupyter/py/variables/JupyterVariablesService\n*L\n29#1:117,2\n105#1:119,3\n105#1:123,4\n*E\n"})
public final class JupyterVariablesService
implements JupyterRuntimeProcessListener,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<BackedNotebookVirtualFile, XStandaloneVariablesView> variablesViews;

    public JupyterVariablesService(@NotNull Project project) {
        MessageBusConnection messageBusConnection;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.variablesViews = new LinkedHashMap();
        MessageBusConnection it = messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        boolean bl = false;
        it.subscribe(JupyterRuntimeProcessListener.Companion.getTOPIC(), (Object)this);
    }

    private final JupyterRuntimeEnvService getRuntimeEnvService() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<JupyterRuntimeEnvService> serviceClass$iv = JupyterRuntimeEnvService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (JupyterRuntimeEnvService)object;
    }

    private final JupyterInlineService getInlineService() {
        return JupyterInlineService.Companion.getInstance(this.project);
    }

    public void notebookSessionEnvironmentUpdated(@NotNull VirtualFile virtualFile, @Nullable XValueChildrenList values) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        ApplicationManager.getApplication().invokeLater(() -> JupyterVariablesService.notebookSessionEnvironmentUpdated$lambda$2(virtualFile, this));
    }

    public final void createAndCallInlineCallback(@NotNull BackedNotebookVirtualFile notebookFile) {
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        JupyterInlineCallback jupyterInlineCallback = this.getInlineService().getInlineCallback(notebookFile);
        if (jupyterInlineCallback == null) {
            return;
        }
        JupyterInlineCallback frameVarsCallback = jupyterInlineCallback;
        XValueChildrenList xValueChildrenList = this.getVariablesList(notebookFile);
        if (xValueChildrenList == null) {
            return;
        }
        XValueChildrenList values = xValueChildrenList;
        PythonVariablesUtil.INSTANCE.callJupyterInlineCallback(this.project, notebookFile, values, frameVarsCallback);
    }

    public final void clearInlineValues(@NotNull BackedNotebookVirtualFile notebookFile) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
            JupyterInlineCallback jupyterInlineCallback = this.getInlineService().getInlineCallback(notebookFile);
            if (jupyterInlineCallback == null) {
                return;
            }
            JupyterInlineCallback inlineCallback = jupyterInlineCallback;
            ScopeOwner scopeOwner = (ScopeOwner)ReadAction.compute(() -> JupyterVariablesService.clearInlineValues$lambda$3(this, notebookFile));
            if (scopeOwner == null) break block1;
            ScopeOwner scopeOwner2 = scopeOwner;
            boolean bl = false;
            XValueChildrenList xValueChildrenList = XValueChildrenList.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)xValueChildrenList, (String)"EMPTY");
            inlineCallback.frameChanged(xValueChildrenList, scopeOwner2);
        }
    }

    @Nullable
    public final Pair<PyStackFrame, JupyterVarsFrameAccessor> getStackFrameAndAccessor(@NotNull BackedNotebookVirtualFile notebookFile) {
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        JupyterVarsFrameAccessor jupyterVarsFrameAccessor = this.getRuntimeEnvService().getFrameAccessor(notebookFile.getFile());
        if (jupyterVarsFrameAccessor == null) {
            return null;
        }
        JupyterVarsFrameAccessor frameAccessor = jupyterVarsFrameAccessor;
        PyStackFrame starkFrame = new PyStackFrame(this.project, (PyFrameAccessor)frameAccessor, new PyStackFrameInfo("", "", "", null), null);
        return new Pair((Object)starkFrame, (Object)frameAccessor);
    }

    @Nullable
    public final XValueChildrenList getVariablesList(@NotNull BackedNotebookVirtualFile notebookFile) {
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        return this.getRuntimeEnvService().getXValueChildrenList(notebookFile.getFile());
    }

    @Nullable
    public final XStandaloneVariablesView createVariablesView(@NotNull BackedNotebookVirtualFile notebookFile, @NotNull PyStackFrame stackFrame) {
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        return this.getRuntimeEnvService().createVariablesView(notebookFile.getFile(), stackFrame);
    }

    public final void updateVariablesView(@NotNull BackedNotebookVirtualFile notebookFile, @NotNull XStandaloneVariablesView variablesView) {
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkNotNullParameter((Object)variablesView, (String)"variablesView");
        this.getRuntimeEnvService().updateVariablesView(notebookFile.getFile(), variablesView);
    }

    public final void refreshEnv(@NotNull BackedNotebookVirtualFile notebookFile) {
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        this.getRuntimeEnvService().refreshEnv(notebookFile);
    }

    public final void onExecutionFinished(@NotNull BackedNotebookVirtualFile notebookVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile, (String)"notebookVirtualFile");
        this.updateInlineValues(notebookVirtualFile);
    }

    public final void onSessionCreated(@NotNull JupyterNotebookSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.updateInlineValues(session.getVirtualFile());
    }

    public final void onSessionDeleted(@NotNull JupyterNotebookSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.getRuntimeEnvService().removeState(session);
        this.clearInlineValues(session.getVirtualFile());
    }

    /*
     * WARNING - void declaration
     */
    private final void updateInlineValues(BackedNotebookVirtualFile notebookFile) {
        Object object;
        block7: {
            Object value$iv;
            block4: {
                XStandaloneVariablesView xStandaloneVariablesView;
                void $this$getOrPut$iv;
                BackedNotebookVirtualFile key$iv;
                block6: {
                    block5: {
                        XStandaloneVariablesView xStandaloneVariablesView2;
                        Pair<PyStackFrame, JupyterVarsFrameAccessor> pair = this.getStackFrameAndAccessor(notebookFile);
                        if (pair == null) {
                            return;
                        }
                        PyStackFrame stackFrame = (PyStackFrame)pair.component1();
                        Map<BackedNotebookVirtualFile, XStandaloneVariablesView> map = this.variablesViews;
                        key$iv = notebookFile;
                        boolean $i$f$getOrPut = false;
                        value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv != null) break block4;
                        boolean bl = false;
                        xStandaloneVariablesView = this.createVariablesView(notebookFile, stackFrame);
                        if (xStandaloneVariablesView == null) break block5;
                        XStandaloneVariablesView it = xStandaloneVariablesView2 = xStandaloneVariablesView;
                        boolean bl2 = false;
                        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)it));
                        xStandaloneVariablesView = xStandaloneVariablesView2;
                        if (xStandaloneVariablesView != null) break block6;
                    }
                    return;
                }
                XStandaloneVariablesView answer$iv = xStandaloneVariablesView;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
                break block7;
            }
            object = value$iv;
        }
        XStandaloneVariablesView view = (XStandaloneVariablesView)object;
        this.updateVariablesView(notebookFile, view);
        this.createAndCallInlineCallback(notebookFile);
    }

    private static final void notebookSessionEnvironmentUpdated$lambda$2(VirtualFile $virtualFile, JupyterVariablesService this$0) {
        BackedNotebookVirtualFile notebookFile = BackedNotebookVirtualFile.Companion.takeBackend($virtualFile);
        boolean bl = false;
        JupyterNotebook jupyterNotebook = notebookFile.getNotebookOrNull();
        if (!Intrinsics.areEqual((Object)(jupyterNotebook != null ? jupyterNotebook.getLanguage() : null), (Object)JupyterPyDialect.INSTANCE)) {
            return;
        }
        this$0.updateInlineValues(notebookFile);
    }

    private static final ScopeOwner clearInlineValues$lambda$3(JupyterVariablesService this$0, BackedNotebookVirtualFile $notebookFile) {
        PsiFile psiFile2 = PythonVariablesUtil.INSTANCE.getPythonJupyterPsiFile(this$0.project, $notebookFile.getOriginFile());
        return psiFile2 instanceof ScopeOwner ? (ScopeOwner)psiFile2 : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/py/variables/JupyterVariablesService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/py/variables/JupyterVariablesService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.jupyter.py"})
    @SourceDebugExtension(value={"SMAP\nJupyterVariablesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterVariablesService.kt\ncom/intellij/jupyter/py/variables/JupyterVariablesService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,116:1\n30#2,2:117\n*S KotlinDebug\n*F\n+ 1 JupyterVariablesService.kt\ncom/intellij/jupyter/py/variables/JupyterVariablesService$Companion\n*L\n114#1:117,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterVariablesService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<JupyterVariablesService> serviceClass$iv = JupyterVariablesService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JupyterVariablesService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

