/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.remote.remover.query;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.impl.query.RemoteQuery;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.jboss.logging.Logger;
import org.keycloak.models.sessions.infinispan.changes.remote.remover.ConditionalRemover;

abstract class QueryBasedConditionalRemover<K, V>
implements ConditionalRemover<K, V> {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private static final String QUERY_FMT = "DELETE FROM %s WHERE %s";

    QueryBasedConditionalRemover() {
    }

    @Override
    public void executeRemovals(RemoteCache<K, V> cache, AggregateCompletionStage<Void> stage) {
        if (this.isEmpty()) {
            return;
        }
        stage.dependsOn(this.executeDeleteStatement(cache));
    }

    private CompletionStage<?> executeDeleteStatement(RemoteCache<K, V> cache) {
        boolean isTrace = logger.isTraceEnabled();
        String deleteStatement = QUERY_FMT.formatted(this.getEntity(), this.getQueryConditions());
        if (isTrace) {
            logger.tracef("About to execute delete statement in cache '%s': %s", (Object)cache.getName(), (Object)deleteStatement);
        }
        RemoteQuery query = (RemoteQuery)cache.query(deleteStatement).setParameters(this.getQueryParameters());
        CompletionStage stage = query.executeStatementAsync();
        if (isTrace) {
            return stage.thenAccept(removed -> logger.debugf("Delete Statement removed %d entries from cache '%s'", removed, (Object)cache.getName()));
        }
        return stage;
    }

    abstract String getEntity();

    abstract String getQueryConditions();

    abstract Map<String, Object> getQueryParameters();

    abstract boolean isEmpty();
}

