/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.pkg.steps.ReportAnalyzer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ErrorReplacingProcessReader {
    private static final String LINE_START = "Call path from entry point to ";
    private final BufferedReader reader;
    private final File reportdir;
    private ReportAnalyzer reportAnalyzer;

    public ErrorReplacingProcessReader(BufferedReader reader, File reportdir) {
        this.reader = reader;
        this.reportdir = reportdir;
    }

    public void run() throws IOException {
        Object files;
        ArrayDeque<String> fullBuffer = new ArrayDeque<String>();
        boolean buffering = false;
        String line = this.reader.readLine();
        while (line != null) {
            if (line.startsWith(LINE_START)) {
                buffering = true;
            }
            if (buffering) {
                fullBuffer.add(line);
            } else {
                System.err.println(line);
            }
            line = this.reader.readLine();
        }
        Object reportFile = null;
        if (this.reportdir.exists() && (files = this.reportdir.listFiles()) != null) {
            for (Object j : files) {
                if (!((File)j).getName().startsWith("call_tree")) continue;
                reportFile = j;
                break;
            }
        }
        if (reportFile == null) {
            for (String j : fullBuffer) {
                System.err.println(j);
            }
        } else {
            while (!fullBuffer.isEmpty()) {
                String line2 = (String)fullBuffer.pop();
                if (line2.startsWith(LINE_START)) {
                    this.handleErrorState((File)reportFile, line2, (Deque<String>)fullBuffer);
                    continue;
                }
                System.err.println(line2);
            }
        }
    }

    private void handleErrorState(File report, String firstLine, Deque<String> queue) {
        System.err.println(firstLine);
        String remainder = firstLine.substring(LINE_START.length());
        Matcher m = Pattern.compile("([^(]*).*").matcher(remainder);
        if (!m.find()) {
            return;
        }
        String line = "";
        while (!queue.isEmpty() && (line = queue.pop()).trim().startsWith("at")) {
            System.err.println(line);
        }
        System.err.println("--------------------------------------------------------------------------------------------");
        System.err.println("-- WARNING: The above stack trace is not a real stack trace, it is a theoretical call tree---");
        System.err.println("-- If an interface has multiple implementations SVM will just display one potential call  ---");
        System.err.println("-- path to the interface. This is often meaningless, and what you actually need to know is---");
        System.err.println("-- the path to the constructor of the object that implements this interface.              ---");
        System.err.println("-- Quarkus has attempted to generate a more meaningful call flow analysis below          ---");
        System.err.println("---------------------------------------------------------------------------------------------\n");
        try {
            String fullName = m.group(1);
            int index = fullName.lastIndexOf(46);
            String clazz = fullName.substring(0, index);
            String method = fullName.substring(index + 1);
            if (this.reportAnalyzer == null) {
                this.reportAnalyzer = new ReportAnalyzer(report.getAbsolutePath());
            }
            System.err.println(this.reportAnalyzer.analyse(clazz, method));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.err.println(line);
    }
}

