/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.groups.MultiItemCombineIterable;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.tuples.Tuple2;
import java.util.concurrent.Flow;
import java.util.function.BiFunction;

public class MultiItemCombine2<T1, T2>
extends MultiItemCombineIterable {
    public MultiItemCombine2(Iterable<Flow.Publisher<?>> iterable) {
        super(iterable);
    }

    @Override
    public MultiItemCombine2<T1, T2> collectFailures() {
        super.collectFailures();
        return this;
    }

    @Override
    @CheckReturnValue
    public MultiItemCombine2<T1, T2> latestItems() {
        super.latestItems();
        return this;
    }

    @CheckReturnValue
    public Multi<Tuple2<T1, T2>> asTuple() {
        return this.using(Tuple2::of);
    }

    @CheckReturnValue
    public <O> Multi<O> using(BiFunction<T1, T2, O> combinator) {
        ParameterValidation.nonNull(combinator, "combinator");
        return super.combine(args -> {
            ParameterValidation.size(args, 2, "args");
            return combinator.apply(args.get(0), args.get(1));
        });
    }
}

