/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import java.util.Optional;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.jboss.jandex.AnnotationInstance;

public class OpenAPIDefinitionIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<OpenAPI, V, A, O, AB, OB> {
    public static final String PROP_COMPONENTS = "components";
    public static final String PROP_EXTERNAL_DOCS = "externalDocs";
    public static final String PROP_INFO = "info";
    public static final String PROP_OPENAPI = "openapi";
    public static final String PROP_PATHS = "paths";
    public static final String PROP_SECURITY = "security";
    public static final String PROP_SECURITY_SETS = "securitySets";
    public static final String PROP_SERVERS = "servers";
    public static final String PROP_TAGS = "tags";
    public static final String PROP_WEBHOOKS = "webhooks";

    public OpenAPIDefinitionIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.OPENAPI_DEFINITION, Names.create(OpenAPI.class));
    }

    @Override
    public OpenAPI read(AnnotationInstance annotation) {
        IoLogging.logger.annotation("@OpenAPIDefinition");
        OpenAPI openApi = OASFactory.createOpenAPI();
        openApi.setOpenapi("3.1.0");
        openApi.setInfo((Info)this.infoIO().read(annotation.value(PROP_INFO)));
        openApi.setTags(this.tagIO().readList(annotation.value(PROP_TAGS)));
        openApi.setServers(this.serverIO().readList(annotation.value(PROP_SERVERS)));
        openApi.setSecurity(this.securityIO().readRequirements(annotation.value(PROP_SECURITY), annotation.value(PROP_SECURITY_SETS)));
        openApi.setExternalDocs((ExternalDocumentation)this.extDocIO().read(annotation.value(PROP_EXTERNAL_DOCS)));
        openApi.setWebhooks(this.pathItemIO().readMap(annotation.value(PROP_WEBHOOKS)));
        openApi.setComponents((Components)this.componentsIO().read(annotation.value(PROP_COMPONENTS)));
        openApi.setExtensions(this.extensionIO().readExtensible(annotation));
        return openApi;
    }

    @Override
    public OpenAPI readObject(O node) {
        String version = this.jsonIO().getString(node, PROP_OPENAPI);
        this.setOpenApiVersion(OpenApiVersion.fromString((String)version));
        return this.readObject(OpenAPI.class, node);
    }

    @Override
    public Optional<O> write(OpenAPI model) {
        String version = model.getOpenapi();
        this.setOpenApiVersion(OpenApiVersion.fromString((String)version));
        return this.jsonIO().toJson(model, this);
    }
}

