/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader;

import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.DefaultResourceManagerBackend;
import org.pentaho.reporting.libraries.resourceloader.LibLoaderBoot;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleData;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManagerBackend;
import org.pentaho.reporting.libraries.resourceloader.UnrecognizedLoaderException;
import org.pentaho.reporting.libraries.resourceloader.cache.BundleCacheResourceWrapper;
import org.pentaho.reporting.libraries.resourceloader.cache.NullResourceBundleDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.NullResourceDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.NullResourceFactoryCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCacheEntry;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCacheProvider;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCacheEntry;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCacheProvider;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceFactoryCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceFactoryCacheProvider;
import org.pentaho.reporting.libraries.resourceloader.modules.cache.ehcache.EHCacheModule;

public final class ResourceManager {
    private static final Logger logger = Logger.getLogger(ResourceManager.class.getName());
    private ResourceManagerBackend backend;
    public static final String BUNDLE_LOADER_PREFIX = "org.pentaho.reporting.libraries.resourceloader.bundle.loader.";
    public static final String LOADER_PREFIX = "org.pentaho.reporting.libraries.resourceloader.loader.";
    public static final String FACTORY_TYPE_PREFIX = "org.pentaho.reporting.libraries.resourceloader.factory.type.";
    public static final String BUNDLE_CACHE_PROVIDER_KEY = "org.pentaho.reporting.libraries.resourceloader.cache.BundleDataCacheProvider";
    public static final String DATA_CACHE_PROVIDER_KEY = "org.pentaho.reporting.libraries.resourceloader.cache.DataCacheProvider";
    public static final String FACTORY_CACHE_PROVIDER_KEY = "org.pentaho.reporting.libraries.resourceloader.cache.FactoryCacheProvider";
    private ResourceDataCache dataCache;
    private ResourceBundleDataCache bundleCache;
    private ResourceFactoryCache factoryCache;
    private static final Set failedModules = new HashSet();

    public ResourceManager() {
        this(new DefaultResourceManagerBackend());
    }

    public ResourceManager(ResourceManagerBackend resourceManagerBackend) {
        if (resourceManagerBackend == null) {
            throw new NullPointerException();
        }
        this.backend = resourceManagerBackend;
        this.bundleCache = new NullResourceBundleDataCache();
        this.dataCache = new NullResourceDataCache();
        this.factoryCache = new NullResourceFactoryCache();
    }

    public ResourceManager(ResourceManager parent, ResourceManagerBackend backend) {
        if (backend == null) {
            throw new NullPointerException();
        }
        if (parent == null) {
            throw new NullPointerException();
        }
        this.backend = backend;
        this.bundleCache = parent.getBundleCache();
        this.dataCache = parent.getDataCache();
        this.factoryCache = parent.getFactoryCache();
    }

    public ResourceManagerBackend getBackend() {
        return this.backend;
    }

    public ResourceKey createKey(Object data) throws ResourceKeyCreationException {
        return this.createKey(data, null);
    }

    public ResourceKey createKey(Object data, Map parameters) throws ResourceKeyCreationException {
        return this.backend.createKey(data, parameters);
    }

    public ResourceKey deriveKey(ResourceKey parent, String path) throws ResourceKeyCreationException {
        return this.deriveKey(parent, path, null);
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map parameters) throws ResourceKeyCreationException {
        return this.backend.deriveKey(parent, path, parameters);
    }

    public URL toURL(ResourceKey key) {
        return this.backend.toURL(key);
    }

    public Resource createDirectly(Object keyValue, Class target) throws ResourceLoadingException, ResourceCreationException, ResourceKeyCreationException {
        ResourceKey key = this.createKey(keyValue);
        return this.create(key, null, target);
    }

    public synchronized ResourceBundleData loadResourceBundle(ResourceKey key) throws ResourceLoadingException {
        ResourceBundleData data;
        ResourceBundleDataCache bundleCache = this.getBundleCache();
        ResourceBundleDataCacheEntry cached = bundleCache.get(key);
        if (cached != null) {
            ResourceData bundleRawData;
            ResourceDataCacheEntry bundleRawDataCacheEntry;
            data = cached.getData();
            long version = data.getVersion(this);
            if ((cached.getStoredVersion() < 0L || version >= 0L && cached.getStoredVersion() == version) && (bundleRawDataCacheEntry = this.getDataCache().get(data.getBundleKey())) != null && (bundleRawData = bundleRawDataCacheEntry.getData()) != null) {
                if (this.isValidData(bundleRawDataCacheEntry, bundleRawData)) {
                    return data;
                }
                this.getDataCache().remove(bundleRawData);
            }
            bundleCache.remove(data);
        }
        if ((data = this.backend.loadResourceBundle(this, key)) != null && this.isResourceDataCacheable(data)) {
            bundleCache.put(this, data);
        }
        return data;
    }

    private boolean isResourceDataCacheable(ResourceData data) {
        try {
            return data.getVersion(this) != -1L;
        }
        catch (ResourceLoadingException e) {
            return false;
        }
    }

    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        ResourceBundleData parentData;
        ResourceBundleData bundle = this.loadResourceBundle(key);
        if (bundle != null) {
            logger.config("Loaded bundle for key " + key);
            return bundle;
        }
        ResourceKey parent = key.getParent();
        if (parent != null && (parentData = this.loadResourceBundle(parent)) != null) {
            logger.config("Loaded bundle for key (derivate) " + key);
            return parentData.deriveData(key);
        }
        return this.loadRawData(key);
    }

    private boolean isValidData(ResourceDataCacheEntry cached, ResourceData data) throws ResourceLoadingException {
        if (cached.getStoredVersion() < 0L) {
            return true;
        }
        long version = data.getVersion(this);
        if (version < 0L) {
            return false;
        }
        return cached.getStoredVersion() == version;
    }

    public synchronized ResourceData loadRawData(ResourceKey key) throws UnrecognizedLoaderException, ResourceLoadingException {
        ResourceData data;
        ResourceDataCache dataCache = this.getDataCache();
        ResourceDataCacheEntry cached = dataCache.get(key);
        if (cached != null && (data = cached.getData()) != null) {
            if (this.isValidData(cached, data)) {
                return data;
            }
            dataCache.remove(data);
        }
        if ((data = this.backend.loadRawData(this, key)) != null && this.isResourceDataCacheable(data)) {
            dataCache.put(this, data);
        }
        return data;
    }

    public Resource create(ResourceKey key, ResourceKey context, Class target) throws ResourceLoadingException, ResourceCreationException {
        if (target == null) {
            throw new NullPointerException("Target must not be null");
        }
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        return this.create(key, context, new Class[]{target});
    }

    public Resource create(ResourceKey key, ResourceKey context) throws ResourceLoadingException, ResourceCreationException {
        return this.create(key, context, (Class[])null);
    }

    public Resource create(ResourceKey key, ResourceKey context, Class[] target) throws ResourceLoadingException, ResourceCreationException {
        Resource newResource;
        ResourceData loadedData;
        if (key == null) {
            throw new NullPointerException();
        }
        ResourceFactoryCache factoryCache = this.getFactoryCache();
        Resource resource = factoryCache.get(key, target);
        if (resource != null) {
            if (this.backend.isResourceUnchanged(this, resource)) {
                return resource;
            }
            factoryCache.remove(resource);
        }
        if ((loadedData = this.load(key)) instanceof ResourceBundleData) {
            ResourceBundleData resourceBundleData = (ResourceBundleData)loadedData;
            ResourceManager derivedManager = resourceBundleData.deriveManager(this);
            newResource = this.backend.create(derivedManager, resourceBundleData, context, target);
            if (this.isResourceCacheable(newResource)) {
                if (EHCacheModule.CACHE_MONITOR.isLoggable(Level.CONFIG)) {
                    EHCacheModule.CACHE_MONITOR.config("Storing created bundle-resource for key: " + key);
                }
                factoryCache.put(newResource);
                if (key != newResource.getSource()) {
                    factoryCache.put(new BundleCacheResourceWrapper(newResource, key));
                }
            } else if (EHCacheModule.CACHE_MONITOR.isLoggable(Level.CONFIG)) {
                EHCacheModule.CACHE_MONITOR.config("Created bundle-resource is not cacheable for " + key);
            }
        } else {
            newResource = this.backend.create(this, loadedData, context, target);
            if (this.isResourceCacheable(newResource)) {
                if (EHCacheModule.CACHE_MONITOR.isLoggable(Level.CONFIG)) {
                    EHCacheModule.CACHE_MONITOR.config("Storing created resource for key: " + key);
                }
                factoryCache.put(newResource);
            } else if (EHCacheModule.CACHE_MONITOR.isLoggable(Level.CONFIG)) {
                EHCacheModule.CACHE_MONITOR.config("Created resource is not cacheable for " + key);
            }
        }
        return newResource;
    }

    private boolean isResourceCacheable(Resource newResource) {
        ResourceKey source = newResource.getSource();
        if (newResource.isTemporaryResult()) {
            return false;
        }
        if (newResource.getVersion(source) == -1L) {
            return false;
        }
        ResourceKey[] keys = newResource.getDependencies();
        for (int i = 0; i < keys.length; ++i) {
            if (newResource.getVersion(keys[i]) != -1L) continue;
            return false;
        }
        return true;
    }

    public ResourceDataCache getDataCache() {
        return this.dataCache;
    }

    public void setDataCache(ResourceDataCache dataCache) {
        if (dataCache == null) {
            throw new NullPointerException();
        }
        this.dataCache = dataCache;
    }

    public ResourceFactoryCache getFactoryCache() {
        return this.factoryCache;
    }

    public void setFactoryCache(ResourceFactoryCache factoryCache) {
        if (factoryCache == null) {
            throw new NullPointerException();
        }
        this.factoryCache = factoryCache;
    }

    public ResourceBundleDataCache getBundleCache() {
        return this.bundleCache;
    }

    public void setBundleCache(ResourceBundleDataCache bundleCache) {
        if (bundleCache == null) {
            throw new NullPointerException();
        }
        this.bundleCache = bundleCache;
    }

    public void registerDefaults() {
        this.registerDefaultLoaders();
        this.registerDefaultFactories();
        this.registerDataCache();
        this.registerBundleDataCache();
        this.registerFactoryCache();
    }

    public void registerDefaultFactories() {
        this.backend.registerDefaultFactories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBundleDataCache() {
        Configuration config = LibLoaderBoot.getInstance().getGlobalConfig();
        String dataCacheProviderClass = config.getConfigProperty(BUNDLE_CACHE_PROVIDER_KEY);
        if (dataCacheProviderClass == null) {
            return;
        }
        Object maybeDataCacheProvider = ObjectUtilities.loadAndInstantiate((String)dataCacheProviderClass, ResourceManager.class, ResourceBundleDataCacheProvider.class);
        if (maybeDataCacheProvider == null) {
            return;
        }
        ResourceBundleDataCacheProvider provider = (ResourceBundleDataCacheProvider)maybeDataCacheProvider;
        try {
            ResourceBundleDataCache cache = provider.createBundleDataCache();
            if (cache != null) {
                this.setBundleCache(cache);
            }
        }
        catch (Throwable e) {
            Set set = failedModules;
            synchronized (set) {
                if (!failedModules.contains(dataCacheProviderClass)) {
                    logger.warning("Failed to create data cache: " + e.getLocalizedMessage());
                    failedModules.add(dataCacheProviderClass);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDataCache() {
        Configuration config = LibLoaderBoot.getInstance().getGlobalConfig();
        String dataCacheProviderClass = config.getConfigProperty(DATA_CACHE_PROVIDER_KEY);
        if (dataCacheProviderClass == null) {
            return;
        }
        Object maybeDataCacheProvider = ObjectUtilities.loadAndInstantiate((String)dataCacheProviderClass, ResourceManager.class, ResourceDataCacheProvider.class);
        if (maybeDataCacheProvider instanceof ResourceDataCacheProvider) {
            ResourceDataCacheProvider provider = (ResourceDataCacheProvider)maybeDataCacheProvider;
            try {
                ResourceDataCache cache = provider.createDataCache();
                if (cache != null) {
                    this.setDataCache(cache);
                }
            }
            catch (Throwable e) {
                Set set = failedModules;
                synchronized (set) {
                    if (!failedModules.contains(dataCacheProviderClass)) {
                        logger.warning("Failed to create data cache: " + e.getLocalizedMessage());
                        failedModules.add(dataCacheProviderClass);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFactoryCache() {
        Configuration config = LibLoaderBoot.getInstance().getGlobalConfig();
        String cacheProviderClass = config.getConfigProperty(FACTORY_CACHE_PROVIDER_KEY);
        if (cacheProviderClass == null) {
            return;
        }
        Object maybeCacheProvider = ObjectUtilities.loadAndInstantiate((String)cacheProviderClass, ResourceManager.class, ResourceFactoryCacheProvider.class);
        if (maybeCacheProvider != null) {
            ResourceFactoryCacheProvider provider = (ResourceFactoryCacheProvider)maybeCacheProvider;
            try {
                ResourceFactoryCache cache = provider.createFactoryCache();
                if (cache != null) {
                    this.setFactoryCache(cache);
                }
            }
            catch (Throwable e) {
                Set set = failedModules;
                synchronized (set) {
                    if (!failedModules.contains(cacheProviderClass)) {
                        logger.warning("Failed to create factory cache: " + e.getLocalizedMessage());
                        failedModules.add(cacheProviderClass);
                    }
                }
            }
        }
    }

    public void registerDefaultLoaders() {
        this.backend.registerDefaultLoaders();
    }

    public void registerBundleLoader(ResourceBundleLoader loader) {
        if (loader == null) {
            throw new NullPointerException();
        }
        this.backend.registerBundleLoader(loader);
    }

    public void registerLoader(ResourceLoader loader) {
        if (loader == null) {
            throw new NullPointerException();
        }
        this.backend.registerLoader(loader);
    }

    public void registerFactory(ResourceFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        this.backend.registerFactory(factory);
    }

    public void shutDown() {
        this.factoryCache.shutdown();
        this.dataCache.shutdown();
    }

    public String serialize(ResourceKey bundleKey, ResourceKey key) throws ResourceException {
        return this.backend.serialize(bundleKey, key);
    }

    public ResourceKey deserialize(ResourceKey bundleKey, String serializedKey) throws ResourceKeyCreationException {
        return this.backend.deserialize(bundleKey, serializedKey);
    }
}

