/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Block;
import com.mongodb.FindIterableImpl;
import com.mongodb.Function;
import com.mongodb.MappingIterable;
import com.mongodb.MongoNamespace;
import com.mongodb.OperationIterable;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.FindOptions;
import com.mongodb.operation.AggregateOperation;
import com.mongodb.operation.AggregateToCollectionOperation;
import com.mongodb.operation.OperationExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class AggregateIterableImpl<TDocument, TResult>
implements AggregateIterable<TResult> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final Class<TResult> resultClass;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    private final WriteConcern writeConcern;
    private final CodecRegistry codecRegistry;
    private final OperationExecutor executor;
    private final List<? extends Bson> pipeline;
    private Boolean allowDiskUse;
    private Integer batchSize;
    private long maxTimeMS;
    private Boolean useCursor;
    private Boolean bypassDocumentValidation;
    private Collation collation;

    AggregateIterableImpl(MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, OperationExecutor executor, List<? extends Bson> pipeline) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.documentClass = Assertions.notNull("documentClass", documentClass);
        this.resultClass = Assertions.notNull("resultClass", resultClass);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.executor = Assertions.notNull("executor", executor);
        this.pipeline = Assertions.notNull("pipeline", pipeline);
    }

    @Override
    public void toCollection() {
        List<BsonDocument> aggregateList = this.createBsonDocumentList(this.pipeline);
        if (this.getOutCollection(aggregateList) == null) {
            throw new IllegalStateException("The last stage of the aggregation pipeline must be $out");
        }
        this.executor.execute(this.createAggregateToCollectionOperation(aggregateList));
    }

    @Override
    public AggregateIterable<TResult> allowDiskUse(Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Override
    public AggregateIterable<TResult> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public AggregateIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public AggregateIterable<TResult> useCursor(Boolean useCursor) {
        this.useCursor = useCursor;
        return this;
    }

    @Override
    public AggregateIterable<TResult> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public AggregateIterable<TResult> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public MongoCursor<TResult> iterator() {
        return this.execute().iterator();
    }

    @Override
    public TResult first() {
        return this.execute().first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return new MappingIterable<TResult, U>(this, mapper);
    }

    @Override
    public void forEach(Block<? super TResult> block) {
        this.execute().forEach(block);
    }

    @Override
    public <A extends Collection<? super TResult>> A into(A target) {
        return this.execute().into(target);
    }

    private MongoIterable<TResult> execute() {
        List<BsonDocument> aggregateList = this.createBsonDocumentList(this.pipeline);
        BsonValue outCollection = this.getOutCollection(aggregateList);
        if (outCollection != null) {
            this.executor.execute(this.createAggregateToCollectionOperation(aggregateList));
            FindIterableImpl<TDocument, TResult> findOperation = new FindIterableImpl<TDocument, TResult>(new MongoNamespace(this.namespace.getDatabaseName(), outCollection.asString().getValue()), this.documentClass, this.resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.executor, new BsonDocument(), new FindOptions().collation(this.collation));
            if (this.batchSize != null) {
                findOperation.batchSize(this.batchSize);
            }
            return findOperation;
        }
        return new OperationIterable(new AggregateOperation<TResult>(this.namespace, aggregateList, this.codecRegistry.get(this.resultClass)).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).allowDiskUse(this.allowDiskUse).batchSize(this.batchSize).useCursor(this.useCursor).readConcern(this.readConcern).collation(this.collation), this.readPreference, this.executor);
    }

    private BsonValue getOutCollection(List<BsonDocument> aggregateList) {
        return aggregateList.size() == 0 ? null : aggregateList.get(aggregateList.size() - 1).get("$out");
    }

    private AggregateToCollectionOperation createAggregateToCollectionOperation(List<BsonDocument> aggregateList) {
        return new AggregateToCollectionOperation(this.namespace, aggregateList, this.writeConcern).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).allowDiskUse(this.allowDiskUse).bypassDocumentValidation(this.bypassDocumentValidation).collation(this.collation);
    }

    private List<BsonDocument> createBsonDocumentList(List<? extends Bson> pipeline) {
        ArrayList<BsonDocument> aggregateList = new ArrayList<BsonDocument>(pipeline.size());
        for (Bson bson : pipeline) {
            if (bson == null) {
                throw new IllegalArgumentException("pipeline can not contain a null value");
            }
            aggregateList.add(bson.toBsonDocument(this.documentClass, this.codecRegistry));
        }
        return aggregateList;
    }
}

