/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * matrixCompMult(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf), dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf)) => dmat2x4(0.0256lf, 0.6400000000000001lf, 3.0276lf, 0.0004lf, 2.8560999999999996lf, 0.34809999999999997lf, 2.0448999999999997lf, 1.4641lf)
 * matrixCompMult(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf), dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf)) => dmat2x4(-0.1632lf, 1.312lf, 2.7666lf, -0.006lf, -1.2506lf, -0.0767lf, -0.6720999999999999lf, -1.3672999999999997lf)
 * matrixCompMult(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf), dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf)) => dmat2x4(-0.1632lf, 1.312lf, 2.7666lf, -0.006lf, -1.2506lf, -0.0767lf, -0.6720999999999999lf, -1.3672999999999997lf)
 * matrixCompMult(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf), dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf)) => dmat2x4(1.0404lf, 2.6895999999999995lf, 2.5281000000000002lf, 0.09lf, 0.5476lf, 0.016900000000000002lf, 0.22089999999999999lf, 1.2768999999999997lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[(distance(matrixCompMult(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf), dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf))[0], dvec4(0.0256lf, 0.6400000000000001lf, 3.0276lf, 0.0004lf)) * distance(matrixCompMult(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf), dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf))[0], dvec4(0.0256lf, 0.6400000000000001lf, 3.0276lf, 0.0004lf))) + (distance(matrixCompMult(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf), dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf))[1], dvec4(2.8560999999999996lf, 0.34809999999999997lf, 2.0448999999999997lf, 1.4641lf)) * distance(matrixCompMult(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf), dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf))[1], dvec4(2.8560999999999996lf, 0.34809999999999997lf, 2.0448999999999997lf, 1.4641lf))) <= 2.4180302919999995e-09lf ? 1 : -1] array0;
  double[(distance(matrixCompMult(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf), dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf))[0], dvec4(-0.1632lf, 1.312lf, 2.7666lf, -0.006lf)) * distance(matrixCompMult(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf), dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf))[0], dvec4(-0.1632lf, 1.312lf, 2.7666lf, -0.006lf))) + (distance(matrixCompMult(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf), dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf))[1], dvec4(-1.2506lf, -0.0767lf, -0.6720999999999999lf, -1.3672999999999997lf)) * distance(matrixCompMult(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf), dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf))[1], dvec4(-1.2506lf, -0.0767lf, -0.6720999999999999lf, -1.3672999999999997lf))) <= 1.329320075e-09lf ? 1 : -1] array1;
  double[(distance(matrixCompMult(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf), dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf))[0], dvec4(-0.1632lf, 1.312lf, 2.7666lf, -0.006lf)) * distance(matrixCompMult(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf), dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf))[0], dvec4(-0.1632lf, 1.312lf, 2.7666lf, -0.006lf))) + (distance(matrixCompMult(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf), dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf))[1], dvec4(-1.2506lf, -0.0767lf, -0.6720999999999999lf, -1.3672999999999997lf)) * distance(matrixCompMult(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf), dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf))[1], dvec4(-1.2506lf, -0.0767lf, -0.6720999999999999lf, -1.3672999999999997lf))) <= 1.329320075e-09lf ? 1 : -1] array2;
  double[(distance(matrixCompMult(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf), dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf))[0], dvec4(1.0404lf, 2.6895999999999995lf, 2.5281000000000002lf, 0.09lf)) * distance(matrixCompMult(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf), dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf))[0], dvec4(1.0404lf, 2.6895999999999995lf, 2.5281000000000002lf, 0.09lf))) + (distance(matrixCompMult(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf), dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf))[1], dvec4(0.5476lf, 0.016900000000000002lf, 0.22089999999999999lf, 1.2768999999999997lf)) * distance(matrixCompMult(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf), dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf))[1], dvec4(0.5476lf, 0.016900000000000002lf, 0.22089999999999999lf, 1.2768999999999997lf))) <= 1.6695191720000006e-09lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
