/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * asinh(vec4(0.0, 1e-10, -1e-10, 0.1)) => vec4(0.0, 1e-10, -1e-10, 0.09983408)
 * asinh(vec4(-0.1, 1.0, -1.0, 10.0)) => vec4(-0.09983408, 0.8813736, -0.8813736, 2.998223)
 * asinh(vec4(-10.0, 10000000000.0, -10000000000.0, 0.0)) => vec4(-2.998223, 23.718998, -23.718998, 0.0)
 */
#version 150

void main()
{
  float[distance(asinh(vec4(0.0, 1e-10, -1e-10, 0.1)), vec4(0.0, 1e-10, -1e-10, 0.09983408)) <= 0.0002 ? 1 : -1] array0;
  float[distance(asinh(vec4(-0.1, 1.0, -1.0, 10.0)), vec4(-0.09983408, 0.8813736, -0.8813736, 2.998223)) <= 0.003248535 ? 1 : -1] array1;
  float[distance(asinh(vec4(-10.0, 10000000000.0, -10000000000.0, 0.0)), vec4(-2.998223, 23.718998, -23.718998, 0.0)) <= 0.033677604 ? 1 : -1] array2;
  gl_Position = vec4(array0.length() + array1.length() + array2.length());
}
