/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * exp2(-2.0) => 0.25
 * exp2(-0.6666667) => 0.62996054
 * exp2(0.6666667) => 1.587401
 * exp2(2.0) => 4.0
 */
#version 150

void main()
{
  float[distance(exp2(-2.0), 0.25) <= 2.5e-06 ? 1 : -1] array0;
  float[distance(exp2(-0.6666667), 0.62996054) <= 6.299605e-06 ? 1 : -1] array1;
  float[distance(exp2(0.6666667), 1.587401) <= 1.5874011e-05 ? 1 : -1] array2;
  float[distance(exp2(2.0), 4.0) <= 4e-05 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
