/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.graalvm.visualvm.profiling.presets.ProfilingOptionsSectionProvider;
import org.graalvm.visualvm.sampler.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public final class SamplerInitialization
extends ProfilingOptionsSectionProvider {
    public static final String PROP_INITIALIZE_AUTOMATICALLY = "SamplerInitialization.initializeAutomatically";
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport((Object)this);
    private final Preferences prefs = NbPreferences.forModule(SamplerInitialization.class);
    private JCheckBox initializeAutomatically;
    private Runnable changedToAutomatic;

    public static SamplerInitialization getInstance() {
        return (SamplerInitialization)((Object)Lookup.getDefault().lookup(SamplerInitialization.class));
    }

    public String getSectionName() {
        return Bundle.CAP_SectionName();
    }

    public Component getSection() {
        this.initializeAutomatically = new JCheckBox(null, null, this.isAutomatic());
        Mnemonics.setLocalizedText((AbstractButton)this.initializeAutomatically, (String)Bundle.BTN_InitializeAutomatically());
        this.initializeAutomatically.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SamplerInitialization.this.changed();
            }
        });
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)this.initializeAutomatically, "West");
        return container;
    }

    protected void load() {
        this.initializeAutomatically.setSelected(this.isAutomatic());
    }

    protected void store() {
        if (this.initializeAutomatically != null) {
            this.setAutomatic(this.initializeAutomatically.isSelected());
        }
    }

    protected void closed() {
        this.changedToAutomatic = null;
    }

    boolean isAutomatic() {
        return this.prefs.getBoolean(PROP_INITIALIZE_AUTOMATICALLY, true);
    }

    private void setAutomatic(boolean automatic) {
        boolean orig = this.isAutomatic();
        if (orig != automatic) {
            this.prefs.putBoolean(PROP_INITIALIZE_AUTOMATICALLY, automatic);
            this.changeSupport.firePropertyChange(PROP_INITIALIZE_AUTOMATICALLY, orig, automatic);
            if (automatic && this.changedToAutomatic != null) {
                this.changedToAutomatic.run();
            }
        }
    }

    void runIfChangedToAutomatic(Runnable changedToAutomatic) {
        this.changedToAutomatic = changedToAutomatic;
    }

    public void addChangeListener(String property, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(property, listener);
    }

    public void removeChangeListener(String property, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(property, listener);
    }
}

