/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.compatibility;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.pentaho.di.compatibility.ValueInterface;
import org.pentaho.di.core.Const;

public class ValueString
implements ValueInterface,
Cloneable {
    private String string;
    private int length;
    private static final ThreadLocal<SimpleDateFormat> LOCAL_SIMPLE_DATE_PARSER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        }
    };

    public ValueString() {
        this.string = null;
        this.length = -1;
    }

    public ValueString(String string) {
        this.string = string;
        this.length = -1;
    }

    public int getType() {
        return 2;
    }

    public String getTypeDesc() {
        return "String";
    }

    public String getString() {
        return this.string;
    }

    public double getNumber() {
        return Const.toDouble(this.string, 0.0);
    }

    public Date getDate() {
        if (this.string != null) {
            try {
                return LOCAL_SIMPLE_DATE_PARSER.get().parse(this.string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean getBoolean() {
        return "Y".equalsIgnoreCase(this.string) || "TRUE".equalsIgnoreCase(this.string) || "YES".equalsIgnoreCase(this.string) || "1".equalsIgnoreCase(this.string);
    }

    public long getInteger() {
        return Const.toLong(Const.ltrim(this.string), 0L);
    }

    public void setString(String string) {
        this.string = string;
    }

    public void setNumber(double number) {
        this.string = "" + number;
    }

    public void setDate(Date date) {
        this.string = LOCAL_SIMPLE_DATE_PARSER.get().format(date);
    }

    public void setBoolean(boolean bool) {
        this.string = bool ? "Y" : "N";
    }

    public void setInteger(long number) {
        this.string = "" + number;
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return -1;
    }

    public void setLength(int length, int precision) {
        this.length = length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setPrecision(int precision) {
    }

    public Object clone() {
        try {
            ValueString retval = (ValueString)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public BigDecimal getBigNumber() {
        if (Const.isEmpty(this.string)) {
            return null;
        }
        if (Const.DEFAULT_DECIMAL_SEPARATOR != '.') {
            this.string = this.string.replace(Const.DEFAULT_DECIMAL_SEPARATOR, '.');
        }
        return new BigDecimal(this.string);
    }

    public void setBigNumber(BigDecimal number) {
        this.string = number.toString();
    }

    public Serializable getSerializable() {
        return this.string;
    }

    public void setSerializable(Serializable ser) {
        ser.toString();
    }

    public byte[] getBytes() {
        if (this.string == null) {
            return null;
        }
        char[] arr = this.string.toCharArray();
        byte[] retByte = new byte[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            retByte[i] = (byte)(arr[i] & 0xFF);
        }
        return retByte;
    }

    public void setBytes(byte[] b) {
        try {
            this.string = new String(b, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            this.string = null;
        }
    }
}

