/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.FetchBuffer;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;

final class ServerFetchBuffer
extends FetchBuffer {
    private static final int ROWSTAT_FETCH_SUCCEEDED = 1;
    private static final int ROWSTAT_FETCH_MISSING = 2;
    private static final int BEFORE_FIRST_ROW = -1;
    private static final int AFTER_LAST_ROW = -2;
    private static final int BETWEEN_BUFFERS = -3;
    private SQLServerStatement updateStatement;
    private SQLServerResultSet rs;
    private int fetchSize;
    private int currentBufferRow;
    private static final int ROW_READY = 0;
    private static final int ROW_DELETED = 1;
    private static final int ROW_STALE = 2;
    private int[] rowCondition;

    ServerFetchBuffer(SQLServerResultSet sQLServerResultSet) {
        this.rs = sQLServerResultSet;
        this.fetchSize = sQLServerResultSet.getFetchSizeInternal();
        this.currentBufferRow = -1;
        this.rowCondition = new int[this.fetchSize];
    }

    void close() throws SQLServerException {
        if (null != this.updateStatement) {
            this.updateStatement.close();
        }
    }

    final boolean isOnValidRow() {
        return -1 != this.currentBufferRow && -2 != this.currentBufferRow;
    }

    final void getterRefreshCurrentRow() throws SQLServerException {
        if (2 == this.rowCondition[this.currentBufferRow - 1]) {
            this.refresh();
        }
    }

    private void doServerFetch(int n, int n2, int n3) throws SQLServerException {
        if (128 != n && this.rs.getFetchSizeInternal() != this.fetchSize && n3 == this.fetchSize) {
            this.fetchSize = this.rs.getFetchSizeInternal();
            this.rowCondition = new int[this.fetchSize];
            n3 = this.fetchSize;
        }
        this.rs.stmt.doCursorFetch(n, n2, n3);
        for (int i = 0; i < this.fetchSize; ++i) {
            this.rowCondition[i] = 0;
        }
    }

    final void beforeFirst() throws SQLServerException {
        this.doServerFetch(1, 0, 0);
        this.currentBufferRow = -1;
    }

    final boolean first() throws SQLServerException {
        this.doServerFetch(1, 0, this.fetchSize);
        this.rs.stmt.fetchBufferBeforeFirst();
        if (this.rs.stmt.fetchBufferNext()) {
            this.currentBufferRow = 1;
        }
        return this.isOnValidRow();
    }

    final void afterLast() throws SQLServerException {
        this.doServerFetch(8, 0, 0);
        this.currentBufferRow = -2;
    }

    final boolean last() throws SQLServerException {
        this.doServerFetch(8, 0, this.fetchSize);
        this.rs.stmt.fetchBufferBeforeFirst();
        int n = 0;
        while (this.rs.stmt.fetchBufferNext()) {
            ++n;
        }
        this.rs.stmt.fetchBufferBeforeFirst();
        for (int i = 0; i < n; ++i) {
            this.rs.stmt.fetchBufferNext();
        }
        if (0 != n) {
            this.currentBufferRow = n;
        }
        return this.isOnValidRow();
    }

    final boolean forward(int n) throws SQLServerException {
        int n2 = 0;
        int n3 = this.currentBufferRow;
        if (-2 == this.currentBufferRow) {
            return false;
        }
        do {
            boolean bl;
            if (-3 == this.currentBufferRow || -1 == this.currentBufferRow) {
                int n4;
                if (1 == n - n2) {
                    this.doServerFetch(2, 0, this.fetchSize);
                    n4 = 1;
                } else {
                    this.doServerFetch(32, n3 + n - 1, this.fetchSize);
                    n4 = n - n2;
                }
                this.rs.stmt.fetchBufferBeforeFirst();
                boolean bl2 = bl = !this.rs.stmt.fetchBufferNext();
                if (!bl) {
                    this.currentBufferRow = 1;
                    n2 += n4;
                }
            } else {
                boolean bl3 = bl = !this.rs.stmt.fetchBufferNext();
                if (!bl) {
                    ++this.currentBufferRow;
                    ++n2;
                }
            }
            if (!bl) continue;
            if (-1 == this.currentBufferRow) {
                return false;
            }
            if (-3 == this.currentBufferRow) {
                this.currentBufferRow = -2;
                return false;
            }
            this.currentBufferRow = -3;
        } while (n2 < n);
        return true;
    }

    final boolean reverse(int n) throws SQLServerException {
        if (-1 == this.currentBufferRow) {
            return false;
        }
        int n2 = n + (-2 == this.currentBufferRow ? 1 : this.currentBufferRow);
        if (n2 < 0) {
            this.doServerFetch(32, n2 - 1, this.fetchSize);
            this.rs.stmt.fetchBufferBeforeFirst();
            if (this.rs.stmt.fetchBufferNext()) {
                this.currentBufferRow = 1;
            } else if (-2 != this.currentBufferRow) {
                this.currentBufferRow = -1;
            }
        } else if (n2 == 0) {
            this.doServerFetch(512, 0, this.fetchSize);
            this.rs.stmt.fetchBufferBeforeFirst();
            int n3 = 0;
            while (this.rs.stmt.fetchBufferNext()) {
                ++n3;
            }
            if (0 == n3) {
                if (-2 != this.currentBufferRow) {
                    this.currentBufferRow = -1;
                }
            } else {
                this.rs.stmt.fetchBufferBeforeFirst();
                for (int i = 0; i < n3; ++i) {
                    this.rs.stmt.fetchBufferNext();
                }
                this.currentBufferRow = n3;
            }
        } else {
            this.rs.stmt.fetchBufferBeforeFirst();
            for (int i = 0; i < n2; ++i) {
                this.rs.stmt.fetchBufferNext();
            }
            this.currentBufferRow = n2;
        }
        return this.isOnValidRow();
    }

    final boolean relative(int n) throws SQLServerException {
        if (n > 0) {
            return this.forward(n);
        }
        if (n < 0) {
            return this.reverse(n);
        }
        return this.isOnValidRow();
    }

    final boolean absolute(int n) throws SQLServerException {
        this.doServerFetch(16, n, this.fetchSize);
        this.rs.stmt.fetchBufferBeforeFirst();
        this.currentBufferRow = this.rs.stmt.fetchBufferNext() ? 1 : (n > 0 ? -2 : -1);
        return this.isOnValidRow();
    }

    final int getRow() throws SQLServerException {
        return this.currentBufferRow;
    }

    final void refresh() throws SQLServerException {
        int n;
        this.doServerFetch(128, 0, 0);
        this.rs.stmt.fetchBufferBeforeFirst();
        for (n = 0; n < this.currentBufferRow && this.rs.stmt.fetchBufferNext(); ++n) {
        }
        this.currentBufferRow = n;
    }

    final boolean rowDeleted() throws SQLServerException {
        return 1 == this.rowCondition[this.currentBufferRow - 1] || 2 == this.rs.stmt.columns[this.rs.stmt.columns.length - 1].getInt();
    }

    private final void makeUpdateStmt() throws SQLServerException {
        this.updateStatement = this.rs.stmt.connection.createInternalStatement();
        this.updateStatement.columns = this.rs.stmt.columns;
        this.updateStatement.isServerSideCursor = this.rs.stmt.isServerSideCursor;
    }

    final void insertRow() throws SQLServerException {
        if (null == this.updateStatement) {
            this.makeUpdateStmt();
        }
        this.updateStatement.putRowRPC(this.rs.stmt, 0, true, false);
    }

    final void updateRow() throws SQLServerException {
        if (null == this.updateStatement) {
            this.makeUpdateStmt();
        }
        this.updateStatement.putRowRPC(this.rs.stmt, this.currentBufferRow, false, false);
        this.rowCondition[this.currentBufferRow - 1] = 2;
    }

    final void deleteRow() throws SQLServerException {
        if (null == this.updateStatement) {
            this.makeUpdateStmt();
        }
        this.updateStatement.putRowRPC(this.rs.stmt, this.currentBufferRow, false, true);
        this.rowCondition[this.currentBufferRow - 1] = 1;
    }
}

