/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Iterator;
import java.util.List;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.util.test.FreeColTestCase;
import net.sf.freecol.util.test.FreeColTestUtils;

public class SchoolTest
extends FreeColTestCase {
    private static final BuildingType schoolType = SchoolTest.spec().getBuildingType("model.building.schoolhouse");
    private static final BuildingType collegeType = SchoolTest.spec().getBuildingType("model.building.college");
    private static final BuildingType universityType = SchoolTest.spec().getBuildingType("model.building.university");
    private static final GoodsType lumber = SchoolTest.spec().getGoodsType("model.goods.lumber");
    private static final GoodsType cotton = SchoolTest.spec().getGoodsType("model.goods.cotton");
    private static final UnitType colonialRegularType = SchoolTest.spec().getUnitType("model.unit.colonialRegular");
    private static final UnitType elderStatesmanType = SchoolTest.spec().getUnitType("model.unit.elderStatesman");
    private static final UnitType expertLumberJackType = SchoolTest.spec().getUnitType("model.unit.expertLumberJack");
    private static final UnitType expertOreMinerType = SchoolTest.spec().getUnitType("model.unit.expertOreMiner");
    private static final UnitType freeColonistType = SchoolTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType indenturedServantType = SchoolTest.spec().getUnitType("model.unit.indenturedServant");
    private static final UnitType pettyCriminalType = SchoolTest.spec().getUnitType("model.unit.pettyCriminal");
    private static final UnitType masterBlacksmithType = SchoolTest.spec().getUnitType("model.unit.masterBlacksmith");
    private static final UnitType masterCarpenterType = SchoolTest.spec().getUnitType("model.unit.masterCarpenter");
    private static final UnitType veteranSoldierType = SchoolTest.spec().getUnitType("model.unit.veteranSoldier");

    private Building addSchoolToColony(Game game, Colony colony, SchoolLevel level) {
        BuildingType type = null;
        switch (level) {
            case SCHOOLHOUSE: {
                type = schoolType;
                break;
            }
            case COLLEGE: {
                type = collegeType;
                break;
            }
            case UNIVERSITY: {
                type = universityType;
                break;
            }
            default: {
                SchoolTest.fail((String)"Setup error, cannot setup school");
            }
        }
        colony.addBuilding(new ServerBuilding(game, colony, type));
        return colony.getBuilding(type);
    }

    private List<Unit> getUnitList(Colony colony, UnitType type) {
        return CollectionUtils.transform(colony.getUnits(), CollectionUtils.matchKey(type, Unit::getType));
    }

    public void testUpgrades() {
        SchoolTest.assertEquals((String)"Colonist should upgrade to carpenter", (Object)masterCarpenterType, (Object)freeColonistType.getTeachingType(masterCarpenterType));
        SchoolTest.assertEquals((String)"Servant should upgrade to colonist", (Object)freeColonistType, (Object)indenturedServantType.getTeachingType(masterCarpenterType));
        SchoolTest.assertEquals((String)"Criminal should upgrade to servant", (Object)indenturedServantType, (Object)pettyCriminalType.getTeachingType(masterCarpenterType));
    }

    public void testEducationOption() {
        Game game = SchoolTest.getGame();
        game.changeMap(SchoolTest.getTestMap(true));
        Colony colony = this.getStandardColony(5);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit lumberJack = units.next();
        lumberJack.setType(expertLumberJackType);
        Unit criminal1 = units.next();
        criminal1.setType(pettyCriminalType);
        Unit criminal2 = units.next();
        criminal2.setType(pettyCriminalType);
        Unit colonist1 = units.next();
        colonist1.setType(freeColonistType);
        Unit colonist2 = units.next();
        colonist2.setType(freeColonistType);
        boolean selection = FreeColTestUtils.setStudentSelection(true);
        colony.addBuilding(new ServerBuilding(SchoolTest.getGame(), colony, schoolType));
        Building school = colony.getBuilding(schoolType);
        SchoolTest.assertTrue((boolean)school.canTeach());
        SchoolTest.assertTrue((boolean)colony.canTrain(lumberJack));
        lumberJack.setLocation(school);
        colonist1.changeWorkType(cotton);
        colonist2.changeWorkType(lumber);
        SchoolTest.assertEquals((Object)cotton, (Object)colonist1.getWorkType());
        SchoolTest.assertEquals((Object)expertLumberJackType.getExpertProduction(), (Object)colonist2.getWorkType());
        SchoolTest.assertEquals(null, (Object)colony.findStudent(lumberJack));
        lumberJack.setStudent(null);
        colonist2.setTeacher(null);
        FreeColTestUtils.setStudentSelection(false);
        criminal1.changeWorkType(cotton);
        criminal2.changeWorkType(lumber);
        SchoolTest.assertEquals((Object)criminal2, (Object)colony.findStudent(lumberJack));
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testChangeTeachers() {
        Game game = SchoolTest.getGame();
        game.changeMap(SchoolTest.getTestMap());
        FreeColTestUtils.ColonyBuilder colBuilder = FreeColTestUtils.getColonyBuilder();
        colBuilder.initialColonists(3).addColonist(expertLumberJackType).addColonist(expertLumberJackType);
        Colony colony = colBuilder.build();
        Building school = this.addSchoolToColony(game, colony, SchoolLevel.COLLEGE);
        Unit student = this.getUnitList(colony, freeColonistType).get(0);
        List<Unit> teacherList = this.getUnitList(colony, expertLumberJackType);
        Unit teacher1 = teacherList.get(0);
        Unit teacher2 = teacherList.get(1);
        SchoolTest.assertNull((String)"Teacher1 should not have a student yet", (Object)teacher1.getStudent());
        SchoolTest.assertNull((String)"Teacher2 should not have a student yet", (Object)teacher2.getStudent());
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        teacher1.setLocation(school);
        SchoolTest.assertEquals((String)"Teacher1 should now have a student", (Object)student, (Object)teacher1.getStudent());
        SchoolTest.assertEquals((String)"Student should have assigned teacher1", (Object)teacher1, (Object)student.getTeacher());
        teacher2.setLocation(school);
        SchoolTest.assertEquals((String)"Teacher1 should still have a student", (Object)teacher1.getStudent(), (Object)student);
        SchoolTest.assertNull((String)"Teacher2 should not have a student yet", (Object)teacher2.getStudent());
        SchoolTest.assertEquals((String)"Student should have assigned teacher1", (Object)student.getTeacher(), (Object)teacher1);
        student.setTeacher(teacher2);
        SchoolTest.assertNull((String)"Teacher1 should not have a student now", (Object)teacher1.getStudent());
        SchoolTest.assertEquals((String)"Teacher2 should now have a student", (Object)student, (Object)teacher2.getStudent());
        SchoolTest.assertEquals((String)"Student should have assigned teacher2", (Object)teacher2, (Object)student.getTeacher());
        FreeColTestUtils.setStudentSelection(selection);
    }

    private static enum SchoolLevel {
        SCHOOLHOUSE,
        COLLEGE,
        UNIVERSITY;

    }
}

