/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.component;

import java.util.Set;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;

public class ComponentModelScope
extends Config.AbstractScope {
    private final Config.Scope origScope;
    private final ComponentModel componentConfig;
    private final String prefix;

    public ComponentModelScope(Config.Scope origScope, ComponentModel componentConfig) {
        this(origScope, componentConfig, "");
    }

    public ComponentModelScope(Config.Scope origScope, ComponentModel componentConfig, String prefix) {
        this.origScope = origScope;
        this.componentConfig = componentConfig;
        this.prefix = prefix;
    }

    public String getComponentId() {
        return this.componentConfig.getId();
    }

    public String getComponentName() {
        return this.componentConfig.getName();
    }

    public <T> T getComponentNote(String key) {
        return (T)this.componentConfig.getNote(key);
    }

    public String getComponentParentId() {
        return this.componentConfig.getParentId();
    }

    public String getComponentSubType() {
        return this.componentConfig.getSubType();
    }

    public String get(String key) {
        String res = this.componentConfig.get(this.prefix + key, null);
        return res == null ? this.origScope.get(key) : res;
    }

    public Config.Scope scope(String ... scope) {
        return new ComponentModelScope(this.origScope.scope(scope), this.componentConfig, String.join((CharSequence)".", scope) + ".");
    }

    public Set<String> getPropertyNames() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ComponentModel getComponentModel() {
        return this.componentConfig;
    }

    public Config.Scope root() {
        return this.origScope.root();
    }
}

