/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message;

import java.io.ByteArrayInputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jupnp.http.Headers;
import org.jupnp.model.message.header.UpnpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpnpHeaders
extends Headers {
    private final Logger logger = LoggerFactory.getLogger(UpnpHeaders.class);
    protected Map<UpnpHeader.Type, List<UpnpHeader>> parsedHeaders;

    public UpnpHeaders() {
    }

    public UpnpHeaders(Map<String, List<String>> headers) {
        super(headers);
    }

    public UpnpHeaders(ByteArrayInputStream inputStream) {
        super(inputStream);
    }

    public UpnpHeaders(boolean normalizeHeaders) {
        super(normalizeHeaders);
    }

    protected void parseHeaders() {
        this.parsedHeaders = new LinkedHashMap<UpnpHeader.Type, List<UpnpHeader>>();
        this.logger.trace("Parsing all HTTP headers for known UPnP headers: {}", (Object)this.size());
        for (Map.Entry<String, List<String>> entry : this.entrySet()) {
            if (entry.getKey() == null) continue;
            UpnpHeader.Type type = UpnpHeader.Type.getByHttpName(entry.getKey());
            if (type == null) {
                this.logger.trace("Ignoring non-UPNP HTTP header: {}", (Object)entry.getKey());
                continue;
            }
            for (String value : entry.getValue()) {
                UpnpHeader upnpHeader = UpnpHeader.newInstance(type, value);
                if (upnpHeader == null || upnpHeader.getValue() == null) {
                    this.logger.trace("Ignoring known but irrelevant header (value violates the UDA specification?) '{}': {}", (Object)type.getHttpName(), (Object)value);
                    continue;
                }
                this.addParsedValue(type, upnpHeader);
            }
        }
    }

    protected void addParsedValue(UpnpHeader.Type type, UpnpHeader value) {
        this.logger.trace("Adding parsed header: {}", (Object)value);
        List list = this.parsedHeaders.computeIfAbsent(type, k -> new LinkedList());
        list.add(value);
    }

    @Override
    public List<String> put(String key, List<String> values) {
        this.parsedHeaders = null;
        return super.put(key, values);
    }

    @Override
    public void add(String key, String value) {
        this.parsedHeaders = null;
        super.add(key, value);
    }

    @Override
    public List<String> remove(Object key) {
        this.parsedHeaders = null;
        return super.remove(key);
    }

    @Override
    public void clear() {
        this.parsedHeaders = null;
        super.clear();
    }

    public boolean containsKey(UpnpHeader.Type type) {
        if (this.parsedHeaders == null) {
            this.parseHeaders();
        }
        return this.parsedHeaders.containsKey((Object)type);
    }

    public List<UpnpHeader> get(UpnpHeader.Type type) {
        if (this.parsedHeaders == null) {
            this.parseHeaders();
        }
        return this.parsedHeaders.get((Object)type);
    }

    public void add(UpnpHeader.Type type, UpnpHeader value) {
        super.add(type.getHttpName(), value.getString());
        if (this.parsedHeaders != null) {
            this.addParsedValue(type, value);
        }
    }

    public void remove(UpnpHeader.Type type) {
        super.remove(type.getHttpName());
        if (this.parsedHeaders != null) {
            this.parsedHeaders.remove((Object)type);
        }
    }

    public UpnpHeader[] getAsArray(UpnpHeader.Type type) {
        if (this.parsedHeaders == null) {
            this.parseHeaders();
        }
        return this.parsedHeaders.get((Object)type) != null ? this.parsedHeaders.get((Object)type).toArray(new UpnpHeader[this.parsedHeaders.get((Object)type).size()]) : new UpnpHeader[]{};
    }

    public UpnpHeader getFirstHeader(UpnpHeader.Type type) {
        return this.getAsArray(type).length > 0 ? this.getAsArray(type)[0] : null;
    }

    public <H extends UpnpHeader> H getFirstHeader(UpnpHeader.Type type, Class<H> subtype) {
        UpnpHeader[] headers;
        for (UpnpHeader header : headers = this.getAsArray(type)) {
            if (!subtype.isAssignableFrom(header.getClass())) continue;
            return (H)header;
        }
        return null;
    }

    public String getFirstHeaderString(UpnpHeader.Type type) {
        UpnpHeader header = this.getFirstHeader(type);
        return header != null ? header.getString() : null;
    }

    public void log() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("############################ RAW HEADERS ###########################");
            for (Map.Entry<String, List<String>> entry : this.entrySet()) {
                this.logger.trace("=== NAME : {}", (Object)entry.getKey());
                for (String string : entry.getValue()) {
                    this.logger.trace("VALUE: {}", (Object)string);
                }
            }
            if (this.parsedHeaders != null && !this.parsedHeaders.isEmpty()) {
                this.logger.trace("########################## PARSED HEADERS ##########################");
                for (Map.Entry<Object, List<Object>> entry : this.parsedHeaders.entrySet()) {
                    this.logger.trace("=== TYPE: {}", entry.getKey());
                    for (UpnpHeader upnpHeader : entry.getValue()) {
                        this.logger.trace("HEADER: {}", (Object)upnpHeader);
                    }
                }
            }
            this.logger.trace("####################################################################");
        }
    }
}

