/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * equal(dvec4(-1.5lf, -1.5lf, -1.5lf, -1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)) => bvec4(true, false, false, false)
 * equal(dvec4(-0.5lf, -0.5lf, -0.5lf, -0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)) => bvec4(false, true, false, false)
 * equal(dvec4(0.5lf, 0.5lf, 0.5lf, 0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)) => bvec4(false, false, true, false)
 * equal(dvec4(1.5lf, 1.5lf, 1.5lf, 1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)) => bvec4(false, false, false, true)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[equal(dvec4(-1.5lf, -1.5lf, -1.5lf, -1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf))[0] == true && equal(dvec4(-1.5lf, -1.5lf, -1.5lf, -1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf))[1] == false && equal(dvec4(-1.5lf, -1.5lf, -1.5lf, -1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf))[2] == false && equal(dvec4(-1.5lf, -1.5lf, -1.5lf, -1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf))[3] == false ? 1 : -1] array0;
  double[equal(dvec4(-0.5lf, -0.5lf, -0.5lf, -0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf))[0] == false && equal(dvec4(-0.5lf, -0.5lf, -0.5lf, -0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf))[1] == true && equal(dvec4(-0.5lf, -0.5lf, -0.5lf, -0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf))[2] == false && equal(dvec4(-0.5lf, -0.5lf, -0.5lf, -0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf))[3] == false ? 1 : -1] array1;
  double[equal(dvec4(0.5lf, 0.5lf, 0.5lf, 0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf))[0] == false && equal(dvec4(0.5lf, 0.5lf, 0.5lf, 0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf))[1] == false && equal(dvec4(0.5lf, 0.5lf, 0.5lf, 0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf))[2] == true && equal(dvec4(0.5lf, 0.5lf, 0.5lf, 0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf))[3] == false ? 1 : -1] array2;
  double[equal(dvec4(1.5lf, 1.5lf, 1.5lf, 1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf))[0] == false && equal(dvec4(1.5lf, 1.5lf, 1.5lf, 1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf))[1] == false && equal(dvec4(1.5lf, 1.5lf, 1.5lf, 1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf))[2] == false && equal(dvec4(1.5lf, 1.5lf, 1.5lf, 1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf))[3] == true ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
