/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec2(10ul, 12ul) >> i64vec2(13l, 63l)) => u64vec2(0ul, 0ul)
 * (u64vec2(42ul, 48ul) >> i64vec2(13l, 63l)) => u64vec2(0ul, 0ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec2(10ul, 12ul) >> i64vec2(13l, 63l)), u64vec2(0ul, 0ul))) ? 1 : -1] array0;
  float[all(equal((u64vec2(42ul, 48ul) >> i64vec2(13l, 63l)), u64vec2(0ul, 0ul))) ? 1 : -1] array1;
  gl_FragColor = vec4(array0.length() + array1.length());
}
