/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * roundEven(-2.0lf) => -2.0lf
 * roundEven(-1.8333333333333333lf) => -2.0lf
 * roundEven(-1.6666666666666667lf) => -2.0lf
 * roundEven(-1.5lf) => -2.0lf
 * roundEven(-1.3333333333333335lf) => -1.0lf
 * roundEven(-1.1666666666666667lf) => -1.0lf
 * roundEven(-1.0lf) => -1.0lf
 * roundEven(-0.8333333333333335lf) => -1.0lf
 * roundEven(-0.6666666666666667lf) => -1.0lf
 * roundEven(-0.5lf) => -0.0lf
 * roundEven(-0.3333333333333335lf) => -0.0lf
 * roundEven(-0.16666666666666674lf) => -0.0lf
 * roundEven(0.0lf) => 0.0lf
 * roundEven(0.16666666666666652lf) => 0.0lf
 * roundEven(0.33333333333333304lf) => 0.0lf
 * roundEven(0.5lf) => 0.0lf
 * roundEven(0.6666666666666665lf) => 1.0lf
 * roundEven(0.833333333333333lf) => 1.0lf
 * roundEven(1.0lf) => 1.0lf
 * roundEven(1.1666666666666665lf) => 1.0lf
 * roundEven(1.333333333333333lf) => 1.0lf
 * roundEven(1.5lf) => 2.0lf
 * roundEven(1.6666666666666665lf) => 2.0lf
 * roundEven(1.833333333333333lf) => 2.0lf
 * roundEven(2.0lf) => 2.0lf
 */
#version 400

void main()
{
  double[distance(roundEven(-2.0lf), -2.0lf) <= 2e-05lf ? 1 : -1] array0;
  double[distance(roundEven(-1.8333333333333333lf), -2.0lf) <= 2e-05lf ? 1 : -1] array1;
  double[distance(roundEven(-1.6666666666666667lf), -2.0lf) <= 2e-05lf ? 1 : -1] array2;
  double[distance(roundEven(-1.5lf), -2.0lf) <= 2e-05lf ? 1 : -1] array3;
  double[distance(roundEven(-1.3333333333333335lf), -1.0lf) <= 1e-05lf ? 1 : -1] array4;
  double[distance(roundEven(-1.1666666666666667lf), -1.0lf) <= 1e-05lf ? 1 : -1] array5;
  double[distance(roundEven(-1.0lf), -1.0lf) <= 1e-05lf ? 1 : -1] array6;
  double[distance(roundEven(-0.8333333333333335lf), -1.0lf) <= 1e-05lf ? 1 : -1] array7;
  double[distance(roundEven(-0.6666666666666667lf), -1.0lf) <= 1e-05lf ? 1 : -1] array8;
  double[distance(roundEven(-0.5lf), -0.0lf) <= 0.0lf ? 1 : -1] array9;
  double[distance(roundEven(-0.3333333333333335lf), -0.0lf) <= 0.0lf ? 1 : -1] array10;
  double[distance(roundEven(-0.16666666666666674lf), -0.0lf) <= 0.0lf ? 1 : -1] array11;
  double[distance(roundEven(0.0lf), 0.0lf) <= 0.0lf ? 1 : -1] array12;
  double[distance(roundEven(0.16666666666666652lf), 0.0lf) <= 0.0lf ? 1 : -1] array13;
  double[distance(roundEven(0.33333333333333304lf), 0.0lf) <= 0.0lf ? 1 : -1] array14;
  double[distance(roundEven(0.5lf), 0.0lf) <= 0.0lf ? 1 : -1] array15;
  double[distance(roundEven(0.6666666666666665lf), 1.0lf) <= 1e-05lf ? 1 : -1] array16;
  double[distance(roundEven(0.833333333333333lf), 1.0lf) <= 1e-05lf ? 1 : -1] array17;
  double[distance(roundEven(1.0lf), 1.0lf) <= 1e-05lf ? 1 : -1] array18;
  double[distance(roundEven(1.1666666666666665lf), 1.0lf) <= 1e-05lf ? 1 : -1] array19;
  double[distance(roundEven(1.333333333333333lf), 1.0lf) <= 1e-05lf ? 1 : -1] array20;
  double[distance(roundEven(1.5lf), 2.0lf) <= 2e-05lf ? 1 : -1] array21;
  double[distance(roundEven(1.6666666666666665lf), 2.0lf) <= 2e-05lf ? 1 : -1] array22;
  double[distance(roundEven(1.833333333333333lf), 2.0lf) <= 2e-05lf ? 1 : -1] array23;
  double[distance(roundEven(2.0lf), 2.0lf) <= 2e-05lf ? 1 : -1] array24;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length());
}
