/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.memory;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.graalvm.visualvm.lib.jfluid.ProfilerLogger;
import org.graalvm.visualvm.lib.jfluid.TargetAppRunner;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.global.ProfilingSessionStatus;
import org.graalvm.visualvm.lib.jfluid.results.ExportDataDumper;
import org.graalvm.visualvm.lib.jfluid.results.memory.HeapHistogram;
import org.graalvm.visualvm.lib.profiler.api.GoToSource;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.ui.LiveResultsPanel;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.memory.MemoryResUserActionsHandler;
import org.graalvm.visualvm.lib.ui.memory.SampledResultsPanel;

public class LiveSampledResultsPanel
extends SampledResultsPanel
implements LiveResultsPanel,
ActionListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_GoSourcePopupItemName");
    protected TargetAppRunner runner;
    private String[] classNames;
    private JMenuItem popupShowSource;
    private JPopupMenu memoryResPopupMenu;
    private ProfilingSessionStatus status;
    private boolean updateResultsInProgress = false;
    private boolean updateResultsPending = false;

    public LiveSampledResultsPanel(TargetAppRunner runner, MemoryResUserActionsHandler actionsHandler) {
        super(actionsHandler);
        this.status = runner.getProfilerClient().getStatus();
        this.runner = runner;
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    @Override
    public String getViewName() {
        return "memory-sampled-live";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.popupShowSource && this.popupShowSource != null) {
            this.showSourceForClass(this.selectedClassId);
        }
    }

    public void fetchResultsFromTargetApp() throws ClientUtils.TargetAppOrVMTerminated {
        int i;
        HeapHistogram histogram = this.runner.getProfilerClient().getHeapHistogram();
        HeapHistogram.ClassInfo[] classInfoArray = histogram.getHeapHistogram().toArray(new HeapHistogram.ClassInfo[0]);
        this.classNames = new String[classInfoArray.length];
        this.totalLiveObjectsSize = new long[classInfoArray.length];
        this.nTotalLiveObjects = new int[classInfoArray.length];
        for (i = 0; i < classInfoArray.length; ++i) {
            HeapHistogram.ClassInfo ci = classInfoArray[i];
            this.classNames[i] = ci.getName();
            this.totalLiveObjectsSize[i] = ci.getBytes();
            this.nTotalLiveObjects[i] = (int)ci.getInstancesCount();
        }
        this.nTrackedItems = classInfoArray.length;
        if (this.nTrackedItems > this.nTotalLiveObjects.length) {
            this.nTrackedItems = this.nTotalLiveObjects.length;
        }
        if (this.nTrackedItems > this.totalLiveObjectsSize.length) {
            this.nTrackedItems = this.totalLiveObjectsSize.length;
        }
        this.maxValue = 0L;
        this.nTotalLiveBytes = 0L;
        this.nTotalClasses = 0L;
        for (i = 0; i < this.nTrackedItems; ++i) {
            if (this.maxValue < this.totalLiveObjectsSize[i]) {
                this.maxValue = this.totalLiveObjectsSize[i];
            }
            this.nTotalLiveBytes += this.totalLiveObjectsSize[i];
            this.nTotalClasses += (long)this.nTotalLiveObjects[i];
        }
        this.initDataUponResultsFetch();
    }

    @Override
    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    @Override
    public void handleRemove() {
    }

    @Override
    public void handleShutdown() {
        if (this.memoryResPopupMenu != null && this.memoryResPopupMenu.isVisible()) {
            this.updateResultsPending = false;
            this.memoryResPopupMenu.setVisible(false);
        }
    }

    @Override
    public boolean hasView() {
        return this.resTable != null;
    }

    @Override
    public boolean supports(int instrumentationType) {
        return instrumentationType == 7;
    }

    @Override
    public void updateLiveResults() {
        if (this.memoryResPopupMenu != null && this.memoryResPopupMenu.isVisible()) {
            this.updateResultsPending = true;
            return;
        }
        if (this.updateResultsInProgress) {
            return;
        }
        this.updateResultsInProgress = true;
        String selectedRowString = null;
        if (this.resTable != null) {
            int selectedRowIndex = this.resTable.getSelectedRow();
            if (selectedRowIndex >= this.resTable.getRowCount()) {
                selectedRowIndex = -1;
                this.resTable.clearSelection();
            }
            if (selectedRowIndex != -1) {
                selectedRowString = this.resTable.getValueAt(selectedRowIndex, 0).toString();
            }
        }
        try {
            if (this.status.targetAppRunning) {
                this.reset();
                this.fetchResultsFromTargetApp();
            }
            this.prepareResults();
            if (selectedRowString != null) {
                this.resTable.selectRowByContents(selectedRowString, 0, false);
            }
            if (this.resTable != null && this.resTable.isFocusOwner()) {
                this.resTable.requestFocusInWindow();
            }
        }
        catch (ClientUtils.TargetAppOrVMTerminated e) {
            ProfilerDialogs.displayWarning((String)e.getMessage());
            ProfilerLogger.log((String)e.getMessage());
        }
        this.updateResultsInProgress = false;
    }

    @Override
    protected String getClassName(int classId) {
        return this.classNames[classId];
    }

    @Override
    protected String[] getClassNames() {
        return this.classNames;
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (this.memoryResPopupMenu == null) {
            this.memoryResPopupMenu = new JPopupMenu();
            if (GoToSource.isAvailable()) {
                Font boldfont = this.memoryResPopupMenu.getFont().deriveFont(1);
                this.popupShowSource = new JMenuItem();
                this.popupShowSource.setFont(boldfont);
                this.popupShowSource.setText(GO_SOURCE_POPUP_ITEM_NAME);
                this.memoryResPopupMenu.add(this.popupShowSource);
                this.popupShowSource.addActionListener(this);
            }
            this.memoryResPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (LiveSampledResultsPanel.this.updateResultsPending) {
                                LiveSampledResultsPanel.this.updateLiveResults();
                                LiveSampledResultsPanel.this.updateResultsPending = false;
                            }
                        }
                    });
                }
            });
        }
        return this.memoryResPopupMenu;
    }

    public void exportData(int typeOfFile, ExportDataDumper eDD, String viewName) {
        this.percentFormat.setMinimumFractionDigits(2);
        this.percentFormat.setMaximumFractionDigits(2);
        switch (typeOfFile) {
            case 1: {
                this.exportCSV(",", eDD);
                break;
            }
            case 2: {
                this.exportCSV(";", eDD);
                break;
            }
            case 3: {
                this.exportXML(eDD, viewName);
                break;
            }
            case 4: {
                this.exportHTML(eDD, viewName);
            }
        }
        this.percentFormat.setMinimumFractionDigits(0);
        this.percentFormat.setMaximumFractionDigits(1);
    }

    private void exportHTML(ExportDataDumper eDD, String viewName) {
        StringBuffer result = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + viewName + "</TITLE></HEAD><BODY><TABLE border=\"1\"><tr>");
        for (String columnName : this.columnNames) {
            result.append("<th>").append(columnName).append("</th>");
        }
        result.append("</tr>");
        eDD.dumpData((CharSequence)result);
        for (int i = 0; i < this.nTrackedItems; ++i) {
            result = new StringBuffer("<tr><td>" + this.replaceHTMLCharacters(this.sortedClassNames[i]) + "</td>");
            result.append("<td align=\"right\">").append(this.percentFormat.format((double)this.totalLiveObjectsSize[i] / (double)this.nTotalLiveBytes)).append("</td>");
            result.append("<td align=\"right\">").append(this.totalLiveObjectsSize[i]).append(" B</td>");
            result.append("<td align=\"right\">").append(this.nTotalLiveObjects[i]).append("</td></tr>");
            eDD.dumpData((CharSequence)result);
        }
        eDD.dumpDataAndClose(new StringBuffer(" </TABLE></BODY></HTML>"));
    }

    private void exportXML(ExportDataDumper eDD, String viewName) {
        String newline = System.lineSeparator();
        StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + newline + "<ExportedView Name=\"" + viewName + "\">" + newline);
        result.append("<TableData NumRows=\"").append(this.nTrackedItems).append("\" NumColumns=\"4\">").append(newline).append("<TableHeader>");
        for (String columnName : this.columnNames) {
            result.append("  <TableColumn><![CDATA[").append(columnName).append("]]></TableColumn>").append(newline);
        }
        result.append("</TableHeader>");
        eDD.dumpData((CharSequence)result);
        for (int i = 0; i < this.nTrackedItems; ++i) {
            result = new StringBuffer("  <TableRow>" + newline + "   <TableColumn><![CDATA[" + this.sortedClassNames[i] + "]]></TableColumn>" + newline);
            result.append("   <TableColumn><![CDATA[").append(this.percentFormat.format((double)this.totalLiveObjectsSize[i] / (double)this.nTotalLiveBytes)).append("]]></TableColumn>").append(newline);
            result.append("   <TableColumn><![CDATA[").append(this.totalLiveObjectsSize[i]).append("]]></TableColumn>").append(newline);
            result.append("   <TableColumn><![CDATA[").append(this.nTotalLiveObjects[i]).append("]]></TableColumn>").append(newline).append("  </TableRow>").append(newline);
            eDD.dumpData((CharSequence)result);
        }
        eDD.dumpDataAndClose(new StringBuffer(" </TableData>" + newline + "</ExportedView>"));
    }

    private void exportCSV(String separator, ExportDataDumper eDD) {
        StringBuffer result = new StringBuffer();
        String newLine = "\r\n";
        String quote = "\"";
        for (String columnName : this.columnNames) {
            result.append(quote).append(columnName).append(quote).append(separator);
        }
        result.deleteCharAt(result.length() - 1);
        result.append(newLine);
        eDD.dumpData((CharSequence)result);
        for (int i = 0; i < this.nTrackedItems; ++i) {
            result = new StringBuffer();
            result.append(quote).append(this.sortedClassNames[i]).append(quote).append(separator);
            result.append(quote).append(this.percentFormat.format((double)this.totalLiveObjectsSize[i] / (double)this.nTotalLiveBytes)).append(quote).append(separator);
            result.append(quote).append(this.totalLiveObjectsSize[i]).append(quote).append(separator);
            result.append(quote).append(this.nTotalLiveObjects[i]).append(quote).append(newLine);
            eDD.dumpData((CharSequence)result);
        }
        eDD.close();
    }

    private String replaceHTMLCharacters(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

