/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.core.ui.components.Spacer;
import org.graalvm.visualvm.jfr.model.JFRDataDescriptor;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventType;
import org.graalvm.visualvm.jfr.model.JFREventTypeVisitor;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRMethod;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.model.JFRStackFrame;
import org.graalvm.visualvm.jfr.model.JFRStackTrace;
import org.graalvm.visualvm.jfr.views.browser.BrowserNode;
import org.graalvm.visualvm.jfr.views.browser.BrowserRenderers;
import org.graalvm.visualvm.jfr.views.components.MessageComponent;
import org.graalvm.visualvm.lib.jfluid.utils.formatting.DefaultMethodNameFormatter;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.graalvm.visualvm.lib.ui.components.HTMLTextAreaSearchUtils;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTableModel;
import org.graalvm.visualvm.lib.ui.swing.renderer.FormattedLabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.HideableBarRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;
import org.openide.util.RequestProcessor;

final class BrowserViewSupport {
    private static final int ITEMS_LIMIT = Integer.getInteger("jfrviewer.browserItemsLimit", 100);
    private static final String ITEMS_LIMIT_STR = NumberFormat.getInstance().format(ITEMS_LIMIT);

    BrowserViewSupport() {
    }

    static abstract class StackTraceViewSupport
    extends JPanel {
        private static final RequestProcessor PROCESSOR = new RequestProcessor("JFR StackTrace Processor");
        private static final DefaultMethodNameFormatter METHOD_FORMAT = new DefaultMethodNameFormatter();
        private HTMLTextArea area;
        private boolean showing;
        private long pendingID = -1L;
        private long currentID = Long.MIN_VALUE;
        private RequestProcessor.Task currentTask;

        StackTraceViewSupport() {
            this.initComponents();
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L) {
                        showing = this.isShowing();
                        if (showing && pendingID != Long.MIN_VALUE) {
                            this.idSelected(pendingID);
                            pendingID = Long.MIN_VALUE;
                        }
                    }
                }
            });
        }

        abstract JFREvent getEvent(long var1);

        void idSelected(final long id) {
            if (!this.showing) {
                this.pendingID = id;
                return;
            }
            if (id == this.currentID) {
                return;
            }
            if (id == -1L) {
                this.currentID = -1L;
                this.setText("<nobr>&lt;no event selected&gt;</nobr>");
            } else {
                this.currentID = id;
                this.setText("<nobr>&lt;reading stack trace...&gt;</nobr>");
                if (this.currentTask != null) {
                    this.currentTask.cancel();
                }
                this.currentTask = PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        JFRStackTrace stack;
                        JFREvent event = this.getEvent(id);
                        try {
                            stack = event.getStackTrace("eventStackTrace");
                        }
                        catch (JFRPropertyNotAvailableException e) {
                            stack = null;
                        }
                        final String stackTrace = StackTraceViewSupport.formatStackTrace(stack);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (currentID == id) {
                                    this.setText(stackTrace);
                                    currentTask = null;
                                }
                            }
                        });
                    }
                });
            }
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Stack Trace", null, 10, (JComponent)this, null);
        }

        private static String formatStackTrace(JFRStackTrace stack) {
            if (stack == null) {
                return "<nobr>&lt;no stack trace&gt;</nobr>";
            }
            StringBuilder sb = new StringBuilder();
            String header = "<nobr><code>";
            sb.append(header);
            for (JFRStackFrame frame : stack.getFrames()) {
                sb.append(StackTraceViewSupport.formatStackFrame(frame)).append("<br>");
            }
            if (sb.length() == header.length()) {
                return "<nobr>&lt;empty stack trace&gt;</nobr>";
            }
            if (stack.isTruncated()) {
                sb.append("&lt;...truncated...&gt;").append("<br>");
            }
            sb.append("</code></nobr>");
            return sb.toString();
        }

        private static String formatStackFrame(JFRStackFrame frame) {
            String methodName;
            JFRMethod method = frame.getMethod();
            int line = frame.getLine();
            int bci = frame.getBCI();
            String type = frame.getType();
            String fullName = METHOD_FORMAT.formatMethodName(method.getType().getName(), method.getName(), method.getDescriptor()).toFormatted();
            int idx = fullName.indexOf(" : ");
            String ret = methodName = idx == -1 ? fullName : fullName.substring(0, idx);
            if (line != -1) {
                ret = ret + ":" + line;
            }
            ret = ret + "; ";
            if (bci > 0) {
                ret = ret + "bci=" + bci + ", ";
            }
            ret = ret + type;
            return ret.replace("<", "&lt;").replace(">", "&gt;");
        }

        private void setText(String text) {
            this.area.setText(text);
            this.area.setCaretPosition(0);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.area = new HTMLTextArea();
            this.area.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.add((Component)new ScrollableContainer((JComponent)this.area), "Center");
            this.add((Component)HTMLTextAreaSearchUtils.createSearchPanel((HTMLTextArea)this.area), "South");
        }
    }

    static abstract class EventsTableViewSupport
    extends JPanel {
        private EventsFilter eventsFilter;
        private boolean includeExperimental;
        private String[] names;
        private Comparable[][] values;
        private long[] ids;
        private EventsTableModel tableModel;
        private ProfilerTable table;

        EventsTableViewSupport() {
            this.initComponents();
        }

        abstract void idSelected(long var1);

        void setEventsFilter(EventsFilter filter) {
            this.eventsFilter = filter;
        }

        void setIncludeExperimental(boolean experimental) {
            this.includeExperimental = experimental;
        }

        JFREventVisitor getVisitor(final String eventType, final long eventsCount, final List<JFRDataDescriptor> dataDescriptors) {
            return new JFREventVisitor(){
                private final EventsFilter filter;
                private final int totalEvents;
                private final int displayedEvents;
                private final Comparable[][] newValues;
                private final long[] newIds;
                private final Comparable[] COMPARABLE_ARR = new Comparable[0];
                private int dataIndex;
                private int eventIndex;
                private int startIndex;
                private double nextIndex;
                private double step;
                {
                    this.totalEvents = eventsCount == -1L ? 0 : (int)Math.min(eventsCount, Integer.MAX_VALUE);
                    this.filter = this.totalEvents <= ITEMS_LIMIT ? EventsFilter.ALL : eventsFilter;
                    this.displayedEvents = EventsFilter.ALL.equals((Object)this.filter) ? this.totalEvents : Math.min(this.totalEvents, ITEMS_LIMIT);
                    this.newValues = dataDescriptors == null ? (Comparable[][])null : new Comparable[this.displayedEvents][dataDescriptors.size()];
                    this.newIds = this.totalEvents == 0 ? null : new long[this.displayedEvents];
                }

                @Override
                public void init() {
                    this.dataIndex = 0;
                    this.eventIndex = -1;
                    switch (this.filter) {
                        case ALL: 
                        case FIRST_N: {
                            this.startIndex = 0;
                            break;
                        }
                        case MIDDLE_N: {
                            if (this.totalEvents <= ITEMS_LIMIT + 1) {
                                this.startIndex = 0;
                                break;
                            }
                            this.startIndex = (this.totalEvents - ITEMS_LIMIT) / 2;
                            break;
                        }
                        case LAST_N: {
                            if (this.totalEvents <= ITEMS_LIMIT) {
                                this.startIndex = 0;
                                break;
                            }
                            this.startIndex = this.totalEvents - ITEMS_LIMIT;
                            break;
                        }
                        case SAMPLE_N: {
                            this.nextIndex = 0.0;
                            this.step = (double)(this.totalEvents - 1) / (double)(ITEMS_LIMIT - 1);
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Comparable[][] comparableArray;
                            EventsTableViewSupport.access$1602(this, null);
                            EventsTableViewSupport eventsTableViewSupport = this;
                            if (dataDescriptors == null) {
                                comparableArray = null;
                            } else {
                                Comparable[][] comparableArrayArray = new Comparable[1][];
                                comparableArray = comparableArrayArray;
                                comparableArrayArray[0] = null;
                            }
                            EventsTableViewSupport.access$1702(eventsTableViewSupport, comparableArray);
                            tableModel.fireTableStructureChanged();
                        }
                    });
                }

                @Override
                public boolean visit(String typeName, JFREvent event) {
                    if (eventType == null) {
                        return true;
                    }
                    if (eventType.equals(typeName)) {
                        ++this.eventIndex;
                        switch (this.filter) {
                            case ALL: 
                            case FIRST_N: {
                                break;
                            }
                            case MIDDLE_N: 
                            case LAST_N: {
                                if (this.eventIndex >= this.startIndex) break;
                                return false;
                            }
                            case SAMPLE_N: {
                                if ((long)this.eventIndex == Math.round(this.nextIndex) || this.eventIndex == this.totalEvents - 1) {
                                    this.nextIndex += this.step;
                                    break;
                                }
                                return false;
                            }
                        }
                        this.newIds[this.dataIndex] = event.getID();
                        this.newValues[this.dataIndex++] = event.getDisplayableValues(includeExperimental).toArray(this.COMPARABLE_ARR);
                    }
                    return this.dataIndex == this.displayedEvents;
                }

                @Override
                public void done() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<String> tooltips = new ArrayList<String>();
                            ArrayList<LabelRenderer> renderers = new ArrayList<LabelRenderer>();
                            if (dataDescriptors != null) {
                                int namesIndex = 0;
                                EventsTableViewSupport.access$1602(this, new String[dataDescriptors.size()]);
                                for (JFRDataDescriptor descriptor : dataDescriptors) {
                                    LabelRenderer renderer;
                                    String dataName = descriptor.getDataName();
                                    ((EventsTableViewSupport)this).names[namesIndex++] = dataName;
                                    String dataDescription = descriptor.getDataDescription();
                                    tooltips.add(dataDescription != null && !dataDescription.isEmpty() ? dataDescription : dataName);
                                    Format format = descriptor.getDataFormat();
                                    Object object = renderer = format == null ? new LabelRenderer() : new FormattedLabelRenderer(format);
                                    if (descriptor.isNumericData()) {
                                        renderer.setHorizontalAlignment(11);
                                    }
                                    renderers.add(renderer);
                                }
                            }
                            EventsTableViewSupport.access$1702(this, newValues);
                            EventsTableViewSupport.access$2102(this, newIds);
                            tableModel.fireTableStructureChanged();
                            table.setSortColumn(0);
                            table.setColumnToolTips(tooltips.toArray(new String[0]));
                            for (int column = 0; column < renderers.size(); ++column) {
                                table.setColumnRenderer(column, (ProfilerRenderer)renderers.get(column));
                            }
                        }
                    });
                }
            };
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Events", null, 10, (JComponent)this, null);
        }

        private void initComponents() {
            this.tableModel = new EventsTableModel();
            this.table = new ProfilerTable((TableModel)this.tableModel, true, true, null);
            this.table.setFitWidthColumn(-1);
            this.table.setSorting(0, SortOrder.UNSORTED);
            this.table.setDefaultSortOrder(SortOrder.ASCENDING);
            this.table.setDefaultRenderer(Comparable.class, (ProfilerRenderer)new LabelRenderer());
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int selected = table.getSelectedRow();
                        if (selected == 0 && values[0] == null) {
                            selected = -1;
                        }
                        this.idSelected(selected == -1 ? -1L : ids[table.convertRowIndexToModel(selected)]);
                    }
                }
            });
            this.setLayout(new BorderLayout());
            this.add((Component)new ProfilerTableContainer(this.table, false, null), "Center");
        }

        static /* synthetic */ String[] access$1602(EventsTableViewSupport x0, String[] x1) {
            x0.names = x1;
            return x1;
        }

        static /* synthetic */ Comparable[][] access$1702(EventsTableViewSupport x0, Comparable[][] x1) {
            x0.values = x1;
            return x1;
        }

        static /* synthetic */ long[] access$2102(EventsTableViewSupport x0, long[] x1) {
            x0.ids = x1;
            return x1;
        }

        private class EventsTableModel
        extends AbstractTableModel {
            private EventsTableModel() {
            }

            @Override
            public String getColumnName(int columnIndex) {
                return EventsTableViewSupport.this.names == null ? " " : EventsTableViewSupport.this.names[columnIndex];
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return Comparable.class;
            }

            @Override
            public int getRowCount() {
                return EventsTableViewSupport.this.values == null ? 0 : EventsTableViewSupport.this.values.length;
            }

            @Override
            public int getColumnCount() {
                return EventsTableViewSupport.this.names == null ? 1 : EventsTableViewSupport.this.names.length;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Comparable[] row = EventsTableViewSupport.this.values[rowIndex];
                if (row == null) {
                    return columnIndex == 0 ? "loading events..." : "";
                }
                return row[columnIndex];
            }
        }
    }

    static abstract class EventsTreeViewSupport
    extends JPanel
    implements JFREventTypeVisitor {
        private boolean includeExperimental;
        private Map<String, JFREventType> types;
        private DataModel tableModel;
        private ProfilerTreeTable table;
        private boolean selectionPaused = false;

        EventsTreeViewSupport(long eventsCount) {
            this.initComponents(eventsCount);
        }

        abstract void eventsSelected(String var1, long var2, List<JFRDataDescriptor> var4);

        void pauseSelection() {
            this.selectionPaused = true;
        }

        void refreshSelection() {
            BrowserNode.EventType typeNode;
            if (this.selectionPaused) {
                return;
            }
            BrowserNode node = this.getSelectedNode();
            BrowserNode.EventType eventType = typeNode = node instanceof BrowserNode.EventType ? (BrowserNode.EventType)node : null;
            if (typeNode == null) {
                this.eventsSelected(null, -1L, null);
            } else {
                this.eventsSelected(typeNode.typeName, typeNode.eventsCount, typeNode.type.getDisplayableDataDescriptors(this.includeExperimental));
            }
        }

        void setIncludeExperimental(boolean experimental) {
            this.includeExperimental = experimental;
        }

        @Override
        public void initTypes() {
            this.types = new HashMap<String, JFREventType>();
        }

        @Override
        public boolean visitType(String typeName, JFREventType eventType) {
            if (this.includeExperimental || !eventType.isExperimental()) {
                this.types.put(typeName, eventType);
            }
            return false;
        }

        JFREventVisitor getVisitor() {
            return new BrowserNode.Root(){

                @Override
                public void done() {
                    super.done();
                    tableModel.setRoot((TreeNode)((Object)this));
                    EventsTreeViewSupport.initialExpand(table, this);
                    selectionPaused = false;
                    this.refreshSelection();
                }

                @Override
                JFREventType type(String typeName) {
                    return (JFREventType)types.get(typeName);
                }
            };
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Types", null, 10, (JComponent)this, null);
        }

        private void initComponents(long eventsCount) {
            this.tableModel = new DataModel();
            this.table = new ProfilerTreeTable((ProfilerTreeTableModel)this.tableModel, true, true, new int[]{0});
            this.table.setRootVisible(false);
            this.table.setShowsRootHandles(true);
            this.table.setMainColumn(0);
            this.table.setFitWidthColumn(0);
            this.table.setDefaultSortOrder(SortOrder.ASCENDING);
            this.table.setDefaultSortOrder(2, SortOrder.DESCENDING);
            this.table.setSortColumn(0);
            final BrowserRenderers.NameRenderer nameRenderer = new BrowserRenderers.NameRenderer();
            nameRenderer.setShowsCount(!BrowserRenderers.EventsCountRenderer.isInitiallyVisible());
            this.table.setTreeCellRenderer((ProfilerRenderer)nameRenderer);
            BrowserRenderers.TypeIDRenderer typeIDRenderer = new BrowserRenderers.TypeIDRenderer();
            this.table.setColumnRenderer(1, (ProfilerRenderer)typeIDRenderer);
            this.table.setDefaultColumnWidth(1, typeIDRenderer.getPreferredWidth());
            this.table.setColumnVisibility(1, BrowserRenderers.TypeIDRenderer.isInitiallyVisible());
            BrowserRenderers.EventsCountRenderer eventsCountRenderer = new BrowserRenderers.EventsCountRenderer();
            HideableBarRenderer eventsCountRendererH = new HideableBarRenderer((ProfilerRenderer)eventsCountRenderer, eventsCountRenderer.getPreferredWidth());
            eventsCountRendererH.setMaxValue(eventsCount);
            this.table.setColumnRenderer(2, (ProfilerRenderer)eventsCountRendererH);
            this.table.setDefaultColumnWidth(2, eventsCountRendererH.getOptimalWidth());
            this.table.setColumnVisibility(2, BrowserRenderers.EventsCountRenderer.isInitiallyVisible());
            this.table.getColumnModel().getColumn(2).addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("maxWidth".equals(evt.getPropertyName())) {
                        nameRenderer.setShowsCount(Integer.valueOf(0).equals(evt.getNewValue()));
                        table.repaint();
                    }
                }
            });
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        this.refreshSelection();
                    }
                }
            });
            this.setLayout(new BorderLayout());
            this.add((Component)new ProfilerTableContainer((ProfilerTable)this.table, false, null), "Center");
        }

        private BrowserNode getSelectedNode() {
            int row = this.table.getSelectedRow();
            return row == -1 ? null : (BrowserNode)((Object)this.table.getValueForRow(row));
        }

        private static void initialExpand(ProfilerTreeTable table, BrowserNode root) {
            TreePath path = new TreePath((Object)root);
            for (BrowserNode node : root.getChildren()) {
                table.expandPath(path.pathByAddingChild((Object)node));
            }
        }

        private static class DataModel
        extends ProfilerTreeTableModel.Abstract {
            DataModel() {
                super((TreeNode)((Object)new BrowserNode.Root("reading data..."){}));
            }

            public int getColumnCount() {
                return 3;
            }

            public Class<?> getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return JTree.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return Long.class;
                    }
                }
                return null;
            }

            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return BrowserRenderers.NameRenderer.getDisplayName();
                    }
                    case 1: {
                        return BrowserRenderers.TypeIDRenderer.getDisplayName();
                    }
                    case 2: {
                        return BrowserRenderers.EventsCountRenderer.getDisplayName();
                    }
                }
                return null;
            }

            public Object getValueAt(TreeNode node, int column) {
                if (node == null) {
                    return null;
                }
                BrowserNode rnode = (BrowserNode)((Object)node);
                switch (column) {
                    case 0: {
                        return rnode;
                    }
                    case 1: {
                        return rnode instanceof BrowserNode.EventType && ((BrowserNode.EventType)rnode).type != null ? ((BrowserNode.EventType)rnode).type.getName() : null;
                    }
                    case 2: {
                        return rnode.eventsCount == 0L ? null : Long.valueOf(rnode.eventsCount);
                    }
                }
                return null;
            }

            public void setValueAt(Object o, TreeNode node, int column) {
            }

            public boolean isCellEditable(TreeNode node, int column) {
                return false;
            }
        }
    }

    static abstract class MasterViewSupport
    extends JPanel
    implements JFREventVisitor {
        private EventsFilter lastPrimary;
        private boolean lastExperimental;
        private int prefHeight = -1;
        private JLabel firstLabel;
        private JLabel secondLabel;
        private JLabel thirdLabel;
        private JComboBox<EventsFilter> firstCombo;
        private JCheckBox secondChoice;
        private JButton updateButton;

        MasterViewSupport(JFRModel model) {
            this.initComponents(model);
        }

        abstract void firstShown();

        abstract void eventsFilterChanged(EventsFilter var1);

        abstract void includeExperimentalChanged(boolean var1);

        @Override
        public boolean visit(String typeName, JFREvent event) {
            return false;
        }

        @Override
        public void done() {
        }

        DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView("Browser", null, (JComponent)this);
        }

        private void updateFilterHint() {
            this.thirdLabel.setVisible(!EventsFilter.ALL.equals((Object)this.lastPrimary) && !EventsFilter.SAMPLE_N.equals((Object)this.lastPrimary));
        }

        private void updateUpdateButton() {
            if (this.updateButton != null) {
                this.updateButton.setEnabled(this.lastExperimental != (this.secondChoice != null && this.secondChoice.isSelected()));
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            if (this.prefHeight == -1) {
                this.prefHeight = pref.height;
            } else {
                pref.height = this.prefHeight;
            }
            return pref;
        }

        private void initComponents(JFRModel model) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (model == null) {
                this.add((Component)MessageComponent.notAvailable(), "Center");
            } else {
                this.setLayout(new GridBagLayout());
                this.setBorder(BorderFactory.createEmptyBorder(11, 5, 20, 5));
                this.firstLabel = new JLabel();
                this.firstLabel.setText("Display:");
                this.firstLabel.setOpaque(false);
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.gridx = 0;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 8, 0, 0);
                this.add((Component)this.firstLabel, constraints);
                this.firstCombo = new JComboBox<EventsFilter>(new EventsFilter[]{EventsFilter.ALL, EventsFilter.FIRST_N, EventsFilter.MIDDLE_N, EventsFilter.LAST_N, EventsFilter.SAMPLE_N});
                this.firstCombo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (lastPrimary != firstCombo.getSelectedItem()) {
                            lastPrimary = (EventsFilter)((Object)firstCombo.getSelectedItem());
                            this.updateFilterHint();
                            this.eventsFilterChanged(lastPrimary);
                        }
                    }
                });
                constraints = new GridBagConstraints();
                constraints.gridx = 1;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 8, 0, 0);
                this.add(this.firstCombo, constraints);
                this.secondLabel = new JLabel();
                this.secondLabel.setText("of the selected type");
                this.secondLabel.setOpaque(false);
                constraints = new GridBagConstraints();
                constraints.gridx = 2;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 8, 0, 0);
                this.add((Component)this.secondLabel, constraints);
                this.thirdLabel = new JLabel();
                this.thirdLabel.setText("(by position in the file)");
                this.thirdLabel.setToolTipText("<html>Events might not be ordered in the file by their creation time.<br>First/Middle/Last means position in the file, not the creation time.</html>");
                this.thirdLabel.setOpaque(false);
                this.thirdLabel.setEnabled(false);
                constraints = new GridBagConstraints();
                constraints.gridx = 3;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 5, 0, 0);
                this.add((Component)this.thirdLabel, constraints);
                this.lastPrimary = (EventsFilter)((Object)this.firstCombo.getSelectedItem());
                this.updateFilterHint();
                this.eventsFilterChanged(this.lastPrimary);
                if (model.getExperimentalEventsCount() > 0L) {
                    JSeparator updateSeparator = new JSeparator(1);
                    updateSeparator.setOpaque(false);
                    constraints = new GridBagConstraints();
                    constraints.gridx = 4;
                    constraints.gridy = 2;
                    constraints.gridwidth = 1;
                    constraints.fill = 0;
                    constraints.anchor = 17;
                    constraints.insets = new Insets(4, this.secondChoice == null ? 16 : 12, 0, 0);
                    this.add((Component)updateSeparator, constraints);
                    this.secondChoice = new JCheckBox("Display experimental items");
                    this.secondChoice.setOpaque(false);
                    this.secondChoice.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            this.updateUpdateButton();
                        }
                    });
                    constraints = new GridBagConstraints();
                    constraints.gridx = 5;
                    constraints.gridy = 2;
                    constraints.gridwidth = 1;
                    constraints.fill = 0;
                    constraints.anchor = 17;
                    constraints.insets = new Insets(4, 10, 0, 0);
                    this.add((Component)this.secondChoice, constraints);
                    this.updateButton = new JButton("Update Data");
                    this.updateButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            updateButton.setEnabled(false);
                            if (lastExperimental != secondChoice.isSelected()) {
                                lastExperimental = secondChoice.isSelected();
                                this.includeExperimentalChanged(lastExperimental);
                            }
                        }
                    });
                    constraints = new GridBagConstraints();
                    constraints.gridx = 6;
                    constraints.gridy = 2;
                    constraints.gridwidth = 1;
                    constraints.fill = 0;
                    constraints.anchor = 17;
                    constraints.insets = new Insets(4, 12, 0, 0);
                    this.add((Component)this.updateButton, constraints);
                    Dimension cpuD = this.firstCombo.getPreferredSize();
                    Dimension sepD = updateSeparator.getPreferredSize();
                    sepD.height = cpuD.height - 2;
                    sepD.width = 5;
                    updateSeparator.setPreferredSize(sepD);
                    updateSeparator.setMinimumSize(sepD);
                    this.lastExperimental = this.secondChoice != null && this.secondChoice.isSelected();
                    this.updateUpdateButton();
                }
                constraints = new GridBagConstraints();
                constraints.gridx = 7;
                constraints.gridy = 2;
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.gridwidth = 0;
                constraints.fill = 1;
                constraints.anchor = 18;
                constraints.insets = new Insets(0, 0, 0, 0);
                this.add((Component)Spacer.create(), constraints);
                this.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) != 0L && this.isShowing()) {
                            this.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(this::firstShown);
                        }
                    }
                });
            }
        }
    }

    static enum EventsFilter {
        ALL{

            public String toString() {
                return "All Events";
            }
        }
        ,
        FIRST_N{

            public String toString() {
                return "First " + ITEMS_LIMIT_STR + " Events";
            }
        }
        ,
        MIDDLE_N{

            public String toString() {
                return "Middle " + ITEMS_LIMIT_STR + " Events";
            }
        }
        ,
        LAST_N{

            public String toString() {
                return "Last " + ITEMS_LIMIT_STR + " Events";
            }
        }
        ,
        SAMPLE_N{

            public String toString() {
                return "Sample " + ITEMS_LIMIT_STR + " Events";
            }
        };

    }
}

