/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.probes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.graalvm.visualvm.lib.charts.swing.Utils;
import org.graalvm.visualvm.lib.profiler.snaptracer.TracerProbe;
import org.graalvm.visualvm.lib.profiler.snaptracer.TracerProbeDescriptor;
import org.graalvm.visualvm.lib.ui.UIUtils;

public final class ProbePresenter
extends JLabel {
    private static final Color SELECTED_FILTER;
    private static final float[] FRACTIONS;
    private static final Color[] COLORS;
    private static final Color BACKGROUND;
    private LinearGradientPaint gradientPaint;
    private static final boolean GRADIENT;
    private boolean isSelected = false;

    public ProbePresenter(TracerProbe p, TracerProbeDescriptor d) {
        super(d.getProbeName(), d.getProbeIcon(), 10);
        this.putClientProperty("ToolTipHelper", d.getProbeDescription());
        this.setIconTextGap(7);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
    }

    public void setSelected(boolean selected) {
        if (this.isSelected == selected) {
            return;
        }
        this.isSelected = selected;
        this.repaint();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        if (GRADIENT) {
            this.gradientPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, h - 1, FRACTIONS, COLORS);
        }
        super.reshape(x, y, w, h);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int y = this.getHeight() - 1;
        ((Graphics2D)g).setPaint(GRADIENT ? this.gradientPaint : BACKGROUND);
        g.fillRect(0, 0, this.getWidth(), y);
        if (this.isSelected) {
            g.setColor(SELECTED_FILTER);
            g.fillRect(0, 0, this.getWidth(), y);
        }
        super.paintComponent(g);
    }

    static {
        Color[] colorArray;
        SELECTED_FILTER = new Color(0, 0, 200, 40);
        FRACTIONS = new float[]{0.0f, 0.49f, 0.51f, 1.0f};
        if (!UIUtils.isDarkResultsBackground()) {
            Color[] colorArray2 = new Color[4];
            colorArray2[0] = new Color(250, 251, 252, 120);
            colorArray2[1] = new Color(237, 240, 242, 120);
            colorArray2[2] = new Color(229, 233, 236, 125);
            colorArray = colorArray2;
            colorArray2[3] = new Color(215, 221, 226, 130);
        } else {
            Color[] colorArray3 = new Color[4];
            colorArray3[0] = new Color(50, 51, 52, 220);
            colorArray3[1] = new Color(37, 40, 42, 220);
            colorArray3[2] = new Color(29, 33, 36, 225);
            colorArray = colorArray3;
            colorArray3[3] = new Color(15, 21, 26, 230);
        }
        COLORS = colorArray;
        BACKGROUND = !UIUtils.isDarkResultsBackground() ? UIManager.getColor("Panel.background") : new Color(30, 30, 30);
        GRADIENT = !Utils.forceSpeed();
    }
}

