/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public final class ColorIcon
implements Icon {
    private static int WIDTH = 8;
    private static int HEIGHT = 8;
    private static Color BACKGROUND_COLOR = Color.WHITE;
    private static Color FOREGROUND_COLOR = Color.BLACK;
    public static final ColorIcon BOTTOM_SHADOW = new ColorIcon(null, true);
    private final boolean shadow;
    private final Color color;
    private static final Map<Color, ColorIcon> icons = new HashMap<Color, ColorIcon>();

    private ColorIcon(Color color) {
        this(color, false);
    }

    private ColorIcon(Color color, boolean shadow) {
        this.color = color;
        this.shadow = shadow;
    }

    public static void setup(int width, int height, Color foreground, Color background) {
        WIDTH = width;
        HEIGHT = height;
        BACKGROUND_COLOR = background;
        FOREGROUND_COLOR = foreground;
        icons.clear();
    }

    public static ColorIcon fromColor(Color color) {
        return icons.computeIfAbsent(color, ColorIcon::new);
    }

    @Override
    public int getIconWidth() {
        return WIDTH;
    }

    @Override
    public int getIconHeight() {
        return HEIGHT;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.shadow) {
            g.setColor(BACKGROUND_COLOR);
            g.drawLine(x, y + HEIGHT + 1, x + WIDTH - 1, y + HEIGHT + 1);
        } else {
            g.setColor(this.color);
            g.fillRect(x, y, WIDTH, HEIGHT);
            g.setColor(FOREGROUND_COLOR);
            g.drawRect(x, y, WIDTH - 1, HEIGHT - 1);
        }
    }
}

