/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.graalvm.visualvm.gotosource.SourcePathHandle;
import org.graalvm.visualvm.gotosource.impl.SourceRoots;

public final class SourcesRoot {
    public static final String MODULES_SUBPATH = "*modules*";
    private static final String SUBPATHS_PREFIX = "[subpaths=";
    private static final String SUBPATHS_SUFFIX = "]";
    private static final String ENCODING_PREFIX = "[encoding=";
    private static final String ENCODING_SUFFIX = "]";
    private static final Logger LOGGER = Logger.getLogger(SourcesRoot.class.getName());
    private final String rootPath;
    private final String[] subPaths;
    private final Charset encoding;

    private SourcesRoot(String rootPath) {
        Object[] resolved = SourcesRoot.resolve(rootPath);
        this.rootPath = (String)resolved[0];
        this.subPaths = (String[])resolved[1];
        this.encoding = (Charset)resolved[2];
    }

    private SourcePathHandle getSourceHandle(String resourcePath) {
        Path root = Paths.get(this.rootPath, new String[0]);
        try {
            if (Files.isDirectory(root, new LinkOption[0])) {
                return SourcesRoot.getHandleInDirectory(root, resourcePath, this.subPaths, this.encoding);
            }
            if (Files.isRegularFile(root, new LinkOption[0])) {
                return SourcesRoot.getHandleInArchive(root, resourcePath, this.subPaths, this.encoding);
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.INFO, "Failed resolving source file " + resourcePath + " in " + root, t);
        }
        return null;
    }

    private static SourcePathHandle getHandleInDirectory(Path directory, String sourcePath, String[] subPaths, Charset encoding) throws Throwable {
        if (subPaths == null) {
            Path sourceFile = directory.resolve(sourcePath);
            return SourcesRoot.isFile(sourceFile) ? new SourcePathHandle(sourceFile, false, encoding) : null;
        }
        if (subPaths.length == 1 && MODULES_SUBPATH.equals(subPaths[0])) {
            List subfolders = Files.walk(directory, 1, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
            for (Path subfolder : subfolders) {
                Path sourceFile = subfolder.resolve(sourcePath);
                if (!SourcesRoot.isFile(sourceFile)) continue;
                return new SourcePathHandle(sourceFile, false, encoding);
            }
        } else {
            for (String subPath : subPaths) {
                Path sourceFile = directory.resolve(subPath + "/" + sourcePath);
                if (!SourcesRoot.isFile(sourceFile)) continue;
                return new SourcePathHandle(sourceFile, false, encoding);
            }
        }
        return null;
    }

    private static SourcePathHandle getHandleInArchive(Path archive, String sourcePath, String[] subPaths, Charset encoding) throws Throwable {
        try (FileSystem archiveFileSystem = FileSystems.newFileSystem(archive, (ClassLoader)null);){
            if (subPaths == null) {
                Path sourceFile = archiveFileSystem.getPath(sourcePath, new String[0]);
                SourcePathHandle sourcePathHandle = SourcesRoot.isFile(sourceFile) ? new SourcePathHandle(sourceFile, true, encoding) : null;
                return sourcePathHandle;
            }
            if (subPaths.length == 1 && MODULES_SUBPATH.equals(subPaths[0])) {
                Path path = archiveFileSystem.getRootDirectories().iterator().next();
                List subfolders = Files.walk(path, 1, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
                for (Path subfolder : subfolders) {
                    Path sourceFile = subfolder.resolve(sourcePath);
                    if (!SourcesRoot.isFile(sourceFile)) continue;
                    SourcePathHandle sourcePathHandle = new SourcePathHandle(sourceFile, true, encoding);
                    return sourcePathHandle;
                }
            } else {
                for (String subPath : subPaths) {
                    Path sourceFile = archiveFileSystem.getPath(subPath, sourcePath);
                    if (!SourcesRoot.isFile(sourceFile)) continue;
                    SourcePathHandle sourcePathHandle = new SourcePathHandle(sourceFile, true, encoding);
                    return sourcePathHandle;
                }
            }
            String[] stringArray = null;
            return stringArray;
        }
    }

    public boolean equals(Object o) {
        return o instanceof SourcesRoot && this.rootPath.equals(((SourcesRoot)o).rootPath);
    }

    public int hashCode() {
        return this.rootPath.hashCode();
    }

    public String toString() {
        return this.rootPath;
    }

    public static SourcePathHandle getPathHandle(String resourcePath) {
        for (String rootPath : SourceRoots.getRoots()) {
            SourcesRoot root = new SourcesRoot(rootPath);
            SourcePathHandle handle = root.getSourceHandle(resourcePath);
            if (handle == null) continue;
            return handle;
        }
        return null;
    }

    public static String createString(String rootPath, String[] subPaths, String encoding) {
        if ((subPaths == null || subPaths.length == 0) && encoding == null) {
            return rootPath;
        }
        StringBuilder sb = new StringBuilder();
        if (subPaths != null && subPaths.length > 0) {
            SourcesRoot.normalizeSubpaths(subPaths);
            for (String subPath : subPaths) {
                if (sb.length() > 0) {
                    sb.append(":");
                }
                sb.append(subPath);
            }
            sb.insert(0, SUBPATHS_PREFIX);
            sb.append("]");
        }
        if (StandardCharsets.UTF_8.name().equals(encoding)) {
            encoding = null;
        }
        if (encoding != null) {
            sb.append(ENCODING_PREFIX).append(encoding).append("]");
        }
        sb.insert(0, rootPath);
        return sb.toString();
    }

    private static boolean isFile(Path path) {
        return Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS);
    }

    private static Object[] resolve(String root) {
        int idx = root.indexOf(91);
        String[] subpaths = null;
        Charset encoding = StandardCharsets.UTF_8;
        if (idx != -1) {
            String[] paramsArr;
            String params = root.substring(idx);
            root = root.substring(0, idx);
            for (String paramS : paramsArr = params.split("\\]\\[")) {
                if (!paramS.startsWith("[")) {
                    paramS = "[" + paramS;
                }
                if ((paramS = paramS.replace("]", "")).startsWith(SUBPATHS_PREFIX)) {
                    paramS = paramS.substring(SUBPATHS_PREFIX.length());
                    subpaths = SourcesRoot.subpaths(paramS);
                    continue;
                }
                if (!paramS.startsWith(ENCODING_PREFIX)) continue;
                paramS = paramS.substring(ENCODING_PREFIX.length());
                encoding = SourcesRoot.charset(paramS);
            }
        }
        return new Object[]{root, subpaths, encoding};
    }

    private static String[] subpaths(String subpaths) {
        if (subpaths.isEmpty()) {
            return null;
        }
        String[] paths = subpaths.split(":");
        SourcesRoot.normalizeSubpaths(paths);
        return paths;
    }

    private static void normalizeSubpaths(String[] subpaths) {
        for (int i = 0; i < subpaths.length; ++i) {
            String path = subpaths[i];
            if (!"/".equals(File.separator)) {
                path = path.replace(File.separator, "/");
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            subpaths[i] = path;
        }
    }

    private static Charset charset(String charset) {
        try {
            return Charset.forName(charset);
        }
        catch (Exception e) {
            return StandardCharsets.UTF_8;
        }
    }
}

