/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.gotosource.Bundle;
import org.graalvm.visualvm.gotosource.SourceHandle;
import org.graalvm.visualvm.gotosource.SourceHandleProvider;
import org.graalvm.visualvm.gotosource.impl.SourceHandles;
import org.graalvm.visualvm.gotosource.impl.SourceRoots;
import org.graalvm.visualvm.gotosource.impl.SourceViewers;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.spi.java.GoToSourceProvider;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

final class VisualVMGoToSource {
    private static final Logger LOGGER = Logger.getLogger(VisualVMGoToSource.class.getName());

    VisualVMGoToSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean openSourceImpl(SourceHandle handle) {
        try {
            if (!SourceViewers.getSelectedViewer().open(handle)) {
                ProfilerDialogs.displayError((String)Bundle.VisualVMGoToSource_OpenSourceFailed(SourceHandle.simpleUri(handle.getSourceUri())));
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            ProfilerDialogs.displayError((String)Bundle.VisualVMGoToSource_OpenSourceFailed(SourceHandle.simpleUri(handle.getSourceUri())));
            LOGGER.log(Level.INFO, "Failed to open source " + handle.toString(), t);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                handle.close();
            }
            catch (Throwable t) {
                LOGGER.log(Level.INFO, "Failed to close source " + handle.toString(), t);
            }
        }
    }

    public static final class Provider
    extends GoToSourceProvider {
        public boolean openSource(Lookup.Provider project, String className, String methodName, String signature, int line) {
            if (SourceRoots.getRoots().length == 0) {
                ProfilerDialogs.displayWarning((String)Bundle.VisualVMGoToSource_NoSourceRoots(), (String)Bundle.VisualVMGoToSource_NoSourceRootsCaption(), null);
                OptionsDisplayer.getDefault().open("SourcesOptions");
            } else {
                for (SourceHandleProvider sourceHandleProvider : SourceHandles.registeredProviders()) {
                    SourceHandle handle = sourceHandleProvider.createHandle(className, methodName, signature, line);
                    if (handle == null) continue;
                    return handle == SourceHandle.EMPTY || VisualVMGoToSource.openSourceImpl(handle);
                }
                if (methodName == null || methodName.isEmpty() || "*".equals(methodName)) {
                    ProfilerDialogs.displayError((String)Bundle.VisualVMGoToSource_ClassSourceNotFound(className));
                } else {
                    ProfilerDialogs.displayError((String)Bundle.VisualVMGoToSource_MethodSourceNotFound(className, methodName));
                }
            }
            return true;
        }

        public boolean openFile(FileObject srcFile, int offset) {
            throw new UnsupportedOperationException("GoToSource: openFile not supported in VisualVM");
        }
    }
}

