/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.java;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.visualvm.gotosource.java.JavaMethod;
import org.graalvm.visualvm.gotosource.java.JavaSourceUtils;

final class JavaClass {
    private final String name;
    private final String source;
    private final int nameStart;
    private final int bodyStart;
    private final int bodyEnd;
    private List<JavaClass> namedClasses;
    private List<JavaClass> anonymousClasses;

    private JavaClass(String name, String source, int nameStart, int bodyStart, int bodyEnd) {
        this.name = name;
        this.source = source;
        this.nameStart = nameStart;
        this.bodyStart = bodyStart;
        this.bodyEnd = bodyEnd;
    }

    String getName() {
        return this.name;
    }

    int getNameStart() {
        return this.nameStart;
    }

    int getBodyStart() {
        return this.bodyStart;
    }

    int getBodyEnd() {
        return this.bodyEnd;
    }

    String getSource() {
        return this.source;
    }

    JavaClass getClass(String className) {
        Pattern p;
        Matcher m;
        if (className == null || className.isEmpty()) {
            return null;
        }
        if (className.startsWith("-Lambda-")) {
            return null;
        }
        String cIndex = null;
        String cName = null;
        if (Character.isDigit(className.charAt(0)) && (m = (p = Pattern.compile("(?<index>[\\d]+)(?<name>[\\D]*)")).matcher(className)).matches()) {
            cIndex = m.group("index");
            cName = m.group("name");
            if (cName.isEmpty()) {
                cName = null;
            }
        }
        int searchCount = cName == null ? 1 : Integer.parseInt(cIndex);
        String searchClass = cName == null ? className : cName;
        List<JavaClass> classes = cIndex == null || cName != null ? this.getNamedClasses() : this.getAnonymousClasses();
        for (JavaClass cls : classes) {
            if (!searchClass.equals(cls.getName()) || --searchCount != 0) continue;
            return cls;
        }
        return null;
    }

    private List<JavaClass> getNamedClasses() {
        if (this.namedClasses == null) {
            this.namedClasses = JavaClass.populateNamedClasses(this.source, this.bodyStart, this.bodyEnd);
        }
        return this.namedClasses;
    }

    private List<JavaClass> getAnonymousClasses() {
        if (this.anonymousClasses == null) {
            this.anonymousClasses = JavaClass.populateAnonymousClasses(this.source, this.getNamedClasses(), this.bodyStart, this.bodyEnd);
        }
        return this.anonymousClasses;
    }

    JavaMethod getMethod(String methodName, String methodSignature) {
        return JavaMethod.findMethod(methodName, methodSignature, this);
    }

    public int hashCode() {
        return this.nameStart;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JavaClass)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return ((JavaClass)o).nameStart == this.nameStart;
    }

    public String toString() {
        return "class " + this.name;
    }

    static JavaClass fromSource(String source, String className) {
        List<JavaClass> classes = JavaClass.fromSource(source);
        for (JavaClass cls : classes) {
            if (!className.equals(cls.getName())) continue;
            return cls;
        }
        return null;
    }

    private static List<JavaClass> fromSource(String source) {
        return JavaClass.populateNamedClasses(source, 0, source.length());
    }

    private static List<JavaClass> populateNamedClasses(String source, int startOffset, int endOffset) {
        ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
        Pattern pattern = Pattern.compile("(^|[\\W&&[^.]])(class|interface|enum)\\s+(?<name>\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)[^\\p{javaJavaIdentifierPart}]");
        Matcher matcher = pattern.matcher(source);
        while (startOffset <= endOffset && matcher.find(startOffset)) {
            int offset = matcher.end() - 1;
            String name = matcher.group("name");
            int nameStart = offset - name.length();
            int[] bodyOffsets = JavaSourceUtils.getBlockBounds(source, offset, '{', '}');
            if (bodyOffsets[0] == -1 || bodyOffsets[1] == -1 || bodyOffsets[1] > endOffset) break;
            classes.add(new JavaClass(name, source, nameStart, bodyOffsets[0], bodyOffsets[1]));
            startOffset = bodyOffsets[1] + 1;
        }
        return classes;
    }

    private static List<JavaClass> populateAnonymousClasses(String source, List<JavaClass> innerClasses, int startOffset, int endOffset) {
        ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
        String _source = JavaSourceUtils.maskClasses(source, innerClasses);
        Pattern pattern = Pattern.compile("\\Wnew\\s*(\\s|\\<)");
        Matcher startMatcher = pattern.matcher(_source);
        Matcher endMatcher = null;
        JavaClass.populateAnonymousClassesImpl(_source, classes, startMatcher, endMatcher, startOffset, endOffset);
        System.err.println(">>> Anonymous of " + innerClasses + " -- " + classes);
        return classes;
    }

    private static void populateAnonymousClassesImpl(String source, List<JavaClass> classes, Matcher startMatcher, Matcher endMatcher, int startOffset, int endOffset) {
        while (startOffset <= endOffset && startMatcher.find(startOffset)) {
            startOffset = startMatcher.end();
            if (source.charAt(startOffset - 1) == '<') {
                startOffset = JavaSourceUtils.skipBlock(source, startOffset - 1, '<', '>');
            }
            if (endMatcher == null) {
                Pattern pattern = Pattern.compile("\\G\\s*(?<name>(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\s*");
                endMatcher = pattern.matcher(source);
            }
            if (!endMatcher.find(startOffset)) continue;
            startOffset = endMatcher.end();
            if (source.charAt(startOffset) == '<') {
                startOffset = JavaSourceUtils.skipBlock(source, startOffset, '<', '>');
                startOffset = JavaSourceUtils.skipWhiteSpaces(source, startOffset);
            }
            if (source.charAt(startOffset) == '[') {
                while (source.charAt(startOffset) == '[' && startOffset < endOffset) {
                    startOffset = JavaSourceUtils.skipBlock(source, startOffset, '[', ']');
                }
                startOffset = JavaSourceUtils.skipWhiteSpaces(source, startOffset);
                continue;
            }
            if (source.charAt(startOffset) != '(') continue;
            int[] paramsOffsets = JavaSourceUtils.getBlockBounds(source, startOffset, '(', ')');
            startOffset = paramsOffsets[1] + 1;
            if (source.charAt(startOffset = JavaSourceUtils.skipWhiteSpaces(source, startOffset)) == '{') {
                int[] bodyOffsets = JavaSourceUtils.getBlockBounds(source, startOffset, '{', '}');
                if (bodyOffsets[0] == -1 || bodyOffsets[1] == -1 || bodyOffsets[1] > endOffset) break;
                classes.add(new JavaClass(Integer.toString(classes.size() + 1), source, endMatcher.start("name"), bodyOffsets[0], bodyOffsets[1]));
                startOffset = bodyOffsets[1] + 1;
            }
            if (paramsOffsets[1] - paramsOffsets[0] < JavaSourceUtils.SHORTEST_ANONYMOUS_LENGTH) continue;
            System.err.println(source.substring(paramsOffsets[0] + 1, paramsOffsets[1]));
            JavaClass.populateAnonymousClassesImpl(source, classes, startMatcher, endMatcher, paramsOffsets[0], paramsOffsets[1] - 1);
        }
    }
}

