"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = void 0;
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  chat: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    }),
    trace: _configSchema.schema.boolean({
      defaultValue: true
    }),
    feedback: _configSchema.schema.boolean({
      defaultValue: true
    }),
    allowRenameConversation: _configSchema.schema.boolean({
      defaultValue: true
    }),
    deleteConversation: _configSchema.schema.boolean({
      defaultValue: true
    }),
    regenerateMessage: _configSchema.schema.boolean({
      defaultValue: true
    }),
    showConversationHistory: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  incontextInsight: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  next: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  text2viz: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  alertInsight: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  smartAnomalyDetector: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  branding: _configSchema.schema.object({
    label: _configSchema.schema.maybe(_configSchema.schema.string()),
    logo: _configSchema.schema.maybe(_configSchema.schema.object({
      gradient: _configSchema.schema.maybe(_configSchema.schema.string()),
      gray: _configSchema.schema.maybe(_configSchema.schema.string()),
      white: _configSchema.schema.maybe(_configSchema.schema.string())
    }))
  })
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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