"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleError = void 0;
var _opensearch = require("@opensearch-project/opensearch");
var _errors = require("./errors");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// eslint-disable-next-line @typescript-eslint/no-explicit-any
const handleError = (e, res, logger) => {
  logger.error('Error occurred', e.body || e.message);
  // Handle specific type of Errors
  if (e instanceof _errors.AgentNotFoundError) {
    return res.notFound({
      body: 'Agent not found'
    });
  }

  // handle OpenSearch client connection errors
  if (e instanceof _opensearch.errors.NoLivingConnectionsError || e instanceof _opensearch.errors.ConnectionError) {
    return res.customError({
      body: e.message,
      statusCode: 400
    });
  }

  // handle http response error of calling backend API
  if (e.statusCode) {
    if (e.statusCode >= 400 && e.statusCode <= 499) {
      let message = typeof e.body === 'string' ? e.body : JSON.stringify(e.body);
      if (!message) {
        message = e.message;
      }
      return res.customError({
        body: {
          message: message || 'unknown error'
        },
        statusCode: e.statusCode
      });
    } else {
      return res.customError({
        statusCode: e.statusCode
      });
    }
  }

  // Return an general internalError for unhandled server-side issues
  return res.internalError();
};
exports.handleError = handleError;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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