"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.customStringify = customStringify;
exports.customStringifySingleLine = customStringifySingleLine;
exports.getCharacterLimitedString = getCharacterLimitedString;
exports.isDependentOnModels = isDependentOnModels;
exports.isRAGUseCase = isRAGUseCase;
exports.isVectorSearchUseCase = isVectorSearchUseCase;
exports.prettifyErrorMessage = void 0;
exports.toFormattedDate = toFormattedDate;
var _moment = _interopRequireDefault(require("moment"));
var _ = require("./");
var _lodash = require("lodash");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function toFormattedDate(timestampMillis) {
  return (0, _moment.default)(new Date(timestampMillis)).format(_.DATE_FORMAT_PATTERN);
}
const PERMISSIONS_ERROR_PATTERN = /no permissions for \[(.+)\] and User \[name=(.+), backend_roles/;
const prettifyErrorMessage = rawErrorMessage => {
  if ((0, _lodash.isEmpty)(rawErrorMessage) || rawErrorMessage === 'undefined') {
    return 'Unknown error is returned.';
  }
  const match = rawErrorMessage.match(PERMISSIONS_ERROR_PATTERN);
  if ((0, _lodash.isEmpty)(match)) {
    return rawErrorMessage;
  } else {
    return `User ${match[2]} has no permissions to [${match[1]}].`;
  }
};
exports.prettifyErrorMessage = prettifyErrorMessage;
function getCharacterLimitedString(input, limit) {
  return input !== undefined ? input.length > limit ? input.substring(0, limit - 3) + '...' : input : '';
}
function customStringify(jsonObj) {
  return JSON.stringify(jsonObj, undefined, 2);
}
function customStringifySingleLine(jsonObj) {
  return JSON.stringify(jsonObj, undefined, 0);
}
function isDependentOnModels(workflowType) {
  return isVectorSearchUseCase(workflowType);
}
function isVectorSearchUseCase(workflowType) {
  return workflowType !== undefined && [_.WORKFLOW_TYPE.SEMANTIC_SEARCH, _.WORKFLOW_TYPE.MULTIMODAL_SEARCH, _.WORKFLOW_TYPE.HYBRID_SEARCH, _.WORKFLOW_TYPE.VECTOR_SEARCH_WITH_RAG, _.WORKFLOW_TYPE.HYBRID_SEARCH_WITH_RAG, _.WORKFLOW_TYPE.SEMANTIC_SEARCH_USING_SPARSE_ENCODERS].includes(workflowType);
}
function isRAGUseCase(workflowType) {
  return workflowType !== undefined && [_.WORKFLOW_TYPE.VECTOR_SEARCH_WITH_RAG, _.WORKFLOW_TYPE.HYBRID_SEARCH_WITH_RAG].includes(workflowType);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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