"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOpenSearchClientTransport = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const getOpenSearchClientTransport = async ({
  context,
  dataSourceId
}) => {
  if (dataSourceId && context.dataSource) {
    return (await context.dataSource.opensearch.getClient(dataSourceId)).transport;
  }
  return context.core.opensearch.client.asCurrentUser.transport;
};
exports.getOpenSearchClientTransport = getOpenSearchClientTransport;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJnZXRPcGVuU2VhcmNoQ2xpZW50VHJhbnNwb3J0IiwiY29udGV4dCIsImRhdGFTb3VyY2VJZCIsImRhdGFTb3VyY2UiLCJvcGVuc2VhcmNoIiwiZ2V0Q2xpZW50IiwidHJhbnNwb3J0IiwiY29yZSIsImNsaWVudCIsImFzQ3VycmVudFVzZXIiLCJleHBvcnRzIl0sInNvdXJjZXMiOlsidXRpbHMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBPcGVuU2VhcmNoQ2xpZW50LCBSZXF1ZXN0SGFuZGxlckNvbnRleHQgfSBmcm9tICcuLi8uLi8uLi8uLi9zcmMvY29yZS9zZXJ2ZXInO1xuXG5leHBvcnQgY29uc3QgZ2V0T3BlblNlYXJjaENsaWVudFRyYW5zcG9ydCA9IGFzeW5jICh7XG4gIGNvbnRleHQsXG4gIGRhdGFTb3VyY2VJZCxcbn06IHtcbiAgY29udGV4dDogUmVxdWVzdEhhbmRsZXJDb250ZXh0ICYge1xuICAgIGRhdGFTb3VyY2U/OiB7XG4gICAgICBvcGVuc2VhcmNoOiB7XG4gICAgICAgIGdldENsaWVudDogKGRhdGFTb3VyY2VJZDogc3RyaW5nKSA9PiBQcm9taXNlPE9wZW5TZWFyY2hDbGllbnQ+O1xuICAgICAgfTtcbiAgICB9O1xuICB9O1xuICBkYXRhU291cmNlSWQ/OiBzdHJpbmc7XG59KSA9PiB7XG4gIGlmIChkYXRhU291cmNlSWQgJiYgY29udGV4dC5kYXRhU291cmNlKSB7XG4gICAgcmV0dXJuIChhd2FpdCBjb250ZXh0LmRhdGFTb3VyY2Uub3BlbnNlYXJjaC5nZXRDbGllbnQoZGF0YVNvdXJjZUlkKSkudHJhbnNwb3J0O1xuICB9XG4gIHJldHVybiBjb250ZXh0LmNvcmUub3BlbnNlYXJjaC5jbGllbnQuYXNDdXJyZW50VXNlci50cmFuc3BvcnQ7XG59O1xuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQTtBQUNBO0FBQ0E7QUFDQTs7QUFJTyxNQUFNQSw0QkFBNEIsR0FBRyxNQUFBQSxDQUFPO0VBQ2pEQyxPQUFPO0VBQ1BDO0FBVUYsQ0FBQyxLQUFLO0VBQ0osSUFBSUEsWUFBWSxJQUFJRCxPQUFPLENBQUNFLFVBQVUsRUFBRTtJQUN0QyxPQUFPLENBQUMsTUFBTUYsT0FBTyxDQUFDRSxVQUFVLENBQUNDLFVBQVUsQ0FBQ0MsU0FBUyxDQUFDSCxZQUFZLENBQUMsRUFBRUksU0FBUztFQUNoRjtFQUNBLE9BQU9MLE9BQU8sQ0FBQ00sSUFBSSxDQUFDSCxVQUFVLENBQUNJLE1BQU0sQ0FBQ0MsYUFBYSxDQUFDSCxTQUFTO0FBQy9ELENBQUM7QUFBQ0ksT0FBQSxDQUFBViw0QkFBQSxHQUFBQSw0QkFBQSJ9