"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorService = void 0;
var _constants = require("./utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

class ConnectorService {
  static async search({
    from,
    size,
    transport
  }) {
    let result;
    try {
      result = await transport.request({
        method: 'POST',
        path: _constants.CONNECTOR_SEARCH_API,
        body: {
          query: {
            match_all: {}
          },
          from,
          size
        }
      });
    } catch (e) {
      if (e instanceof Error && e.message.includes('index_not_found_exception')) {
        return {
          data: [],
          total_connectors: 0
        };
      }
      throw e;
    }
    return {
      data: result.body.hits.hits.map(({
        _id,
        _source
      }) => ({
        id: _id,
        ..._source
      })),
      total_connectors: result.body.hits.total.value
    };
  }
  static async getUniqueInternalConnectorNames({
    transport,
    size
  }) {
    let result;
    try {
      result = await transport.request({
        method: 'POST',
        path: _constants.MODEL_SEARCH_API,
        body: {
          size: 0,
          aggs: {
            unique_connector_names: {
              terms: {
                field: 'connector.name.keyword',
                size
              }
            }
          }
        }
      });
    } catch (e) {
      if (e instanceof Error && e.message.includes('index_not_found_exception')) {
        return [];
      }
      throw e;
    }
    if (!result.body.aggregations) {
      return [];
    }
    return result.body.aggregations.unique_connector_names.buckets.map(({
      key
    }) => key);
  }
}
exports.ConnectorService = ConnectorService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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