"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _constants = require("../utils/constants");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class CorrelationService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "acknowledgeCorrelationAlerts", async (context, request, response) => {
      try {
        const params = {
          body: request.body
        };
        const client = this.getClient(request, context);
        const ackCorrelationAlertsResp = await client(_constants.CLIENT_CORRELATION_METHODS.ACK_CORRELATION_ALERTS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: ackCorrelationAlertsResp
          }
        });
      } catch (error) {
        console.error('Security Analytics - CorrelationService - ackCorrelationAlertsResp:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "getAllCorrelationAlerts", async (context, request, response) => {
      try {
        const client = this.getClient(request, context);
        const getCorrelationAlertsResp = await client(_constants.CLIENT_CORRELATION_METHODS.GET_CORRELATION_ALERTS);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getCorrelationAlertsResp
          }
        });
      } catch (error) {
        console.error('Security Analytics - CorrelationService - getCorrelationAlerts:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "createCorrelationRule", async (context, request, response) => {
      try {
        const params = {
          body: request.body
        };
        const client = this.getClient(request, context);
        const createRulesResponse = await client(_constants.CLIENT_CORRELATION_METHODS.CREATE_CORRELATION_RULE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: createRulesResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - CorrelationService - createCorrelationRule:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "updateCorrelationRule", async (context, request, response) => {
      try {
        const {
          ruleId
        } = request.params;
        const params = {
          body: request.body,
          ruleId
        };
        const client = this.getClient(request, context);
        const createRulesResponse = await client(_constants.CLIENT_CORRELATION_METHODS.UPDATE_CORRELATION_RULE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: createRulesResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - CorrelationService - updateCorrelationRule:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    /**
     * Calls backend GET correlation rules API.
     * URL /correlation/rules/_search
     */
    _defineProperty(this, "getCorrelationRules", async (context, request, response) => {
      try {
        const {
          query
        } = request.body;
        const params = {
          body: {
            from: 0,
            size: 10000,
            query
          }
        };
        const client = this.getClient(request, context);
        const getCorrelationsResponse = await client(_constants.CLIENT_CORRELATION_METHODS.GET_CORRELATION_RULES, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getCorrelationsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - CorrelationService - getCorrelationRules:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "deleteCorrelationRule", async (context, request, response) => {
      try {
        const client = this.getClient(request, context);
        const deleteCorrelationRuleResponse = await client(_constants.CLIENT_CORRELATION_METHODS.DELETE_CORRELATION_RULE, request.params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: deleteCorrelationRuleResponse
          }
        });
      } catch (error) {
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "getCorrelatedFindings", async (context, request, response) => {
      try {
        const {
          finding,
          detector_type,
          nearby_findings = 20
        } = request.query;
        const params = {
          finding,
          detector_type,
          nearby_findings
        };
        const client = this.getClient(request, context);
        const getCorrelationFindingsResponse = await client(_constants.CLIENT_CORRELATION_METHODS.GET_CORRELATED_FINDINGS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getCorrelationFindingsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - CorrelationService - getCorrelatedFindings:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "getAllCorrelationsInTimeRange", async (context, request, response) => {
      try {
        const {
          start_time,
          end_time
        } = request.query;
        const params = {
          start_timestamp: start_time,
          end_timestamp: end_time
        };
        const client = this.getClient(request, context);
        const getCorrelationsResponse = await client(_constants.CLIENT_CORRELATION_METHODS.GET_ALL_CORRELATIONS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getCorrelationsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - CorrelationService - getAllCorrelationsInTimeRange:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
  }
}
exports.default = CorrelationService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uc3RhbnRzIiwicmVxdWlyZSIsIl9NRFNFbmFibGVkQ2xpZW50U2VydmljZSIsIl9kZWZpbmVQcm9wZXJ0eSIsImUiLCJyIiwidCIsIl90b1Byb3BlcnR5S2V5IiwiT2JqZWN0IiwiZGVmaW5lUHJvcGVydHkiLCJ2YWx1ZSIsImVudW1lcmFibGUiLCJjb25maWd1cmFibGUiLCJ3cml0YWJsZSIsImkiLCJfdG9QcmltaXRpdmUiLCJTeW1ib2wiLCJ0b1ByaW1pdGl2ZSIsImNhbGwiLCJUeXBlRXJyb3IiLCJTdHJpbmciLCJOdW1iZXIiLCJDb3JyZWxhdGlvblNlcnZpY2UiLCJNRFNFbmFibGVkQ2xpZW50U2VydmljZSIsImNvbnN0cnVjdG9yIiwiYXJncyIsImNvbnRleHQiLCJyZXF1ZXN0IiwicmVzcG9uc2UiLCJwYXJhbXMiLCJib2R5IiwiY2xpZW50IiwiZ2V0Q2xpZW50IiwiYWNrQ29ycmVsYXRpb25BbGVydHNSZXNwIiwiQ0xJRU5UX0NPUlJFTEFUSU9OX01FVEhPRFMiLCJBQ0tfQ09SUkVMQVRJT05fQUxFUlRTIiwiY3VzdG9tIiwic3RhdHVzQ29kZSIsIm9rIiwiZXJyb3IiLCJjb25zb2xlIiwibWVzc2FnZSIsImdldENvcnJlbGF0aW9uQWxlcnRzUmVzcCIsIkdFVF9DT1JSRUxBVElPTl9BTEVSVFMiLCJjcmVhdGVSdWxlc1Jlc3BvbnNlIiwiQ1JFQVRFX0NPUlJFTEFUSU9OX1JVTEUiLCJydWxlSWQiLCJVUERBVEVfQ09SUkVMQVRJT05fUlVMRSIsInF1ZXJ5IiwiZnJvbSIsInNpemUiLCJnZXRDb3JyZWxhdGlvbnNSZXNwb25zZSIsIkdFVF9DT1JSRUxBVElPTl9SVUxFUyIsImRlbGV0ZUNvcnJlbGF0aW9uUnVsZVJlc3BvbnNlIiwiREVMRVRFX0NPUlJFTEFUSU9OX1JVTEUiLCJmaW5kaW5nIiwiZGV0ZWN0b3JfdHlwZSIsIm5lYXJieV9maW5kaW5ncyIsImdldENvcnJlbGF0aW9uRmluZGluZ3NSZXNwb25zZSIsIkdFVF9DT1JSRUxBVEVEX0ZJTkRJTkdTIiwic3RhcnRfdGltZSIsImVuZF90aW1lIiwic3RhcnRfdGltZXN0YW1wIiwiZW5kX3RpbWVzdGFtcCIsIkdFVF9BTExfQ09SUkVMQVRJT05TIiwiZXhwb3J0cyIsImRlZmF1bHQiLCJtb2R1bGUiXSwic291cmNlcyI6WyJDb3JyZWxhdGlvblNlcnZpY2UudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQge1xuICBPcGVuU2VhcmNoRGFzaGJvYXJkc1JlcXVlc3QsXG4gIE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2VGYWN0b3J5LFxuICBJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZSxcbiAgUmVzcG9uc2VFcnJvcixcbiAgUmVxdWVzdEhhbmRsZXJDb250ZXh0LFxufSBmcm9tICdvcGVuc2VhcmNoLWRhc2hib2FyZHMvc2VydmVyJztcbmltcG9ydCB7IENMSUVOVF9DT1JSRUxBVElPTl9NRVRIT0RTIH0gZnJvbSAnLi4vdXRpbHMvY29uc3RhbnRzJztcbmltcG9ydCB7IFNlcnZlclJlc3BvbnNlIH0gZnJvbSAnLi4vbW9kZWxzL3R5cGVzJztcbmltcG9ydCB7XG4gIEdldEFsbENvcnJlbGF0aW9uc0luVGltZVJhbmdlUmVzcG9uc2UsXG4gIEdldENvcnJlbGF0aW9uRmluZGluZ3NQYXJhbXMsXG4gIEdldENvcnJlbGF0aW9uRmluZGluZ3NSZXNwb25zZSxcbiAgU2VhcmNoQ29ycmVsYXRpb25SdWxlc1Jlc3BvbnNlLFxufSBmcm9tICcuLi8uLi90eXBlcyc7XG5pbXBvcnQgeyBNRFNFbmFibGVkQ2xpZW50U2VydmljZSB9IGZyb20gJy4vTURTRW5hYmxlZENsaWVudFNlcnZpY2UnO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBDb3JyZWxhdGlvblNlcnZpY2UgZXh0ZW5kcyBNRFNFbmFibGVkQ2xpZW50U2VydmljZSB7XG5cbiAgYWNrbm93bGVkZ2VDb3JyZWxhdGlvbkFsZXJ0cyA9IGFzeW5jIChcbiAgICBjb250ZXh0OiBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXG4gICAgcmVxdWVzdDogT3BlblNlYXJjaERhc2hib2FyZHNSZXF1ZXN0LFxuICAgIHJlc3BvbnNlOiBPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlRmFjdG9yeVxuICApID0+IHtcbiAgICB0cnkge1xuICAgICAgY29uc3QgcGFyYW1zOiBhbnkgPSB7IGJvZHk6IHJlcXVlc3QuYm9keSB9O1xuICAgICAgY29uc3QgY2xpZW50ID0gdGhpcy5nZXRDbGllbnQocmVxdWVzdCwgY29udGV4dCk7XG4gICAgICBjb25zdCBhY2tDb3JyZWxhdGlvbkFsZXJ0c1Jlc3AgPSBhd2FpdCBjbGllbnQoXG4gICAgICAgIENMSUVOVF9DT1JSRUxBVElPTl9NRVRIT0RTLkFDS19DT1JSRUxBVElPTl9BTEVSVFMsXG4gICAgICAgIHBhcmFtc1xuICAgICAgKTtcbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBvazogdHJ1ZSxcbiAgICAgICAgICByZXNwb25zZTogYWNrQ29ycmVsYXRpb25BbGVydHNSZXNwLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgfSBjYXRjaCAoZXJyb3I6IGFueSkge1xuICAgICAgY29uc29sZS5lcnJvcignU2VjdXJpdHkgQW5hbHl0aWNzIC0gQ29ycmVsYXRpb25TZXJ2aWNlIC0gYWNrQ29ycmVsYXRpb25BbGVydHNSZXNwOicsIGVycm9yKTtcbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBvazogZmFsc2UsXG4gICAgICAgICAgZXJyb3I6IGVycm9yLm1lc3NhZ2UsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9XG4gIH07XG5cbiAgZ2V0QWxsQ29ycmVsYXRpb25BbGVydHMgPSBhc3luYyAoXG4gICAgY29udGV4dDogUmVxdWVzdEhhbmRsZXJDb250ZXh0LFxuICAgIHJlcXVlc3Q6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdCxcbiAgICByZXNwb25zZTogT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnlcbiAgKSA9PiB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IGNsaWVudCA9IHRoaXMuZ2V0Q2xpZW50KHJlcXVlc3QsIGNvbnRleHQpO1xuICAgICAgY29uc3QgZ2V0Q29ycmVsYXRpb25BbGVydHNSZXNwID0gYXdhaXQgY2xpZW50KFxuICAgICAgICBDTElFTlRfQ09SUkVMQVRJT05fTUVUSE9EUy5HRVRfQ09SUkVMQVRJT05fQUxFUlRTLFxuICAgICAgKTtcbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBvazogdHJ1ZSxcbiAgICAgICAgICByZXNwb25zZTogZ2V0Q29ycmVsYXRpb25BbGVydHNSZXNwLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgfSBjYXRjaCAoZXJyb3I6IGFueSkge1xuICAgICAgY29uc29sZS5lcnJvcignU2VjdXJpdHkgQW5hbHl0aWNzIC0gQ29ycmVsYXRpb25TZXJ2aWNlIC0gZ2V0Q29ycmVsYXRpb25BbGVydHM6JywgZXJyb3IpO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiBmYWxzZSxcbiAgICAgICAgICBlcnJvcjogZXJyb3IubWVzc2FnZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH1cbiAgfTtcblxuICBjcmVhdGVDb3JyZWxhdGlvblJ1bGUgPSBhc3luYyAoXG4gICAgY29udGV4dDogUmVxdWVzdEhhbmRsZXJDb250ZXh0LFxuICAgIHJlcXVlc3Q6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdCxcbiAgICByZXNwb25zZTogT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnlcbiAgKSA9PiB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IHBhcmFtczogYW55ID0geyBib2R5OiByZXF1ZXN0LmJvZHkgfTtcbiAgICAgIGNvbnN0IGNsaWVudCA9IHRoaXMuZ2V0Q2xpZW50KHJlcXVlc3QsIGNvbnRleHQpO1xuICAgICAgY29uc3QgY3JlYXRlUnVsZXNSZXNwb25zZSA9IGF3YWl0IGNsaWVudChcbiAgICAgICAgQ0xJRU5UX0NPUlJFTEFUSU9OX01FVEhPRFMuQ1JFQVRFX0NPUlJFTEFUSU9OX1JVTEUsXG4gICAgICAgIHBhcmFtc1xuICAgICAgKTtcbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBvazogdHJ1ZSxcbiAgICAgICAgICByZXNwb25zZTogY3JlYXRlUnVsZXNSZXNwb25zZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH0gY2F0Y2ggKGVycm9yOiBhbnkpIHtcbiAgICAgIGNvbnNvbGUuZXJyb3IoJ1NlY3VyaXR5IEFuYWx5dGljcyAtIENvcnJlbGF0aW9uU2VydmljZSAtIGNyZWF0ZUNvcnJlbGF0aW9uUnVsZTonLCBlcnJvcik7XG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2s6IGZhbHNlLFxuICAgICAgICAgIGVycm9yOiBlcnJvci5tZXNzYWdlLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgfVxuICB9O1xuXG4gIHVwZGF0ZUNvcnJlbGF0aW9uUnVsZSA9IGFzeW5jIChcbiAgICBjb250ZXh0OiBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXG4gICAgcmVxdWVzdDogT3BlblNlYXJjaERhc2hib2FyZHNSZXF1ZXN0LFxuICAgIHJlc3BvbnNlOiBPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlRmFjdG9yeVxuICApID0+IHtcbiAgICB0cnkge1xuICAgICAgY29uc3QgeyBydWxlSWQgfSA9IHJlcXVlc3QucGFyYW1zIGFzIHsgcnVsZUlkOiBzdHJpbmcgfTtcbiAgICAgIGNvbnN0IHBhcmFtczogYW55ID0geyBib2R5OiByZXF1ZXN0LmJvZHksIHJ1bGVJZCB9O1xuICAgICAgY29uc3QgY2xpZW50ID0gdGhpcy5nZXRDbGllbnQocmVxdWVzdCwgY29udGV4dCk7XG4gICAgICBjb25zdCBjcmVhdGVSdWxlc1Jlc3BvbnNlID0gYXdhaXQgY2xpZW50KFxuICAgICAgICBDTElFTlRfQ09SUkVMQVRJT05fTUVUSE9EUy5VUERBVEVfQ09SUkVMQVRJT05fUlVMRSxcbiAgICAgICAgcGFyYW1zXG4gICAgICApO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiB0cnVlLFxuICAgICAgICAgIHJlc3BvbnNlOiBjcmVhdGVSdWxlc1Jlc3BvbnNlLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgfSBjYXRjaCAoZXJyb3I6IGFueSkge1xuICAgICAgY29uc29sZS5lcnJvcignU2VjdXJpdHkgQW5hbHl0aWNzIC0gQ29ycmVsYXRpb25TZXJ2aWNlIC0gdXBkYXRlQ29ycmVsYXRpb25SdWxlOicsIGVycm9yKTtcbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBvazogZmFsc2UsXG4gICAgICAgICAgZXJyb3I6IGVycm9yLm1lc3NhZ2UsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9XG4gIH07XG5cbiAgLyoqXG4gICAqIENhbGxzIGJhY2tlbmQgR0VUIGNvcnJlbGF0aW9uIHJ1bGVzIEFQSS5cbiAgICogVVJMIC9jb3JyZWxhdGlvbi9ydWxlcy9fc2VhcmNoXG4gICAqL1xuICBnZXRDb3JyZWxhdGlvblJ1bGVzID0gYXN5bmMgKFxuICAgIGNvbnRleHQ6IFJlcXVlc3RIYW5kbGVyQ29udGV4dCxcbiAgICByZXF1ZXN0OiBPcGVuU2VhcmNoRGFzaGJvYXJkc1JlcXVlc3QsXG4gICAgcmVzcG9uc2U6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2VGYWN0b3J5XG4gICk6IFByb21pc2U8XG4gICAgSU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2U8U2VydmVyUmVzcG9uc2U8U2VhcmNoQ29ycmVsYXRpb25SdWxlc1Jlc3BvbnNlPiB8IFJlc3BvbnNlRXJyb3I+XG4gID4gPT4ge1xuICAgIHRyeSB7XG4gICAgICBjb25zdCB7IHF1ZXJ5IH0gPSByZXF1ZXN0LmJvZHkgYXMgeyBxdWVyeTogb2JqZWN0IH07XG4gICAgICBjb25zdCBwYXJhbXM6IGFueSA9IHsgYm9keTogeyBmcm9tOiAwLCBzaXplOiAxMDAwMCwgcXVlcnkgfSB9O1xuICAgICAgY29uc3QgY2xpZW50ID0gdGhpcy5nZXRDbGllbnQocmVxdWVzdCwgY29udGV4dCk7XG4gICAgICBjb25zdCBnZXRDb3JyZWxhdGlvbnNSZXNwb25zZTogU2VhcmNoQ29ycmVsYXRpb25SdWxlc1Jlc3BvbnNlID0gYXdhaXQgY2xpZW50KFxuICAgICAgICBDTElFTlRfQ09SUkVMQVRJT05fTUVUSE9EUy5HRVRfQ09SUkVMQVRJT05fUlVMRVMsXG4gICAgICAgIHBhcmFtc1xuICAgICAgKTtcblxuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiB0cnVlLFxuICAgICAgICAgIHJlc3BvbnNlOiBnZXRDb3JyZWxhdGlvbnNSZXNwb25zZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH0gY2F0Y2ggKGVycm9yOiBhbnkpIHtcbiAgICAgIGNvbnNvbGUuZXJyb3IoJ1NlY3VyaXR5IEFuYWx5dGljcyAtIENvcnJlbGF0aW9uU2VydmljZSAtIGdldENvcnJlbGF0aW9uUnVsZXM6JywgZXJyb3IpO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiBmYWxzZSxcbiAgICAgICAgICBlcnJvcjogZXJyb3IubWVzc2FnZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH1cbiAgfTtcblxuICBkZWxldGVDb3JyZWxhdGlvblJ1bGUgPSBhc3luYyAoXG4gICAgY29udGV4dDogUmVxdWVzdEhhbmRsZXJDb250ZXh0LFxuICAgIHJlcXVlc3Q6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdDx7fSwgR2V0Q29ycmVsYXRpb25GaW5kaW5nc1BhcmFtcz4sXG4gICAgcmVzcG9uc2U6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2VGYWN0b3J5XG4gICkgPT4ge1xuICAgIHRyeSB7XG4gICAgICBjb25zdCBjbGllbnQgPSB0aGlzLmdldENsaWVudChyZXF1ZXN0LCBjb250ZXh0KTtcbiAgICAgIGNvbnN0IGRlbGV0ZUNvcnJlbGF0aW9uUnVsZVJlc3BvbnNlID0gYXdhaXQgY2xpZW50KFxuICAgICAgICBDTElFTlRfQ09SUkVMQVRJT05fTUVUSE9EUy5ERUxFVEVfQ09SUkVMQVRJT05fUlVMRSxcbiAgICAgICAgcmVxdWVzdC5wYXJhbXNcbiAgICAgICk7XG5cbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBvazogdHJ1ZSxcbiAgICAgICAgICByZXNwb25zZTogZGVsZXRlQ29ycmVsYXRpb25SdWxlUmVzcG9uc2UsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9IGNhdGNoIChlcnJvcjogYW55KSB7XG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2s6IGZhbHNlLFxuICAgICAgICAgIGVycm9yOiBlcnJvci5tZXNzYWdlLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgfVxuICB9O1xuXG4gIGdldENvcnJlbGF0ZWRGaW5kaW5ncyA9IGFzeW5jIChcbiAgICBjb250ZXh0OiBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXG4gICAgcmVxdWVzdDogT3BlblNlYXJjaERhc2hib2FyZHNSZXF1ZXN0PHVua25vd24sIGFueT4sXG4gICAgcmVzcG9uc2U6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2VGYWN0b3J5XG4gICk6IFByb21pc2U8XG4gICAgSU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2U8U2VydmVyUmVzcG9uc2U8R2V0Q29ycmVsYXRpb25GaW5kaW5nc1Jlc3BvbnNlPiB8IFJlc3BvbnNlRXJyb3I+XG4gID4gPT4ge1xuICAgIHRyeSB7XG4gICAgICBjb25zdCB7IGZpbmRpbmcsIGRldGVjdG9yX3R5cGUsIG5lYXJieV9maW5kaW5ncyA9IDIwIH0gPSByZXF1ZXN0LnF1ZXJ5O1xuICAgICAgY29uc3QgcGFyYW1zOiBhbnkgPSB7IGZpbmRpbmcsIGRldGVjdG9yX3R5cGUsIG5lYXJieV9maW5kaW5ncyB9O1xuICAgICAgY29uc3QgY2xpZW50ID0gdGhpcy5nZXRDbGllbnQocmVxdWVzdCwgY29udGV4dCk7XG4gICAgICBjb25zdCBnZXRDb3JyZWxhdGlvbkZpbmRpbmdzUmVzcG9uc2U6IEdldENvcnJlbGF0aW9uRmluZGluZ3NSZXNwb25zZSA9IGF3YWl0IGNsaWVudChcbiAgICAgICAgQ0xJRU5UX0NPUlJFTEFUSU9OX01FVEhPRFMuR0VUX0NPUlJFTEFURURfRklORElOR1MsXG4gICAgICAgIHBhcmFtc1xuICAgICAgKTtcblxuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiB0cnVlLFxuICAgICAgICAgIHJlc3BvbnNlOiBnZXRDb3JyZWxhdGlvbkZpbmRpbmdzUmVzcG9uc2UsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9IGNhdGNoIChlcnJvcjogYW55KSB7XG4gICAgICBjb25zb2xlLmVycm9yKCdTZWN1cml0eSBBbmFseXRpY3MgLSBDb3JyZWxhdGlvblNlcnZpY2UgLSBnZXRDb3JyZWxhdGVkRmluZGluZ3M6JywgZXJyb3IpO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiBmYWxzZSxcbiAgICAgICAgICBlcnJvcjogZXJyb3IubWVzc2FnZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH1cbiAgfTtcblxuICBnZXRBbGxDb3JyZWxhdGlvbnNJblRpbWVSYW5nZSA9IGFzeW5jIChcbiAgICBjb250ZXh0OiBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXG4gICAgcmVxdWVzdDogT3BlblNlYXJjaERhc2hib2FyZHNSZXF1ZXN0PHVua25vd24sIHsgc3RhcnRfdGltZTogc3RyaW5nOyBlbmRfdGltZTogc3RyaW5nIH0+LFxuICAgIHJlc3BvbnNlOiBPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlRmFjdG9yeVxuICApOiBQcm9taXNlPFxuICAgIElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPFxuICAgICAgU2VydmVyUmVzcG9uc2U8R2V0QWxsQ29ycmVsYXRpb25zSW5UaW1lUmFuZ2VSZXNwb25zZT4gfCBSZXNwb25zZUVycm9yXG4gICAgPlxuICA+ID0+IHtcbiAgICB0cnkge1xuICAgICAgY29uc3QgeyBzdGFydF90aW1lLCBlbmRfdGltZSB9ID0gcmVxdWVzdC5xdWVyeTtcbiAgICAgIGNvbnN0IHBhcmFtczogYW55ID0geyBzdGFydF90aW1lc3RhbXA6IHN0YXJ0X3RpbWUsIGVuZF90aW1lc3RhbXA6IGVuZF90aW1lIH07XG4gICAgICBjb25zdCBjbGllbnQgPSB0aGlzLmdldENsaWVudChyZXF1ZXN0LCBjb250ZXh0KTtcbiAgICAgIGNvbnN0IGdldENvcnJlbGF0aW9uc1Jlc3BvbnNlOiBHZXRBbGxDb3JyZWxhdGlvbnNJblRpbWVSYW5nZVJlc3BvbnNlID0gYXdhaXQgY2xpZW50KFxuICAgICAgICBDTElFTlRfQ09SUkVMQVRJT05fTUVUSE9EUy5HRVRfQUxMX0NPUlJFTEFUSU9OUyxcbiAgICAgICAgcGFyYW1zXG4gICAgICApO1xuXG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2s6IHRydWUsXG4gICAgICAgICAgcmVzcG9uc2U6IGdldENvcnJlbGF0aW9uc1Jlc3BvbnNlLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgfSBjYXRjaCAoZXJyb3I6IGFueSkge1xuICAgICAgY29uc29sZS5lcnJvcihcbiAgICAgICAgJ1NlY3VyaXR5IEFuYWx5dGljcyAtIENvcnJlbGF0aW9uU2VydmljZSAtIGdldEFsbENvcnJlbGF0aW9uc0luVGltZVJhbmdlOicsXG4gICAgICAgIGVycm9yXG4gICAgICApO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiBmYWxzZSxcbiAgICAgICAgICBlcnJvcjogZXJyb3IubWVzc2FnZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH1cbiAgfTtcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBWUEsSUFBQUEsVUFBQSxHQUFBQyxPQUFBO0FBUUEsSUFBQUMsd0JBQUEsR0FBQUQsT0FBQTtBQUFvRSxTQUFBRSxnQkFBQUMsQ0FBQSxFQUFBQyxDQUFBLEVBQUFDLENBQUEsWUFBQUQsQ0FBQSxHQUFBRSxjQUFBLENBQUFGLENBQUEsTUFBQUQsQ0FBQSxHQUFBSSxNQUFBLENBQUFDLGNBQUEsQ0FBQUwsQ0FBQSxFQUFBQyxDQUFBLElBQUFLLEtBQUEsRUFBQUosQ0FBQSxFQUFBSyxVQUFBLE1BQUFDLFlBQUEsTUFBQUMsUUFBQSxVQUFBVCxDQUFBLENBQUFDLENBQUEsSUFBQUMsQ0FBQSxFQUFBRixDQUFBO0FBQUEsU0FBQUcsZUFBQUQsQ0FBQSxRQUFBUSxDQUFBLEdBQUFDLFlBQUEsQ0FBQVQsQ0FBQSx1Q0FBQVEsQ0FBQSxHQUFBQSxDQUFBLEdBQUFBLENBQUE7QUFBQSxTQUFBQyxhQUFBVCxDQUFBLEVBQUFELENBQUEsMkJBQUFDLENBQUEsS0FBQUEsQ0FBQSxTQUFBQSxDQUFBLE1BQUFGLENBQUEsR0FBQUUsQ0FBQSxDQUFBVSxNQUFBLENBQUFDLFdBQUEsa0JBQUFiLENBQUEsUUFBQVUsQ0FBQSxHQUFBVixDQUFBLENBQUFjLElBQUEsQ0FBQVosQ0FBQSxFQUFBRCxDQUFBLHVDQUFBUyxDQUFBLFNBQUFBLENBQUEsWUFBQUssU0FBQSx5RUFBQWQsQ0FBQSxHQUFBZSxNQUFBLEdBQUFDLE1BQUEsRUFBQWYsQ0FBQSxLQXBCcEU7QUFDQTtBQUNBO0FBQ0E7QUFtQmUsTUFBTWdCLGtCQUFrQixTQUFTQyxnREFBdUIsQ0FBQztFQUFBQyxZQUFBLEdBQUFDLElBQUE7SUFBQSxTQUFBQSxJQUFBO0lBQUF0QixlQUFBLHVDQUV2QyxPQUM3QnVCLE9BQThCLEVBQzlCQyxPQUFvQyxFQUNwQ0MsUUFBNkMsS0FDMUM7TUFDSCxJQUFJO1FBQ0YsTUFBTUMsTUFBVyxHQUFHO1VBQUVDLElBQUksRUFBRUgsT0FBTyxDQUFDRztRQUFLLENBQUM7UUFDMUMsTUFBTUMsTUFBTSxHQUFHLElBQUksQ0FBQ0MsU0FBUyxDQUFDTCxPQUFPLEVBQUVELE9BQU8sQ0FBQztRQUMvQyxNQUFNTyx3QkFBd0IsR0FBRyxNQUFNRixNQUFNLENBQzNDRyxxQ0FBMEIsQ0FBQ0Msc0JBQXNCLEVBQ2pETixNQUNGLENBQUM7UUFDRCxPQUFPRCxRQUFRLENBQUNRLE1BQU0sQ0FBQztVQUNyQkMsVUFBVSxFQUFFLEdBQUc7VUFDZlAsSUFBSSxFQUFFO1lBQ0pRLEVBQUUsRUFBRSxJQUFJO1lBQ1JWLFFBQVEsRUFBRUs7VUFDWjtRQUNGLENBQUMsQ0FBQztNQUNKLENBQUMsQ0FBQyxPQUFPTSxLQUFVLEVBQUU7UUFDbkJDLE9BQU8sQ0FBQ0QsS0FBSyxDQUFDLHFFQUFxRSxFQUFFQSxLQUFLLENBQUM7UUFDM0YsT0FBT1gsUUFBUSxDQUFDUSxNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZQLElBQUksRUFBRTtZQUNKUSxFQUFFLEVBQUUsS0FBSztZQUNUQyxLQUFLLEVBQUVBLEtBQUssQ0FBQ0U7VUFDZjtRQUNGLENBQUMsQ0FBQztNQUNKO0lBQ0YsQ0FBQztJQUFBdEMsZUFBQSxrQ0FFeUIsT0FDeEJ1QixPQUE4QixFQUM5QkMsT0FBb0MsRUFDcENDLFFBQTZDLEtBQzFDO01BQ0gsSUFBSTtRQUNGLE1BQU1HLE1BQU0sR0FBRyxJQUFJLENBQUNDLFNBQVMsQ0FBQ0wsT0FBTyxFQUFFRCxPQUFPLENBQUM7UUFDL0MsTUFBTWdCLHdCQUF3QixHQUFHLE1BQU1YLE1BQU0sQ0FDM0NHLHFDQUEwQixDQUFDUyxzQkFDN0IsQ0FBQztRQUNELE9BQU9mLFFBQVEsQ0FBQ1EsTUFBTSxDQUFDO1VBQ3JCQyxVQUFVLEVBQUUsR0FBRztVQUNmUCxJQUFJLEVBQUU7WUFDSlEsRUFBRSxFQUFFLElBQUk7WUFDUlYsUUFBUSxFQUFFYztVQUNaO1FBQ0YsQ0FBQyxDQUFDO01BQ0osQ0FBQyxDQUFDLE9BQU9ILEtBQVUsRUFBRTtRQUNuQkMsT0FBTyxDQUFDRCxLQUFLLENBQUMsaUVBQWlFLEVBQUVBLEtBQUssQ0FBQztRQUN2RixPQUFPWCxRQUFRLENBQUNRLE1BQU0sQ0FBQztVQUNyQkMsVUFBVSxFQUFFLEdBQUc7VUFDZlAsSUFBSSxFQUFFO1lBQ0pRLEVBQUUsRUFBRSxLQUFLO1lBQ1RDLEtBQUssRUFBRUEsS0FBSyxDQUFDRTtVQUNmO1FBQ0YsQ0FBQyxDQUFDO01BQ0o7SUFDRixDQUFDO0lBQUF0QyxlQUFBLGdDQUV1QixPQUN0QnVCLE9BQThCLEVBQzlCQyxPQUFvQyxFQUNwQ0MsUUFBNkMsS0FDMUM7TUFDSCxJQUFJO1FBQ0YsTUFBTUMsTUFBVyxHQUFHO1VBQUVDLElBQUksRUFBRUgsT0FBTyxDQUFDRztRQUFLLENBQUM7UUFDMUMsTUFBTUMsTUFBTSxHQUFHLElBQUksQ0FBQ0MsU0FBUyxDQUFDTCxPQUFPLEVBQUVELE9BQU8sQ0FBQztRQUMvQyxNQUFNa0IsbUJBQW1CLEdBQUcsTUFBTWIsTUFBTSxDQUN0Q0cscUNBQTBCLENBQUNXLHVCQUF1QixFQUNsRGhCLE1BQ0YsQ0FBQztRQUNELE9BQU9ELFFBQVEsQ0FBQ1EsTUFBTSxDQUFDO1VBQ3JCQyxVQUFVLEVBQUUsR0FBRztVQUNmUCxJQUFJLEVBQUU7WUFDSlEsRUFBRSxFQUFFLElBQUk7WUFDUlYsUUFBUSxFQUFFZ0I7VUFDWjtRQUNGLENBQUMsQ0FBQztNQUNKLENBQUMsQ0FBQyxPQUFPTCxLQUFVLEVBQUU7UUFDbkJDLE9BQU8sQ0FBQ0QsS0FBSyxDQUFDLGtFQUFrRSxFQUFFQSxLQUFLLENBQUM7UUFDeEYsT0FBT1gsUUFBUSxDQUFDUSxNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZQLElBQUksRUFBRTtZQUNKUSxFQUFFLEVBQUUsS0FBSztZQUNUQyxLQUFLLEVBQUVBLEtBQUssQ0FBQ0U7VUFDZjtRQUNGLENBQUMsQ0FBQztNQUNKO0lBQ0YsQ0FBQztJQUFBdEMsZUFBQSxnQ0FFdUIsT0FDdEJ1QixPQUE4QixFQUM5QkMsT0FBb0MsRUFDcENDLFFBQTZDLEtBQzFDO01BQ0gsSUFBSTtRQUNGLE1BQU07VUFBRWtCO1FBQU8sQ0FBQyxHQUFHbkIsT0FBTyxDQUFDRSxNQUE0QjtRQUN2RCxNQUFNQSxNQUFXLEdBQUc7VUFBRUMsSUFBSSxFQUFFSCxPQUFPLENBQUNHLElBQUk7VUFBRWdCO1FBQU8sQ0FBQztRQUNsRCxNQUFNZixNQUFNLEdBQUcsSUFBSSxDQUFDQyxTQUFTLENBQUNMLE9BQU8sRUFBRUQsT0FBTyxDQUFDO1FBQy9DLE1BQU1rQixtQkFBbUIsR0FBRyxNQUFNYixNQUFNLENBQ3RDRyxxQ0FBMEIsQ0FBQ2EsdUJBQXVCLEVBQ2xEbEIsTUFDRixDQUFDO1FBQ0QsT0FBT0QsUUFBUSxDQUFDUSxNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZQLElBQUksRUFBRTtZQUNKUSxFQUFFLEVBQUUsSUFBSTtZQUNSVixRQUFRLEVBQUVnQjtVQUNaO1FBQ0YsQ0FBQyxDQUFDO01BQ0osQ0FBQyxDQUFDLE9BQU9MLEtBQVUsRUFBRTtRQUNuQkMsT0FBTyxDQUFDRCxLQUFLLENBQUMsa0VBQWtFLEVBQUVBLEtBQUssQ0FBQztRQUN4RixPQUFPWCxRQUFRLENBQUNRLE1BQU0sQ0FBQztVQUNyQkMsVUFBVSxFQUFFLEdBQUc7VUFDZlAsSUFBSSxFQUFFO1lBQ0pRLEVBQUUsRUFBRSxLQUFLO1lBQ1RDLEtBQUssRUFBRUEsS0FBSyxDQUFDRTtVQUNmO1FBQ0YsQ0FBQyxDQUFDO01BQ0o7SUFDRixDQUFDO0lBRUQ7QUFDRjtBQUNBO0FBQ0E7SUFIRXRDLGVBQUEsOEJBSXNCLE9BQ3BCdUIsT0FBOEIsRUFDOUJDLE9BQW9DLEVBQ3BDQyxRQUE2QyxLQUcxQztNQUNILElBQUk7UUFDRixNQUFNO1VBQUVvQjtRQUFNLENBQUMsR0FBR3JCLE9BQU8sQ0FBQ0csSUFBeUI7UUFDbkQsTUFBTUQsTUFBVyxHQUFHO1VBQUVDLElBQUksRUFBRTtZQUFFbUIsSUFBSSxFQUFFLENBQUM7WUFBRUMsSUFBSSxFQUFFLEtBQUs7WUFBRUY7VUFBTTtRQUFFLENBQUM7UUFDN0QsTUFBTWpCLE1BQU0sR0FBRyxJQUFJLENBQUNDLFNBQVMsQ0FBQ0wsT0FBTyxFQUFFRCxPQUFPLENBQUM7UUFDL0MsTUFBTXlCLHVCQUF1RCxHQUFHLE1BQU1wQixNQUFNLENBQzFFRyxxQ0FBMEIsQ0FBQ2tCLHFCQUFxQixFQUNoRHZCLE1BQ0YsQ0FBQztRQUVELE9BQU9ELFFBQVEsQ0FBQ1EsTUFBTSxDQUFDO1VBQ3JCQyxVQUFVLEVBQUUsR0FBRztVQUNmUCxJQUFJLEVBQUU7WUFDSlEsRUFBRSxFQUFFLElBQUk7WUFDUlYsUUFBUSxFQUFFdUI7VUFDWjtRQUNGLENBQUMsQ0FBQztNQUNKLENBQUMsQ0FBQyxPQUFPWixLQUFVLEVBQUU7UUFDbkJDLE9BQU8sQ0FBQ0QsS0FBSyxDQUFDLGdFQUFnRSxFQUFFQSxLQUFLLENBQUM7UUFDdEYsT0FBT1gsUUFBUSxDQUFDUSxNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZQLElBQUksRUFBRTtZQUNKUSxFQUFFLEVBQUUsS0FBSztZQUNUQyxLQUFLLEVBQUVBLEtBQUssQ0FBQ0U7VUFDZjtRQUNGLENBQUMsQ0FBQztNQUNKO0lBQ0YsQ0FBQztJQUFBdEMsZUFBQSxnQ0FFdUIsT0FDdEJ1QixPQUE4QixFQUM5QkMsT0FBc0UsRUFDdEVDLFFBQTZDLEtBQzFDO01BQ0gsSUFBSTtRQUNGLE1BQU1HLE1BQU0sR0FBRyxJQUFJLENBQUNDLFNBQVMsQ0FBQ0wsT0FBTyxFQUFFRCxPQUFPLENBQUM7UUFDL0MsTUFBTTJCLDZCQUE2QixHQUFHLE1BQU10QixNQUFNLENBQ2hERyxxQ0FBMEIsQ0FBQ29CLHVCQUF1QixFQUNsRDNCLE9BQU8sQ0FBQ0UsTUFDVixDQUFDO1FBRUQsT0FBT0QsUUFBUSxDQUFDUSxNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZQLElBQUksRUFBRTtZQUNKUSxFQUFFLEVBQUUsSUFBSTtZQUNSVixRQUFRLEVBQUV5QjtVQUNaO1FBQ0YsQ0FBQyxDQUFDO01BQ0osQ0FBQyxDQUFDLE9BQU9kLEtBQVUsRUFBRTtRQUNuQixPQUFPWCxRQUFRLENBQUNRLE1BQU0sQ0FBQztVQUNyQkMsVUFBVSxFQUFFLEdBQUc7VUFDZlAsSUFBSSxFQUFFO1lBQ0pRLEVBQUUsRUFBRSxLQUFLO1lBQ1RDLEtBQUssRUFBRUEsS0FBSyxDQUFDRTtVQUNmO1FBQ0YsQ0FBQyxDQUFDO01BQ0o7SUFDRixDQUFDO0lBQUF0QyxlQUFBLGdDQUV1QixPQUN0QnVCLE9BQThCLEVBQzlCQyxPQUFrRCxFQUNsREMsUUFBNkMsS0FHMUM7TUFDSCxJQUFJO1FBQ0YsTUFBTTtVQUFFMkIsT0FBTztVQUFFQyxhQUFhO1VBQUVDLGVBQWUsR0FBRztRQUFHLENBQUMsR0FBRzlCLE9BQU8sQ0FBQ3FCLEtBQUs7UUFDdEUsTUFBTW5CLE1BQVcsR0FBRztVQUFFMEIsT0FBTztVQUFFQyxhQUFhO1VBQUVDO1FBQWdCLENBQUM7UUFDL0QsTUFBTTFCLE1BQU0sR0FBRyxJQUFJLENBQUNDLFNBQVMsQ0FBQ0wsT0FBTyxFQUFFRCxPQUFPLENBQUM7UUFDL0MsTUFBTWdDLDhCQUE4RCxHQUFHLE1BQU0zQixNQUFNLENBQ2pGRyxxQ0FBMEIsQ0FBQ3lCLHVCQUF1QixFQUNsRDlCLE1BQ0YsQ0FBQztRQUVELE9BQU9ELFFBQVEsQ0FBQ1EsTUFBTSxDQUFDO1VBQ3JCQyxVQUFVLEVBQUUsR0FBRztVQUNmUCxJQUFJLEVBQUU7WUFDSlEsRUFBRSxFQUFFLElBQUk7WUFDUlYsUUFBUSxFQUFFOEI7VUFDWjtRQUNGLENBQUMsQ0FBQztNQUNKLENBQUMsQ0FBQyxPQUFPbkIsS0FBVSxFQUFFO1FBQ25CQyxPQUFPLENBQUNELEtBQUssQ0FBQyxrRUFBa0UsRUFBRUEsS0FBSyxDQUFDO1FBQ3hGLE9BQU9YLFFBQVEsQ0FBQ1EsTUFBTSxDQUFDO1VBQ3JCQyxVQUFVLEVBQUUsR0FBRztVQUNmUCxJQUFJLEVBQUU7WUFDSlEsRUFBRSxFQUFFLEtBQUs7WUFDVEMsS0FBSyxFQUFFQSxLQUFLLENBQUNFO1VBQ2Y7UUFDRixDQUFDLENBQUM7TUFDSjtJQUNGLENBQUM7SUFBQXRDLGVBQUEsd0NBRStCLE9BQzlCdUIsT0FBOEIsRUFDOUJDLE9BQXVGLEVBQ3ZGQyxRQUE2QyxLQUsxQztNQUNILElBQUk7UUFDRixNQUFNO1VBQUVnQyxVQUFVO1VBQUVDO1FBQVMsQ0FBQyxHQUFHbEMsT0FBTyxDQUFDcUIsS0FBSztRQUM5QyxNQUFNbkIsTUFBVyxHQUFHO1VBQUVpQyxlQUFlLEVBQUVGLFVBQVU7VUFBRUcsYUFBYSxFQUFFRjtRQUFTLENBQUM7UUFDNUUsTUFBTTlCLE1BQU0sR0FBRyxJQUFJLENBQUNDLFNBQVMsQ0FBQ0wsT0FBTyxFQUFFRCxPQUFPLENBQUM7UUFDL0MsTUFBTXlCLHVCQUE4RCxHQUFHLE1BQU1wQixNQUFNLENBQ2pGRyxxQ0FBMEIsQ0FBQzhCLG9CQUFvQixFQUMvQ25DLE1BQ0YsQ0FBQztRQUVELE9BQU9ELFFBQVEsQ0FBQ1EsTUFBTSxDQUFDO1VBQ3JCQyxVQUFVLEVBQUUsR0FBRztVQUNmUCxJQUFJLEVBQUU7WUFDSlEsRUFBRSxFQUFFLElBQUk7WUFDUlYsUUFBUSxFQUFFdUI7VUFDWjtRQUNGLENBQUMsQ0FBQztNQUNKLENBQUMsQ0FBQyxPQUFPWixLQUFVLEVBQUU7UUFDbkJDLE9BQU8sQ0FBQ0QsS0FBSyxDQUNYLDBFQUEwRSxFQUMxRUEsS0FDRixDQUFDO1FBQ0QsT0FBT1gsUUFBUSxDQUFDUSxNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZQLElBQUksRUFBRTtZQUNKUSxFQUFFLEVBQUUsS0FBSztZQUNUQyxLQUFLLEVBQUVBLEtBQUssQ0FBQ0U7VUFDZjtRQUNGLENBQUMsQ0FBQztNQUNKO0lBQ0YsQ0FBQztFQUFBO0FBQ0g7QUFBQ3dCLE9BQUEsQ0FBQUMsT0FBQSxHQUFBNUMsa0JBQUE7QUFBQTZDLE1BQUEsQ0FBQUYsT0FBQSxHQUFBQSxPQUFBLENBQUFDLE9BQUEifQ==