.\" Copyright (C) 1989-95 GROUPE BULL
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a copy
.\" of this software and associated documentation files (the "Software"), to
.\" deal in the Software without restriction, including without limitation the
.\" rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
.\" sell copies of the Software, and to permit persons to whom the Software is
.\" furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
.\" GROUPE BULL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
.\" AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
.\" CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of GROUPE BULL shall not be
.\" used in advertising or otherwise to promote the sale, use or other dealings
.\" in this Software without prior written authorization from GROUPE BULL.
.\"
.hw XImage
.TH  XpmCreatePixmap __libmansuffix__ __xorgversion__ "libXpm functions"
.SH NAME
XpmCreatePixmap \- create a pixmap
.SH SYNOPSIS
.nf
.HP
.BI "int XpmCreatePixmapFromData(Display *" display ", Drawable " d ,
.BI "char **" data ", Pixmap *" pixmap_return ", Pixmap *" shapemask_return ,
.BI "XpmAttributes *" attributes );
.HP
.BI "int XpmCreatePixmapFromBuffer(Display *" display ", Drawable " d ,
.BI "char *" buffer ", Pixmap *" pixmap_return ", Pixmap *" shapemask_return ,
.BI "XpmAttributes *" attributes );
.HP
.BI "int XpmCreatePixmapFromXpmImage(Display *" display ", Drawable " d ,
.BI "XpmImage *" image ", Pixmap *" pixmap_return ", Pixmap *" shapemask_return ,
.BI "XpmAttributes *" attributes );
.fi

.SH ARGUMENTS

.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fId\fP 1i
Specifies which screen the pixmap is created on.
.IP \fIbuffer\fP 1i
Specifies the location of the buffer.
.IP \fIpixmap_return\fP 1i
Returns the pixmap which is created if the color None.
.IP \fIshapemask_return\fP 1i
Returns the shape mask pixmap which is created if the color None is used.
.IP \fIattributes\fP 1i
Specifies the location of a structure to get and store information.
.IP \fIimage\fP 1i
Specifies the XpmImage.

.SH DESCRIPTION
.SS XpmCreatePixmapFromData
To create a Pixmap from an XPM data, use
.BR XpmCreatePixmapFromData ().
The
.BR XpmCreatePixmapFromData ()
function creates X images using
.BR XpmCreateImageFromData (__libmansuffix__)
and thus returns the same errors.
In addition on success it then creates the related pixmaps, using
.BR XPutImage (__libmansuffix__),
which are returned to
.I pixmap_return
and
.I shapemask_return
if not NULL, and finally destroys the created images using
.BR XDestroyImage (__libmansuffix__).
Do not forget to free the returned pixmaps, the colors,
and possibly the data returned into the XpmAttributes structure when done.

.SS XpmCreatePixmapFromBuffer
To create a Pixmap from an XPM buffer, use
.BR XpmCreatePixmapFromBuffer ().
The
.BR XpmCreatePixmapFromBuffer ()
function works the same way as
.BR XpmReadFileToPixmap (__libmansuffix__),
it just calls
.BR XpmCreateImageFromBuffer (__libmansuffix__)
instead of
.BR XpmReadFileToImage (__libmansuffix__).

.SS XpmCreatePixmapFromXpmImage
.BR XpmCreatePixmapFromXpmImage ()
creates X images calling
.BR XpmCreateImageFromXpmImage (__libmansuffix__)
with the given XpmImage and XpmAttributes,
then it creates the related pixmaps which are returned to
.I pixmap_return
and
.I shapemask_return
using
.BR XPutImage (__libmansuffix__).
Finally it destroys the X images with
.BR XDestroyImage (__libmansuffix__).
When finished the caller must free the pixmaps using
.BR XFreePixmap (__libmansuffix__),
the colors using
.BR XFreeColors (__libmansuffix__)
or the application equivalent function when the standard Xlib functions are not
used, and possibly the data returned into the XpmAttributes using
.BR XpmFreeAttributes (__libmansuffix__).

.SH "SEE ALSO"
.ad l
.nh
.BR XpmCreateImageFromData (__libmansuffix__),
.BR XpmCreateImageFromXpmImage (__libmansuffix__),
.BR XpmFreeAttributes (__libmansuffix__),
.BR XpmReadFileToPixmap (__libmansuffix__)

