/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 * Copyright (c) 2025 Kaustabh Chakraborty <kauschluss@disroot.org>
 */

#ifndef __LINUX_MFD_S2MPU05_H
#define __LINUX_MFD_S2MPU05_H

/* S2MPU05 registers */
enum S2MPU05_reg {
	S2MPU05_REG_ID,
	S2MPU05_REG_INT1,
	S2MPU05_REG_INT2,
	S2MPU05_REG_INT3,
	S2MPU05_REG_INT1M,
	S2MPU05_REG_INT2M,
	S2MPU05_REG_INT3M,
	S2MPU05_REG_ST1,
	S2MPU05_REG_ST2,
	S2MPU05_REG_PWRONSRC,
	S2MPU05_REG_OFFSRC,
	S2MPU05_REG_BU_CHG,
	S2MPU05_REG_RTC_BUF,
	S2MPU05_REG_CTRL1,
	S2MPU05_REG_CTRL2,
	S2MPU05_REG_ETC_TEST,
	S2MPU05_REG_OTP_ADRL,
	S2MPU05_REG_OTP_ADRH,
	S2MPU05_REG_OTP_DATA,
	S2MPU05_REG_MON1SEL,
	S2MPU05_REG_MON2SEL,
	S2MPU05_REG_CTRL3,
	S2MPU05_REG_ETC_OTP,
	S2MPU05_REG_UVLO,
	S2MPU05_REG_TIME_CTRL1,
	S2MPU05_REG_TIME_CTRL2,
	S2MPU05_REG_B1CTRL1,
	S2MPU05_REG_B1CTRL2,
	S2MPU05_REG_B2CTRL1,
	S2MPU05_REG_B2CTRL2,
	S2MPU05_REG_B2CTRL3,
	S2MPU05_REG_B2CTRL4,
	S2MPU05_REG_B3CTRL1,
	S2MPU05_REG_B3CTRL2,
	S2MPU05_REG_B3CTRL3,
	S2MPU05_REG_B4CTRL1,
	S2MPU05_REG_B4CTRL2,
	S2MPU05_REG_B5CTRL1,
	S2MPU05_REG_B5CTRL2,
	S2MPU05_REG_BUCK_RAMP,
	S2MPU05_REG_LDO_DVS1,
	S2MPU05_REG_LDO_DVS9,
	S2MPU05_REG_LDO_DVS10,
	S2MPU05_REG_L1CTRL,
	S2MPU05_REG_L2CTRL,
	S2MPU05_REG_L3CTRL,
	S2MPU05_REG_L4CTRL,
	S2MPU05_REG_L5CTRL,
	S2MPU05_REG_L6CTRL,
	S2MPU05_REG_L7CTRL,
	S2MPU05_REG_L8CTRL,
	S2MPU05_REG_L9CTRL1,
	S2MPU05_REG_L9CTRL2,
	S2MPU05_REG_L10CTRL,
	S2MPU05_REG_L11CTRL1,
	S2MPU05_REG_L11CTRL2,
	S2MPU05_REG_L12CTRL,
	S2MPU05_REG_L13CTRL,
	S2MPU05_REG_L14CTRL,
	S2MPU05_REG_L15CTRL,
	S2MPU05_REG_L16CTRL,
	S2MPU05_REG_L17CTRL1,
	S2MPU05_REG_L17CTRL2,
	S2MPU05_REG_L18CTRL1,
	S2MPU05_REG_L18CTRL2,
	S2MPU05_REG_L19CTRL,
	S2MPU05_REG_L20CTRL,
	S2MPU05_REG_L21CTRL,
	S2MPU05_REG_L22CTRL,
	S2MPU05_REG_L23CTRL,
	S2MPU05_REG_L24CTRL,
	S2MPU05_REG_L25CTRL,
	S2MPU05_REG_L26CTRL,
	S2MPU05_REG_L27CTRL,
	S2MPU05_REG_L28CTRL,
	S2MPU05_REG_L29CTRL,
	S2MPU05_REG_L30CTRL,
	S2MPU05_REG_L31CTRL,
	S2MPU05_REG_L32CTRL,
	S2MPU05_REG_L33CTRL,
	S2MPU05_REG_L34CTRL,
	S2MPU05_REG_L35CTRL,
	S2MPU05_REG_LDO_DSCH1,
	S2MPU05_REG_LDO_DSCH2,
	S2MPU05_REG_LDO_DSCH3,
	S2MPU05_REG_LDO_DSCH4,
	S2MPU05_REG_LDO_DSCH5,
	S2MPU05_REG_LDO_CTRL1,
	S2MPU05_REG_LDO_CTRL2,
	S2MPU05_REG_TCXO_CTRL,
	S2MPU05_REG_SELMIF,
};

/* S2MPU05 regulator ids */
enum S2MPU05_regulators {
	S2MPU05_LDO1,
	S2MPU05_LDO2,
	S2MPU05_LDO3,
	S2MPU05_LDO4,
	S2MPU05_LDO5,
	S2MPU05_LDO6,
	S2MPU05_LDO7,
	S2MPU05_LDO8,
	S2MPU05_LDO9,
	S2MPU05_LDO10,
	S2MPU05_LDO11,
	S2MPU05_LDO12,
	S2MPU05_LDO13,
	S2MPU05_LDO14,
	S2MPU05_LDO15,
	S2MPU05_LDO16,
	S2MPU05_LDO17,
	S2MPU05_LDO18,
	S2MPU05_LDO19,
	S2MPU05_LDO20,
	S2MPU05_LDO21,
	S2MPU05_LDO22,
	S2MPU05_LDO23,
	S2MPU05_LDO24,
	S2MPU05_LDO25,
	S2MPU05_LDO26,
	S2MPU05_LDO27,
	S2MPU05_LDO28,
	S2MPU05_LDO29,
	S2MPU05_LDO30,
	S2MPU05_LDO31,
	S2MPU05_LDO32,
	S2MPU05_LDO33,
	S2MPU05_LDO34,
	S2MPU05_LDO35,
	S2MPU05_BUCK1,
	S2MPU05_BUCK2,
	S2MPU05_BUCK3,
	S2MPU05_BUCK4,
	S2MPU05_BUCK5,

	S2MPU05_REGULATOR_MAX,
};

#define S2MPU05_SW_ENABLE_MASK	0x03

#define S2MPU05_ENABLE_TIME_LDO		128
#define S2MPU05_ENABLE_TIME_BUCK1	110
#define S2MPU05_ENABLE_TIME_BUCK2	110
#define S2MPU05_ENABLE_TIME_BUCK3	110
#define S2MPU05_ENABLE_TIME_BUCK4	150
#define S2MPU05_ENABLE_TIME_BUCK5	150

#define S2MPU05_LDO_MIN1	800000
#define S2MPU05_LDO_MIN2	1800000
#define S2MPU05_LDO_MIN3	400000
#define S2MPU05_LDO_STEP1	12500
#define S2MPU05_LDO_STEP2	25000

#define S2MPU05_BUCK_MIN1	400000
#define S2MPU05_BUCK_MIN2	600000
#define S2MPU05_BUCK_STEP1	6250
#define S2MPU05_BUCK_STEP2	12500

#define S2MPU05_RAMP_DELAY	12000	/* uV/uS */

#define S2MPU05_ENABLE_SHIFT	6
#define S2MPU05_ENABLE_MASK	(0x03 << S2MPU05_ENABLE_SHIFT)

#define S2MPU05_LDO_VSEL_MASK	0x3F
#define S2MPU05_BUCK_VSEL_MASK	0xFF
#define S2MPU05_LDO_N_VOLTAGES	(S2MPU05_LDO_VSEL_MASK + 1)
#define S2MPU05_BUCK_N_VOLTAGES (S2MPU05_BUCK_VSEL_MASK + 1)

#define S2MPU05_PMIC_EN_SHIFT	6

#endif /*  __LINUX_MFD_S2MPU05_H */
