#define XERR "memoryaccess"
#include "memoryaccess.ih"

    // by cptsizes.cc

    // each segment is at least 1 MB large, 10 segments can be
    // used before extend is called.

// static
void MemoryAccess::megaBytes(size_t *nBlocks, size_t *blockSize, 
                             size_t factor) 
{
    size_t ppm = divPlus(1024 * 1024, s_pageSize);  // #pages per MB

                                                    // segm. size >= x MB
    *blockSize = divPlus(factor, 10) * ppm * s_pageSize; 

    *nBlocks = max(s_minimum,       // #potentially avail. segments
                   divPlus(factor * 1024 * 1024, *blockSize));
}
