% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_format.R
\name{text_format}
\alias{text_format}
\alias{text_fullstop}
\alias{text_lastchar}
\alias{text_concatenate}
\alias{text_paste}
\alias{text_remove}
\alias{text_wrap}
\title{Convenient text formatting functionalities}
\usage{
text_format(
  text,
  sep = ", ",
  last = " and ",
  width = NULL,
  enclose = NULL,
  ...
)

text_fullstop(text)

text_lastchar(text, n = 1)

text_concatenate(text, sep = ", ", last = " and ", enclose = NULL)

text_paste(text, text2 = NULL, sep = ", ", enclose = NULL, ...)

text_remove(text, pattern = "", ...)

text_wrap(text, width = NULL, ...)
}
\arguments{
\item{text, text2}{A character string.}

\item{sep}{Separator.}

\item{last}{Last separator.}

\item{width}{Positive integer giving the target column width for wrapping
lines in the output. Can be "auto", in which case it will select 90\\% of the
default width.}

\item{enclose}{Character that will be used to wrap elements of \code{text}, so
these can be, e.g., enclosed with quotes or backticks. If \code{NULL} (default),
text elements will not be enclosed.}

\item{...}{Other arguments to be passed to or from other functions.}

\item{n}{The number of characters to find.}

\item{pattern}{Regex pattern to remove from \code{text}.}
}
\value{
A character string.
}
\description{
Convenience functions to manipulate and format text.
}
\examples{
# Add full stop if missing
text_fullstop(c("something", "something else."))

# Find last characters
text_lastchar(c("ABC", "DEF"), n = 2)

# Smart concatenation
text_concatenate(c("First", "Second", "Last"))
text_concatenate(c("First", "Second", "Last"), last = " or ", enclose = "`")

# Remove parts of string
text_remove(c("one!", "two", "three!"), "!")

# Wrap text
long_text <- paste(rep("abc ", 100), collapse = "")
cat(text_wrap(long_text, width = 50))

# Paste with optional separator
text_paste(c("A", "", "B"), c("42", "42", "42"))
}
